/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceSecretVerifierConfigType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeviceSecretVerifierConfigTypeMarshaller {
    private static final MarshallingInfo<String> PASSWORDVERIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PasswordVerifier").isBinary(false).build();
    private static final MarshallingInfo<String> SALT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Salt").isBinary(false).build();
    private static final DeviceSecretVerifierConfigTypeMarshaller INSTANCE = new DeviceSecretVerifierConfigTypeMarshaller();

    private DeviceSecretVerifierConfigTypeMarshaller() {
    }

    public static DeviceSecretVerifierConfigTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeviceSecretVerifierConfigType deviceSecretVerifierConfigType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deviceSecretVerifierConfigType, (String)"deviceSecretVerifierConfigType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deviceSecretVerifierConfigType.passwordVerifier(), PASSWORDVERIFIER_BINDING);
            protocolMarshaller.marshall((Object)deviceSecretVerifierConfigType.salt(), SALT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

