/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceType;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AttributeTypeUnmarshaller;

public class DeviceTypeUnmarshaller
implements Unmarshaller<DeviceType, JsonUnmarshallerContext> {
    private static final DeviceTypeUnmarshaller INSTANCE = new DeviceTypeUnmarshaller();

    public DeviceType unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeviceType.Builder deviceTypeBuilder = DeviceType.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DeviceKey", targetDepth)) {
                    context.nextToken();
                    deviceTypeBuilder.deviceKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DeviceAttributes", targetDepth)) {
                    context.nextToken();
                    deviceTypeBuilder.deviceAttributes(new ListUnmarshaller((Unmarshaller)AttributeTypeUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("DeviceCreateDate", targetDepth)) {
                    context.nextToken();
                    deviceTypeBuilder.deviceCreateDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("DeviceLastModifiedDate", targetDepth)) {
                    context.nextToken();
                    deviceTypeBuilder.deviceLastModifiedDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("DeviceLastAuthenticatedDate", targetDepth)) {
                    context.nextToken();
                    deviceTypeBuilder.deviceLastAuthenticatedDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DeviceType)deviceTypeBuilder.build();
    }

    public static DeviceTypeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

