/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DomainDescriptionType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DomainDescriptionTypeMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> AWSACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AWSAccountId").isBinary(false).build();
    private static final MarshallingInfo<String> DOMAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Domain").isBinary(false).build();
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Bucket").isBinary(false).build();
    private static final MarshallingInfo<String> CLOUDFRONTDISTRIBUTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudFrontDistribution").isBinary(false).build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final DomainDescriptionTypeMarshaller INSTANCE = new DomainDescriptionTypeMarshaller();

    private DomainDescriptionTypeMarshaller() {
    }

    public static DomainDescriptionTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DomainDescriptionType domainDescriptionType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)domainDescriptionType, (String)"domainDescriptionType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)domainDescriptionType.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)domainDescriptionType.awsAccountId(), AWSACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)domainDescriptionType.domain(), DOMAIN_BINDING);
            protocolMarshaller.marshall((Object)domainDescriptionType.s3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall((Object)domainDescriptionType.cloudFrontDistribution(), CLOUDFRONTDISTRIBUTION_BINDING);
            protocolMarshaller.marshall((Object)domainDescriptionType.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)domainDescriptionType.statusAsString(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

