/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ForgotPasswordRequestModelMarshaller {
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").isBinary(false).build();
    private static final MarshallingInfo<String> SECRETHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretHash").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final ForgotPasswordRequestModelMarshaller INSTANCE = new ForgotPasswordRequestModelMarshaller();

    private ForgotPasswordRequestModelMarshaller() {
    }

    public static ForgotPasswordRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ForgotPasswordRequest forgotPasswordRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)forgotPasswordRequest), (String)"forgotPasswordRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)forgotPasswordRequest.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)forgotPasswordRequest.secretHash(), SECRETHASH_BINDING);
            protocolMarshaller.marshall((Object)forgotPasswordRequest.username(), USERNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

