/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class IdentityProviderTypeMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> PROVIDERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderName").isBinary(false).build();
    private static final MarshallingInfo<String> PROVIDERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderType").isBinary(false).build();
    private static final MarshallingInfo<Map> PROVIDERDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderDetails").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTEMAPPING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeMapping").isBinary(false).build();
    private static final MarshallingInfo<List> IDPIDENTIFIERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdpIdentifiers").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final IdentityProviderTypeMarshaller INSTANCE = new IdentityProviderTypeMarshaller();

    private IdentityProviderTypeMarshaller() {
    }

    public static IdentityProviderTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(IdentityProviderType identityProviderType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)identityProviderType, (String)"identityProviderType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)identityProviderType.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)identityProviderType.providerName(), PROVIDERNAME_BINDING);
            protocolMarshaller.marshall((Object)identityProviderType.providerTypeAsString(), PROVIDERTYPE_BINDING);
            protocolMarshaller.marshall(identityProviderType.providerDetails(), PROVIDERDETAILS_BINDING);
            protocolMarshaller.marshall(identityProviderType.attributeMapping(), ATTRIBUTEMAPPING_BINDING);
            protocolMarshaller.marshall(identityProviderType.idpIdentifiers(), IDPIDENTIFIERS_BINDING);
            protocolMarshaller.marshall((Object)identityProviderType.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)identityProviderType.creationDate(), CREATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

