/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListDevicesRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCESSTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();
    private static final MarshallingInfo<String> PAGINATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PaginationToken").isBinary(false).build();
    private static final ListDevicesRequestModelMarshaller INSTANCE = new ListDevicesRequestModelMarshaller();

    private ListDevicesRequestModelMarshaller() {
    }

    public static ListDevicesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListDevicesRequest listDevicesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listDevicesRequest), (String)"listDevicesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listDevicesRequest.accessToken(), ACCESSTOKEN_BINDING);
            protocolMarshaller.marshall((Object)listDevicesRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)listDevicesRequest.paginationToken(), PAGINATIONTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

