/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListUsersRequestModelMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTESTOGET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributesToGet").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();
    private static final MarshallingInfo<String> PAGINATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PaginationToken").isBinary(false).build();
    private static final MarshallingInfo<String> FILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filter").isBinary(false).build();
    private static final ListUsersRequestModelMarshaller INSTANCE = new ListUsersRequestModelMarshaller();

    private ListUsersRequestModelMarshaller() {
    }

    public static ListUsersRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListUsersRequest listUsersRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listUsersRequest), (String)"listUsersRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listUsersRequest.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall(listUsersRequest.attributesToGet(), ATTRIBUTESTOGET_BINDING);
            protocolMarshaller.marshall((Object)listUsersRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)listUsersRequest.paginationToken(), PAGINATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)listUsersRequest.filter(), FILTER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

