/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.NewDeviceMetadataType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NewDeviceMetadataTypeMarshaller {
    private static final MarshallingInfo<String> DEVICEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceKey").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICEGROUPKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceGroupKey").isBinary(false).build();
    private static final NewDeviceMetadataTypeMarshaller INSTANCE = new NewDeviceMetadataTypeMarshaller();

    private NewDeviceMetadataTypeMarshaller() {
    }

    public static NewDeviceMetadataTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NewDeviceMetadataType newDeviceMetadataType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)newDeviceMetadataType, (String)"newDeviceMetadataType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)newDeviceMetadataType.deviceKey(), DEVICEKEY_BINDING);
            protocolMarshaller.marshall((Object)newDeviceMetadataType.deviceGroupKey(), DEVICEGROUPKEY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

