/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordPolicyType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PasswordPolicyTypeMarshaller {
    private static final MarshallingInfo<Integer> MINIMUMLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinimumLength").isBinary(false).build();
    private static final MarshallingInfo<Boolean> REQUIREUPPERCASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequireUppercase").isBinary(false).build();
    private static final MarshallingInfo<Boolean> REQUIRELOWERCASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequireLowercase").isBinary(false).build();
    private static final MarshallingInfo<Boolean> REQUIRENUMBERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequireNumbers").isBinary(false).build();
    private static final MarshallingInfo<Boolean> REQUIRESYMBOLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequireSymbols").isBinary(false).build();
    private static final PasswordPolicyTypeMarshaller INSTANCE = new PasswordPolicyTypeMarshaller();

    private PasswordPolicyTypeMarshaller() {
    }

    public static PasswordPolicyTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PasswordPolicyType passwordPolicyType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)passwordPolicyType, (String)"passwordPolicyType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)passwordPolicyType.minimumLength(), MINIMUMLENGTH_BINDING);
            protocolMarshaller.marshall((Object)passwordPolicyType.requireUppercase(), REQUIREUPPERCASE_BINDING);
            protocolMarshaller.marshall((Object)passwordPolicyType.requireLowercase(), REQUIRELOWERCASE_BINDING);
            protocolMarshaller.marshall((Object)passwordPolicyType.requireNumbers(), REQUIRENUMBERS_BINDING);
            protocolMarshaller.marshall((Object)passwordPolicyType.requireSymbols(), REQUIRESYMBOLS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

