/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderUserIdentifierType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProviderUserIdentifierTypeMarshaller {
    private static final MarshallingInfo<String> PROVIDERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderName").isBinary(false).build();
    private static final MarshallingInfo<String> PROVIDERATTRIBUTENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderAttributeName").isBinary(false).build();
    private static final MarshallingInfo<String> PROVIDERATTRIBUTEVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderAttributeValue").isBinary(false).build();
    private static final ProviderUserIdentifierTypeMarshaller INSTANCE = new ProviderUserIdentifierTypeMarshaller();

    private ProviderUserIdentifierTypeMarshaller() {
    }

    public static ProviderUserIdentifierTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProviderUserIdentifierType providerUserIdentifierType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)providerUserIdentifierType, (String)"providerUserIdentifierType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)providerUserIdentifierType.providerName(), PROVIDERNAME_BINDING);
            protocolMarshaller.marshall((Object)providerUserIdentifierType.providerAttributeName(), PROVIDERATTRIBUTENAME_BINDING);
            protocolMarshaller.marshall((Object)providerUserIdentifierType.providerAttributeValue(), PROVIDERATTRIBUTEVALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

