/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerScopeType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceServerScopeTypeMarshaller {
    private static final MarshallingInfo<String> SCOPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScopeName").isBinary(false).build();
    private static final MarshallingInfo<String> SCOPEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScopeDescription").isBinary(false).build();
    private static final ResourceServerScopeTypeMarshaller INSTANCE = new ResourceServerScopeTypeMarshaller();

    private ResourceServerScopeTypeMarshaller() {
    }

    public static ResourceServerScopeTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceServerScopeType resourceServerScopeType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceServerScopeType, (String)"resourceServerScopeType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceServerScopeType.scopeName(), SCOPENAME_BINDING);
            protocolMarshaller.marshall((Object)resourceServerScopeType.scopeDescription(), SCOPEDESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

