/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SchemaAttributeType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SchemaAttributeTypeMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> ATTRIBUTEDATATYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeDataType").isBinary(false).build();
    private static final MarshallingInfo<Boolean> DEVELOPERONLYATTRIBUTE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeveloperOnlyAttribute").isBinary(false).build();
    private static final MarshallingInfo<Boolean> MUTABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mutable").isBinary(false).build();
    private static final MarshallingInfo<Boolean> REQUIRED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Required").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NUMBERATTRIBUTECONSTRAINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberAttributeConstraints").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STRINGATTRIBUTECONSTRAINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StringAttributeConstraints").isBinary(false).build();
    private static final SchemaAttributeTypeMarshaller INSTANCE = new SchemaAttributeTypeMarshaller();

    private SchemaAttributeTypeMarshaller() {
    }

    public static SchemaAttributeTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SchemaAttributeType schemaAttributeType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)schemaAttributeType, (String)"schemaAttributeType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)schemaAttributeType.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)schemaAttributeType.attributeDataTypeAsString(), ATTRIBUTEDATATYPE_BINDING);
            protocolMarshaller.marshall((Object)schemaAttributeType.developerOnlyAttribute(), DEVELOPERONLYATTRIBUTE_BINDING);
            protocolMarshaller.marshall((Object)schemaAttributeType.mutable(), MUTABLE_BINDING);
            protocolMarshaller.marshall((Object)schemaAttributeType.required(), REQUIRED_BINDING);
            protocolMarshaller.marshall((Object)schemaAttributeType.numberAttributeConstraints(), NUMBERATTRIBUTECONSTRAINTS_BINDING);
            protocolMarshaller.marshall((Object)schemaAttributeType.stringAttributeConstraints(), STRINGATTRIBUTECONSTRAINTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

