/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SignUpRequestModelMarshaller {
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").isBinary(false).build();
    private static final MarshallingInfo<String> SECRETHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretHash").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Password").isBinary(false).build();
    private static final MarshallingInfo<List> USERATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserAttributes").isBinary(false).build();
    private static final MarshallingInfo<List> VALIDATIONDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationData").isBinary(false).build();
    private static final SignUpRequestModelMarshaller INSTANCE = new SignUpRequestModelMarshaller();

    private SignUpRequestModelMarshaller() {
    }

    public static SignUpRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SignUpRequest signUpRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)signUpRequest), (String)"signUpRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)signUpRequest.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)signUpRequest.secretHash(), SECRETHASH_BINDING);
            protocolMarshaller.marshall((Object)signUpRequest.username(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)signUpRequest.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall(signUpRequest.userAttributes(), USERATTRIBUTES_BINDING);
            protocolMarshaller.marshall(signUpRequest.validationData(), VALIDATIONDATA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

