/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SmsConfigurationType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SmsConfigurationTypeMarshaller {
    private static final MarshallingInfo<String> SNSCALLERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnsCallerArn").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalId").isBinary(false).build();
    private static final SmsConfigurationTypeMarshaller INSTANCE = new SmsConfigurationTypeMarshaller();

    private SmsConfigurationTypeMarshaller() {
    }

    public static SmsConfigurationTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SmsConfigurationType smsConfigurationType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)smsConfigurationType, (String)"smsConfigurationType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)smsConfigurationType.snsCallerArn(), SNSCALLERARN_BINDING);
            protocolMarshaller.marshall((Object)smsConfigurationType.externalId(), EXTERNALID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

