/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UserPoolClientDescriptionMarshaller {
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").isBinary(false).build();
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientName").isBinary(false).build();
    private static final UserPoolClientDescriptionMarshaller INSTANCE = new UserPoolClientDescriptionMarshaller();

    private UserPoolClientDescriptionMarshaller() {
    }

    public static UserPoolClientDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UserPoolClientDescription userPoolClientDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)userPoolClientDescription, (String)"userPoolClientDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)userPoolClientDescription.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)userPoolClientDescription.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)userPoolClientDescription.clientName(), CLIENTNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

