/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UserPoolClientTypeMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientName").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTSECRET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientSecret").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final MarshallingInfo<Integer> REFRESHTOKENVALIDITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RefreshTokenValidity").isBinary(false).build();
    private static final MarshallingInfo<List> READATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReadAttributes").isBinary(false).build();
    private static final MarshallingInfo<List> WRITEATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WriteAttributes").isBinary(false).build();
    private static final MarshallingInfo<List> EXPLICITAUTHFLOWS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExplicitAuthFlows").isBinary(false).build();
    private static final MarshallingInfo<List> SUPPORTEDIDENTITYPROVIDERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedIdentityProviders").isBinary(false).build();
    private static final MarshallingInfo<List> CALLBACKURLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CallbackURLs").isBinary(false).build();
    private static final MarshallingInfo<List> LOGOUTURLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogoutURLs").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTREDIRECTURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultRedirectURI").isBinary(false).build();
    private static final MarshallingInfo<List> ALLOWEDOAUTHFLOWS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedOAuthFlows").isBinary(false).build();
    private static final MarshallingInfo<List> ALLOWEDOAUTHSCOPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedOAuthScopes").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ALLOWEDOAUTHFLOWSUSERPOOLCLIENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedOAuthFlowsUserPoolClient").isBinary(false).build();
    private static final UserPoolClientTypeMarshaller INSTANCE = new UserPoolClientTypeMarshaller();

    private UserPoolClientTypeMarshaller() {
    }

    public static UserPoolClientTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UserPoolClientType userPoolClientType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)userPoolClientType, (String)"userPoolClientType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)userPoolClientType.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)userPoolClientType.clientName(), CLIENTNAME_BINDING);
            protocolMarshaller.marshall((Object)userPoolClientType.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)userPoolClientType.clientSecret(), CLIENTSECRET_BINDING);
            protocolMarshaller.marshall((Object)userPoolClientType.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)userPoolClientType.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)userPoolClientType.refreshTokenValidity(), REFRESHTOKENVALIDITY_BINDING);
            protocolMarshaller.marshall(userPoolClientType.readAttributes(), READATTRIBUTES_BINDING);
            protocolMarshaller.marshall(userPoolClientType.writeAttributes(), WRITEATTRIBUTES_BINDING);
            protocolMarshaller.marshall(userPoolClientType.explicitAuthFlowsAsStrings(), EXPLICITAUTHFLOWS_BINDING);
            protocolMarshaller.marshall(userPoolClientType.supportedIdentityProviders(), SUPPORTEDIDENTITYPROVIDERS_BINDING);
            protocolMarshaller.marshall(userPoolClientType.callbackURLs(), CALLBACKURLS_BINDING);
            protocolMarshaller.marshall(userPoolClientType.logoutURLs(), LOGOUTURLS_BINDING);
            protocolMarshaller.marshall((Object)userPoolClientType.defaultRedirectURI(), DEFAULTREDIRECTURI_BINDING);
            protocolMarshaller.marshall(userPoolClientType.allowedOAuthFlowsAsStrings(), ALLOWEDOAUTHFLOWS_BINDING);
            protocolMarshaller.marshall(userPoolClientType.allowedOAuthScopes(), ALLOWEDOAUTHSCOPES_BINDING);
            protocolMarshaller.marshall((Object)userPoolClientType.allowedOAuthFlowsUserPoolClient(), ALLOWEDOAUTHFLOWSUSERPOOLCLIENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

