/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponsesTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RespondToAuthChallengeRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, RespondToAuthChallengeRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RespondToAuthChallengeRequest.getter(RespondToAuthChallengeRequest::clientId)).setter(RespondToAuthChallengeRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> CHALLENGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RespondToAuthChallengeRequest.getter(RespondToAuthChallengeRequest::challengeNameAsString)).setter(RespondToAuthChallengeRequest.setter(Builder::challengeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeName").build()}).build();
    private static final SdkField<String> SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RespondToAuthChallengeRequest.getter(RespondToAuthChallengeRequest::session)).setter(RespondToAuthChallengeRequest.setter(Builder::session)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()}).build();
    private static final SdkField<Map<String, String>> CHALLENGE_RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(RespondToAuthChallengeRequest.getter(RespondToAuthChallengeRequest::challengeResponses)).setter(RespondToAuthChallengeRequest.setter(Builder::challengeResponses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeResponses").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, CHALLENGE_NAME_FIELD, SESSION_FIELD, CHALLENGE_RESPONSES_FIELD));
    private final String clientId;
    private final String challengeName;
    private final String session;
    private final Map<String, String> challengeResponses;

    private RespondToAuthChallengeRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.challengeName = builder.challengeName;
        this.session = builder.session;
        this.challengeResponses = builder.challengeResponses;
    }

    public String clientId() {
        return this.clientId;
    }

    public ChallengeNameType challengeName() {
        return ChallengeNameType.fromValue(this.challengeName);
    }

    public String challengeNameAsString() {
        return this.challengeName;
    }

    public String session() {
        return this.session;
    }

    public Map<String, String> challengeResponses() {
        return this.challengeResponses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.session());
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeResponses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondToAuthChallengeRequest)) {
            return false;
        }
        RespondToAuthChallengeRequest other = (RespondToAuthChallengeRequest)((Object)obj);
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.challengeNameAsString(), other.challengeNameAsString()) && Objects.equals(this.session(), other.session()) && Objects.equals(this.challengeResponses(), other.challengeResponses());
    }

    public String toString() {
        return ToString.builder((String)"RespondToAuthChallengeRequest").add("ClientId", (Object)this.clientId()).add("ChallengeName", (Object)this.challengeNameAsString()).add("Session", (Object)this.session()).add("ChallengeResponses", this.challengeResponses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "ChallengeName": {
                return Optional.ofNullable(clazz.cast(this.challengeNameAsString()));
            }
            case "Session": {
                return Optional.ofNullable(clazz.cast(this.session()));
            }
            case "ChallengeResponses": {
                return Optional.ofNullable(clazz.cast(this.challengeResponses()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RespondToAuthChallengeRequest, T> g) {
        return obj -> g.apply((RespondToAuthChallengeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String clientId;
        private String challengeName;
        private String session;
        private Map<String, String> challengeResponses = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RespondToAuthChallengeRequest model) {
            super(model);
            this.clientId(model.clientId);
            this.challengeName(model.challengeName);
            this.session(model.session);
            this.challengeResponses(model.challengeResponses);
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getChallengeName() {
            return this.challengeName;
        }

        @Override
        public final Builder challengeName(String challengeName) {
            this.challengeName = challengeName;
            return this;
        }

        @Override
        public final Builder challengeName(ChallengeNameType challengeName) {
            this.challengeName(challengeName.toString());
            return this;
        }

        public final void setChallengeName(String challengeName) {
            this.challengeName = challengeName;
        }

        public final String getSession() {
            return this.session;
        }

        @Override
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        public final Map<String, String> getChallengeResponses() {
            return this.challengeResponses;
        }

        @Override
        public final Builder challengeResponses(Map<String, String> challengeResponses) {
            this.challengeResponses = ChallengeResponsesTypeCopier.copy(challengeResponses);
            return this;
        }

        public final void setChallengeResponses(Map<String, String> challengeResponses) {
            this.challengeResponses = ChallengeResponsesTypeCopier.copy(challengeResponses);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RespondToAuthChallengeRequest build() {
            return new RespondToAuthChallengeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RespondToAuthChallengeRequest> {
        public Builder clientId(String var1);

        public Builder challengeName(String var1);

        public Builder challengeName(ChallengeNameType var1);

        public Builder session(String var1);

        public Builder challengeResponses(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

