/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminListUserAuthEventsResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<AdminListUserAuthEventsResponse.Builder, AdminListUserAuthEventsResponse> {
    private static final SdkField<List<AuthEventType>> AUTH_EVENTS_FIELD = SdkField
            .<List<AuthEventType>> builder(MarshallingType.LIST)
            .getter(getter(AdminListUserAuthEventsResponse::authEvents))
            .setter(setter(Builder::authEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthEventType> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthEventType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminListUserAuthEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_EVENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AuthEventType> authEvents;

    private final String nextToken;

    private AdminListUserAuthEventsResponse(BuilderImpl builder) {
        super(builder);
        this.authEvents = builder.authEvents;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The response object. It includes the <code>EventID</code>, <code>EventType</code>, <code>CreationDate</code>,
     * <code>EventRisk</code>, and <code>EventResponse</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The response object. It includes the <code>EventID</code>, <code>EventType</code>,
     *         <code>CreationDate</code>, <code>EventRisk</code>, and <code>EventResponse</code>.
     */
    public List<AuthEventType> authEvents() {
        return authEvents;
    }

    /**
     * <p>
     * A pagination token.
     * </p>
     * 
     * @return A pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authEvents());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminListUserAuthEventsResponse)) {
            return false;
        }
        AdminListUserAuthEventsResponse other = (AdminListUserAuthEventsResponse) obj;
        return Objects.equals(authEvents(), other.authEvents()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("AdminListUserAuthEventsResponse").add("AuthEvents", authEvents()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthEvents":
            return Optional.ofNullable(clazz.cast(authEvents()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminListUserAuthEventsResponse, T> g) {
        return obj -> g.apply((AdminListUserAuthEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AdminListUserAuthEventsResponse> {
        /**
         * <p>
         * The response object. It includes the <code>EventID</code>, <code>EventType</code>, <code>CreationDate</code>,
         * <code>EventRisk</code>, and <code>EventResponse</code>.
         * </p>
         * 
         * @param authEvents
         *        The response object. It includes the <code>EventID</code>, <code>EventType</code>,
         *        <code>CreationDate</code>, <code>EventRisk</code>, and <code>EventResponse</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authEvents(Collection<AuthEventType> authEvents);

        /**
         * <p>
         * The response object. It includes the <code>EventID</code>, <code>EventType</code>, <code>CreationDate</code>,
         * <code>EventRisk</code>, and <code>EventResponse</code>.
         * </p>
         * 
         * @param authEvents
         *        The response object. It includes the <code>EventID</code>, <code>EventType</code>,
         *        <code>CreationDate</code>, <code>EventRisk</code>, and <code>EventResponse</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authEvents(AuthEventType... authEvents);

        /**
         * <p>
         * The response object. It includes the <code>EventID</code>, <code>EventType</code>, <code>CreationDate</code>,
         * <code>EventRisk</code>, and <code>EventResponse</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AuthEventType>.Builder} avoiding the need
         * to create one manually via {@link List<AuthEventType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AuthEventType>.Builder#build()} is called immediately and
         * its result is passed to {@link #authEvents(List<AuthEventType>)}.
         * 
         * @param authEvents
         *        a consumer that will call methods on {@link List<AuthEventType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authEvents(List<AuthEventType>)
         */
        Builder authEvents(Consumer<AuthEventType.Builder>... authEvents);

        /**
         * <p>
         * A pagination token.
         * </p>
         * 
         * @param nextToken
         *        A pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private List<AuthEventType> authEvents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminListUserAuthEventsResponse model) {
            super(model);
            authEvents(model.authEvents);
            nextToken(model.nextToken);
        }

        public final Collection<AuthEventType.Builder> getAuthEvents() {
            return authEvents != null ? authEvents.stream().map(AuthEventType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder authEvents(Collection<AuthEventType> authEvents) {
            this.authEvents = AuthEventsTypeCopier.copy(authEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authEvents(AuthEventType... authEvents) {
            authEvents(Arrays.asList(authEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authEvents(Consumer<AuthEventType.Builder>... authEvents) {
            authEvents(Stream.of(authEvents).map(c -> AuthEventType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAuthEvents(Collection<AuthEventType.BuilderImpl> authEvents) {
            this.authEvents = AuthEventsTypeCopier.copyFromBuilder(authEvents);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public AdminListUserAuthEventsResponse build() {
            return new AdminListUserAuthEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
