/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration for AWS Lambda triggers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaConfigType implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaConfigType.Builder, LambdaConfigType> {
    private static final SdkField<String> PRE_SIGN_UP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaConfigType::preSignUp)).setter(setter(Builder::preSignUp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSignUp").build()).build();

    private static final SdkField<String> CUSTOM_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaConfigType::customMessage)).setter(setter(Builder::customMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomMessage").build()).build();

    private static final SdkField<String> POST_CONFIRMATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaConfigType::postConfirmation)).setter(setter(Builder::postConfirmation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostConfirmation").build()).build();

    private static final SdkField<String> PRE_AUTHENTICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaConfigType::preAuthentication)).setter(setter(Builder::preAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreAuthentication").build()).build();

    private static final SdkField<String> POST_AUTHENTICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaConfigType::postAuthentication)).setter(setter(Builder::postAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostAuthentication").build())
            .build();

    private static final SdkField<String> DEFINE_AUTH_CHALLENGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaConfigType::defineAuthChallenge)).setter(setter(Builder::defineAuthChallenge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefineAuthChallenge").build())
            .build();

    private static final SdkField<String> CREATE_AUTH_CHALLENGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaConfigType::createAuthChallenge)).setter(setter(Builder::createAuthChallenge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAuthChallenge").build())
            .build();

    private static final SdkField<String> VERIFY_AUTH_CHALLENGE_RESPONSE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaConfigType::verifyAuthChallengeResponse))
            .setter(setter(Builder::verifyAuthChallengeResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifyAuthChallengeResponse")
                    .build()).build();

    private static final SdkField<String> PRE_TOKEN_GENERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaConfigType::preTokenGeneration)).setter(setter(Builder::preTokenGeneration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreTokenGeneration").build())
            .build();

    private static final SdkField<String> USER_MIGRATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaConfigType::userMigration)).setter(setter(Builder::userMigration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMigration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRE_SIGN_UP_FIELD,
            CUSTOM_MESSAGE_FIELD, POST_CONFIRMATION_FIELD, PRE_AUTHENTICATION_FIELD, POST_AUTHENTICATION_FIELD,
            DEFINE_AUTH_CHALLENGE_FIELD, CREATE_AUTH_CHALLENGE_FIELD, VERIFY_AUTH_CHALLENGE_RESPONSE_FIELD,
            PRE_TOKEN_GENERATION_FIELD, USER_MIGRATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String preSignUp;

    private final String customMessage;

    private final String postConfirmation;

    private final String preAuthentication;

    private final String postAuthentication;

    private final String defineAuthChallenge;

    private final String createAuthChallenge;

    private final String verifyAuthChallengeResponse;

    private final String preTokenGeneration;

    private final String userMigration;

    private LambdaConfigType(BuilderImpl builder) {
        this.preSignUp = builder.preSignUp;
        this.customMessage = builder.customMessage;
        this.postConfirmation = builder.postConfirmation;
        this.preAuthentication = builder.preAuthentication;
        this.postAuthentication = builder.postAuthentication;
        this.defineAuthChallenge = builder.defineAuthChallenge;
        this.createAuthChallenge = builder.createAuthChallenge;
        this.verifyAuthChallengeResponse = builder.verifyAuthChallengeResponse;
        this.preTokenGeneration = builder.preTokenGeneration;
        this.userMigration = builder.userMigration;
    }

    /**
     * <p>
     * A pre-registration AWS Lambda trigger.
     * </p>
     * 
     * @return A pre-registration AWS Lambda trigger.
     */
    public String preSignUp() {
        return preSignUp;
    }

    /**
     * <p>
     * A custom Message AWS Lambda trigger.
     * </p>
     * 
     * @return A custom Message AWS Lambda trigger.
     */
    public String customMessage() {
        return customMessage;
    }

    /**
     * <p>
     * A post-confirmation AWS Lambda trigger.
     * </p>
     * 
     * @return A post-confirmation AWS Lambda trigger.
     */
    public String postConfirmation() {
        return postConfirmation;
    }

    /**
     * <p>
     * A pre-authentication AWS Lambda trigger.
     * </p>
     * 
     * @return A pre-authentication AWS Lambda trigger.
     */
    public String preAuthentication() {
        return preAuthentication;
    }

    /**
     * <p>
     * A post-authentication AWS Lambda trigger.
     * </p>
     * 
     * @return A post-authentication AWS Lambda trigger.
     */
    public String postAuthentication() {
        return postAuthentication;
    }

    /**
     * <p>
     * Defines the authentication challenge.
     * </p>
     * 
     * @return Defines the authentication challenge.
     */
    public String defineAuthChallenge() {
        return defineAuthChallenge;
    }

    /**
     * <p>
     * Creates an authentication challenge.
     * </p>
     * 
     * @return Creates an authentication challenge.
     */
    public String createAuthChallenge() {
        return createAuthChallenge;
    }

    /**
     * <p>
     * Verifies the authentication challenge response.
     * </p>
     * 
     * @return Verifies the authentication challenge response.
     */
    public String verifyAuthChallengeResponse() {
        return verifyAuthChallengeResponse;
    }

    /**
     * <p>
     * A Lambda trigger that is invoked before token generation.
     * </p>
     * 
     * @return A Lambda trigger that is invoked before token generation.
     */
    public String preTokenGeneration() {
        return preTokenGeneration;
    }

    /**
     * <p>
     * The user migration Lambda config type.
     * </p>
     * 
     * @return The user migration Lambda config type.
     */
    public String userMigration() {
        return userMigration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(preSignUp());
        hashCode = 31 * hashCode + Objects.hashCode(customMessage());
        hashCode = 31 * hashCode + Objects.hashCode(postConfirmation());
        hashCode = 31 * hashCode + Objects.hashCode(preAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(postAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(defineAuthChallenge());
        hashCode = 31 * hashCode + Objects.hashCode(createAuthChallenge());
        hashCode = 31 * hashCode + Objects.hashCode(verifyAuthChallengeResponse());
        hashCode = 31 * hashCode + Objects.hashCode(preTokenGeneration());
        hashCode = 31 * hashCode + Objects.hashCode(userMigration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaConfigType)) {
            return false;
        }
        LambdaConfigType other = (LambdaConfigType) obj;
        return Objects.equals(preSignUp(), other.preSignUp()) && Objects.equals(customMessage(), other.customMessage())
                && Objects.equals(postConfirmation(), other.postConfirmation())
                && Objects.equals(preAuthentication(), other.preAuthentication())
                && Objects.equals(postAuthentication(), other.postAuthentication())
                && Objects.equals(defineAuthChallenge(), other.defineAuthChallenge())
                && Objects.equals(createAuthChallenge(), other.createAuthChallenge())
                && Objects.equals(verifyAuthChallengeResponse(), other.verifyAuthChallengeResponse())
                && Objects.equals(preTokenGeneration(), other.preTokenGeneration())
                && Objects.equals(userMigration(), other.userMigration());
    }

    @Override
    public String toString() {
        return ToString.builder("LambdaConfigType").add("PreSignUp", preSignUp()).add("CustomMessage", customMessage())
                .add("PostConfirmation", postConfirmation()).add("PreAuthentication", preAuthentication())
                .add("PostAuthentication", postAuthentication()).add("DefineAuthChallenge", defineAuthChallenge())
                .add("CreateAuthChallenge", createAuthChallenge())
                .add("VerifyAuthChallengeResponse", verifyAuthChallengeResponse())
                .add("PreTokenGeneration", preTokenGeneration()).add("UserMigration", userMigration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PreSignUp":
            return Optional.ofNullable(clazz.cast(preSignUp()));
        case "CustomMessage":
            return Optional.ofNullable(clazz.cast(customMessage()));
        case "PostConfirmation":
            return Optional.ofNullable(clazz.cast(postConfirmation()));
        case "PreAuthentication":
            return Optional.ofNullable(clazz.cast(preAuthentication()));
        case "PostAuthentication":
            return Optional.ofNullable(clazz.cast(postAuthentication()));
        case "DefineAuthChallenge":
            return Optional.ofNullable(clazz.cast(defineAuthChallenge()));
        case "CreateAuthChallenge":
            return Optional.ofNullable(clazz.cast(createAuthChallenge()));
        case "VerifyAuthChallengeResponse":
            return Optional.ofNullable(clazz.cast(verifyAuthChallengeResponse()));
        case "PreTokenGeneration":
            return Optional.ofNullable(clazz.cast(preTokenGeneration()));
        case "UserMigration":
            return Optional.ofNullable(clazz.cast(userMigration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaConfigType, T> g) {
        return obj -> g.apply((LambdaConfigType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaConfigType> {
        /**
         * <p>
         * A pre-registration AWS Lambda trigger.
         * </p>
         * 
         * @param preSignUp
         *        A pre-registration AWS Lambda trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preSignUp(String preSignUp);

        /**
         * <p>
         * A custom Message AWS Lambda trigger.
         * </p>
         * 
         * @param customMessage
         *        A custom Message AWS Lambda trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMessage(String customMessage);

        /**
         * <p>
         * A post-confirmation AWS Lambda trigger.
         * </p>
         * 
         * @param postConfirmation
         *        A post-confirmation AWS Lambda trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postConfirmation(String postConfirmation);

        /**
         * <p>
         * A pre-authentication AWS Lambda trigger.
         * </p>
         * 
         * @param preAuthentication
         *        A pre-authentication AWS Lambda trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preAuthentication(String preAuthentication);

        /**
         * <p>
         * A post-authentication AWS Lambda trigger.
         * </p>
         * 
         * @param postAuthentication
         *        A post-authentication AWS Lambda trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postAuthentication(String postAuthentication);

        /**
         * <p>
         * Defines the authentication challenge.
         * </p>
         * 
         * @param defineAuthChallenge
         *        Defines the authentication challenge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defineAuthChallenge(String defineAuthChallenge);

        /**
         * <p>
         * Creates an authentication challenge.
         * </p>
         * 
         * @param createAuthChallenge
         *        Creates an authentication challenge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createAuthChallenge(String createAuthChallenge);

        /**
         * <p>
         * Verifies the authentication challenge response.
         * </p>
         * 
         * @param verifyAuthChallengeResponse
         *        Verifies the authentication challenge response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifyAuthChallengeResponse(String verifyAuthChallengeResponse);

        /**
         * <p>
         * A Lambda trigger that is invoked before token generation.
         * </p>
         * 
         * @param preTokenGeneration
         *        A Lambda trigger that is invoked before token generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preTokenGeneration(String preTokenGeneration);

        /**
         * <p>
         * The user migration Lambda config type.
         * </p>
         * 
         * @param userMigration
         *        The user migration Lambda config type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMigration(String userMigration);
    }

    static final class BuilderImpl implements Builder {
        private String preSignUp;

        private String customMessage;

        private String postConfirmation;

        private String preAuthentication;

        private String postAuthentication;

        private String defineAuthChallenge;

        private String createAuthChallenge;

        private String verifyAuthChallengeResponse;

        private String preTokenGeneration;

        private String userMigration;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaConfigType model) {
            preSignUp(model.preSignUp);
            customMessage(model.customMessage);
            postConfirmation(model.postConfirmation);
            preAuthentication(model.preAuthentication);
            postAuthentication(model.postAuthentication);
            defineAuthChallenge(model.defineAuthChallenge);
            createAuthChallenge(model.createAuthChallenge);
            verifyAuthChallengeResponse(model.verifyAuthChallengeResponse);
            preTokenGeneration(model.preTokenGeneration);
            userMigration(model.userMigration);
        }

        public final String getPreSignUp() {
            return preSignUp;
        }

        @Override
        public final Builder preSignUp(String preSignUp) {
            this.preSignUp = preSignUp;
            return this;
        }

        public final void setPreSignUp(String preSignUp) {
            this.preSignUp = preSignUp;
        }

        public final String getCustomMessage() {
            return customMessage;
        }

        @Override
        public final Builder customMessage(String customMessage) {
            this.customMessage = customMessage;
            return this;
        }

        public final void setCustomMessage(String customMessage) {
            this.customMessage = customMessage;
        }

        public final String getPostConfirmation() {
            return postConfirmation;
        }

        @Override
        public final Builder postConfirmation(String postConfirmation) {
            this.postConfirmation = postConfirmation;
            return this;
        }

        public final void setPostConfirmation(String postConfirmation) {
            this.postConfirmation = postConfirmation;
        }

        public final String getPreAuthentication() {
            return preAuthentication;
        }

        @Override
        public final Builder preAuthentication(String preAuthentication) {
            this.preAuthentication = preAuthentication;
            return this;
        }

        public final void setPreAuthentication(String preAuthentication) {
            this.preAuthentication = preAuthentication;
        }

        public final String getPostAuthentication() {
            return postAuthentication;
        }

        @Override
        public final Builder postAuthentication(String postAuthentication) {
            this.postAuthentication = postAuthentication;
            return this;
        }

        public final void setPostAuthentication(String postAuthentication) {
            this.postAuthentication = postAuthentication;
        }

        public final String getDefineAuthChallenge() {
            return defineAuthChallenge;
        }

        @Override
        public final Builder defineAuthChallenge(String defineAuthChallenge) {
            this.defineAuthChallenge = defineAuthChallenge;
            return this;
        }

        public final void setDefineAuthChallenge(String defineAuthChallenge) {
            this.defineAuthChallenge = defineAuthChallenge;
        }

        public final String getCreateAuthChallenge() {
            return createAuthChallenge;
        }

        @Override
        public final Builder createAuthChallenge(String createAuthChallenge) {
            this.createAuthChallenge = createAuthChallenge;
            return this;
        }

        public final void setCreateAuthChallenge(String createAuthChallenge) {
            this.createAuthChallenge = createAuthChallenge;
        }

        public final String getVerifyAuthChallengeResponse() {
            return verifyAuthChallengeResponse;
        }

        @Override
        public final Builder verifyAuthChallengeResponse(String verifyAuthChallengeResponse) {
            this.verifyAuthChallengeResponse = verifyAuthChallengeResponse;
            return this;
        }

        public final void setVerifyAuthChallengeResponse(String verifyAuthChallengeResponse) {
            this.verifyAuthChallengeResponse = verifyAuthChallengeResponse;
        }

        public final String getPreTokenGeneration() {
            return preTokenGeneration;
        }

        @Override
        public final Builder preTokenGeneration(String preTokenGeneration) {
            this.preTokenGeneration = preTokenGeneration;
            return this;
        }

        public final void setPreTokenGeneration(String preTokenGeneration) {
            this.preTokenGeneration = preTokenGeneration;
        }

        public final String getUserMigration() {
            return userMigration;
        }

        @Override
        public final Builder userMigration(String userMigration) {
            this.userMigration = userMigration;
            return this;
        }

        public final void setUserMigration(String userMigration) {
            this.userMigration = userMigration;
        }

        @Override
        public LambdaConfigType build() {
            return new LambdaConfigType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
