/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The notify configuration type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotifyConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<NotifyConfigurationType.Builder, NotifyConfigurationType> {
    private static final SdkField<String> FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NotifyConfigurationType::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()).build();

    private static final SdkField<String> REPLY_TO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NotifyConfigurationType::replyTo)).setter(setter(Builder::replyTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplyTo").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NotifyConfigurationType::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<NotifyEmailType> BLOCK_EMAIL_FIELD = SdkField
            .<NotifyEmailType> builder(MarshallingType.SDK_POJO).getter(getter(NotifyConfigurationType::blockEmail))
            .setter(setter(Builder::blockEmail)).constructor(NotifyEmailType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockEmail").build()).build();

    private static final SdkField<NotifyEmailType> NO_ACTION_EMAIL_FIELD = SdkField
            .<NotifyEmailType> builder(MarshallingType.SDK_POJO).getter(getter(NotifyConfigurationType::noActionEmail))
            .setter(setter(Builder::noActionEmail)).constructor(NotifyEmailType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoActionEmail").build()).build();

    private static final SdkField<NotifyEmailType> MFA_EMAIL_FIELD = SdkField.<NotifyEmailType> builder(MarshallingType.SDK_POJO)
            .getter(getter(NotifyConfigurationType::mfaEmail)).setter(setter(Builder::mfaEmail))
            .constructor(NotifyEmailType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MfaEmail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FIELD, REPLY_TO_FIELD,
            SOURCE_ARN_FIELD, BLOCK_EMAIL_FIELD, NO_ACTION_EMAIL_FIELD, MFA_EMAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String from;

    private final String replyTo;

    private final String sourceArn;

    private final NotifyEmailType blockEmail;

    private final NotifyEmailType noActionEmail;

    private final NotifyEmailType mfaEmail;

    private NotifyConfigurationType(BuilderImpl builder) {
        this.from = builder.from;
        this.replyTo = builder.replyTo;
        this.sourceArn = builder.sourceArn;
        this.blockEmail = builder.blockEmail;
        this.noActionEmail = builder.noActionEmail;
        this.mfaEmail = builder.mfaEmail;
    }

    /**
     * <p>
     * The email address that is sending the email. It must be either individually verified with Amazon SES, or from a
     * domain that has been verified with Amazon SES.
     * </p>
     * 
     * @return The email address that is sending the email. It must be either individually verified with Amazon SES, or
     *         from a domain that has been verified with Amazon SES.
     */
    public String from() {
        return from;
    }

    /**
     * <p>
     * The destination to which the receiver of an email should reply to.
     * </p>
     * 
     * @return The destination to which the receiver of an email should reply to.
     */
    public String replyTo() {
        return replyTo;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy. It
     * permits Amazon Cognito to send for the email address specified in the <code>From</code> parameter.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy.
     *         It permits Amazon Cognito to send for the email address specified in the <code>From</code> parameter.
     */
    public String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * Email template used when a detected risk event is blocked.
     * </p>
     * 
     * @return Email template used when a detected risk event is blocked.
     */
    public NotifyEmailType blockEmail() {
        return blockEmail;
    }

    /**
     * <p>
     * The email template used when a detected risk event is allowed.
     * </p>
     * 
     * @return The email template used when a detected risk event is allowed.
     */
    public NotifyEmailType noActionEmail() {
        return noActionEmail;
    }

    /**
     * <p>
     * The MFA email template used when MFA is challenged as part of a detected risk.
     * </p>
     * 
     * @return The MFA email template used when MFA is challenged as part of a detected risk.
     */
    public NotifyEmailType mfaEmail() {
        return mfaEmail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(replyTo());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(blockEmail());
        hashCode = 31 * hashCode + Objects.hashCode(noActionEmail());
        hashCode = 31 * hashCode + Objects.hashCode(mfaEmail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyConfigurationType)) {
            return false;
        }
        NotifyConfigurationType other = (NotifyConfigurationType) obj;
        return Objects.equals(from(), other.from()) && Objects.equals(replyTo(), other.replyTo())
                && Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(blockEmail(), other.blockEmail())
                && Objects.equals(noActionEmail(), other.noActionEmail()) && Objects.equals(mfaEmail(), other.mfaEmail());
    }

    @Override
    public String toString() {
        return ToString.builder("NotifyConfigurationType").add("From", from()).add("ReplyTo", replyTo())
                .add("SourceArn", sourceArn()).add("BlockEmail", blockEmail()).add("NoActionEmail", noActionEmail())
                .add("MfaEmail", mfaEmail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "From":
            return Optional.ofNullable(clazz.cast(from()));
        case "ReplyTo":
            return Optional.ofNullable(clazz.cast(replyTo()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "BlockEmail":
            return Optional.ofNullable(clazz.cast(blockEmail()));
        case "NoActionEmail":
            return Optional.ofNullable(clazz.cast(noActionEmail()));
        case "MfaEmail":
            return Optional.ofNullable(clazz.cast(mfaEmail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotifyConfigurationType, T> g) {
        return obj -> g.apply((NotifyConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotifyConfigurationType> {
        /**
         * <p>
         * The email address that is sending the email. It must be either individually verified with Amazon SES, or from
         * a domain that has been verified with Amazon SES.
         * </p>
         * 
         * @param from
         *        The email address that is sending the email. It must be either individually verified with Amazon SES,
         *        or from a domain that has been verified with Amazon SES.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(String from);

        /**
         * <p>
         * The destination to which the receiver of an email should reply to.
         * </p>
         * 
         * @param replyTo
         *        The destination to which the receiver of an email should reply to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replyTo(String replyTo);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy. It
         * permits Amazon Cognito to send for the email address specified in the <code>From</code> parameter.
         * </p>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization
         *        policy. It permits Amazon Cognito to send for the email address specified in the <code>From</code>
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * Email template used when a detected risk event is blocked.
         * </p>
         * 
         * @param blockEmail
         *        Email template used when a detected risk event is blocked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockEmail(NotifyEmailType blockEmail);

        /**
         * <p>
         * Email template used when a detected risk event is blocked.
         * </p>
         * This is a convenience that creates an instance of the {@link NotifyEmailType.Builder} avoiding the need to
         * create one manually via {@link NotifyEmailType#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotifyEmailType.Builder#build()} is called immediately and its
         * result is passed to {@link #blockEmail(NotifyEmailType)}.
         * 
         * @param blockEmail
         *        a consumer that will call methods on {@link NotifyEmailType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockEmail(NotifyEmailType)
         */
        default Builder blockEmail(Consumer<NotifyEmailType.Builder> blockEmail) {
            return blockEmail(NotifyEmailType.builder().applyMutation(blockEmail).build());
        }

        /**
         * <p>
         * The email template used when a detected risk event is allowed.
         * </p>
         * 
         * @param noActionEmail
         *        The email template used when a detected risk event is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noActionEmail(NotifyEmailType noActionEmail);

        /**
         * <p>
         * The email template used when a detected risk event is allowed.
         * </p>
         * This is a convenience that creates an instance of the {@link NotifyEmailType.Builder} avoiding the need to
         * create one manually via {@link NotifyEmailType#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotifyEmailType.Builder#build()} is called immediately and its
         * result is passed to {@link #noActionEmail(NotifyEmailType)}.
         * 
         * @param noActionEmail
         *        a consumer that will call methods on {@link NotifyEmailType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noActionEmail(NotifyEmailType)
         */
        default Builder noActionEmail(Consumer<NotifyEmailType.Builder> noActionEmail) {
            return noActionEmail(NotifyEmailType.builder().applyMutation(noActionEmail).build());
        }

        /**
         * <p>
         * The MFA email template used when MFA is challenged as part of a detected risk.
         * </p>
         * 
         * @param mfaEmail
         *        The MFA email template used when MFA is challenged as part of a detected risk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaEmail(NotifyEmailType mfaEmail);

        /**
         * <p>
         * The MFA email template used when MFA is challenged as part of a detected risk.
         * </p>
         * This is a convenience that creates an instance of the {@link NotifyEmailType.Builder} avoiding the need to
         * create one manually via {@link NotifyEmailType#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotifyEmailType.Builder#build()} is called immediately and its
         * result is passed to {@link #mfaEmail(NotifyEmailType)}.
         * 
         * @param mfaEmail
         *        a consumer that will call methods on {@link NotifyEmailType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mfaEmail(NotifyEmailType)
         */
        default Builder mfaEmail(Consumer<NotifyEmailType.Builder> mfaEmail) {
            return mfaEmail(NotifyEmailType.builder().applyMutation(mfaEmail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String from;

        private String replyTo;

        private String sourceArn;

        private NotifyEmailType blockEmail;

        private NotifyEmailType noActionEmail;

        private NotifyEmailType mfaEmail;

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyConfigurationType model) {
            from(model.from);
            replyTo(model.replyTo);
            sourceArn(model.sourceArn);
            blockEmail(model.blockEmail);
            noActionEmail(model.noActionEmail);
            mfaEmail(model.mfaEmail);
        }

        public final String getFrom() {
            return from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        public final String getReplyTo() {
            return replyTo;
        }

        @Override
        public final Builder replyTo(String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public final void setReplyTo(String replyTo) {
            this.replyTo = replyTo;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final NotifyEmailType.Builder getBlockEmail() {
            return blockEmail != null ? blockEmail.toBuilder() : null;
        }

        @Override
        public final Builder blockEmail(NotifyEmailType blockEmail) {
            this.blockEmail = blockEmail;
            return this;
        }

        public final void setBlockEmail(NotifyEmailType.BuilderImpl blockEmail) {
            this.blockEmail = blockEmail != null ? blockEmail.build() : null;
        }

        public final NotifyEmailType.Builder getNoActionEmail() {
            return noActionEmail != null ? noActionEmail.toBuilder() : null;
        }

        @Override
        public final Builder noActionEmail(NotifyEmailType noActionEmail) {
            this.noActionEmail = noActionEmail;
            return this;
        }

        public final void setNoActionEmail(NotifyEmailType.BuilderImpl noActionEmail) {
            this.noActionEmail = noActionEmail != null ? noActionEmail.build() : null;
        }

        public final NotifyEmailType.Builder getMfaEmail() {
            return mfaEmail != null ? mfaEmail.toBuilder() : null;
        }

        @Override
        public final Builder mfaEmail(NotifyEmailType mfaEmail) {
            this.mfaEmail = mfaEmail;
            return this;
        }

        public final void setMfaEmail(NotifyEmailType.BuilderImpl mfaEmail) {
            this.mfaEmail = mfaEmail != null ? mfaEmail.build() : null;
        }

        @Override
        public NotifyConfigurationType build() {
            return new NotifyConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
