/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetUserMfaPreferenceRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<SetUserMfaPreferenceRequest.Builder, SetUserMfaPreferenceRequest> {
    private static final SdkField<SMSMfaSettingsType> SMS_MFA_SETTINGS_FIELD = SdkField
            .<SMSMfaSettingsType> builder(MarshallingType.SDK_POJO).getter(getter(SetUserMfaPreferenceRequest::smsMfaSettings))
            .setter(setter(Builder::smsMfaSettings)).constructor(SMSMfaSettingsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSMfaSettings").build()).build();

    private static final SdkField<SoftwareTokenMfaSettingsType> SOFTWARE_TOKEN_MFA_SETTINGS_FIELD = SdkField
            .<SoftwareTokenMfaSettingsType> builder(MarshallingType.SDK_POJO)
            .getter(getter(SetUserMfaPreferenceRequest::softwareTokenMfaSettings))
            .setter(setter(Builder::softwareTokenMfaSettings)).constructor(SoftwareTokenMfaSettingsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareTokenMfaSettings").build())
            .build();

    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetUserMfaPreferenceRequest::accessToken)).setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMS_MFA_SETTINGS_FIELD,
            SOFTWARE_TOKEN_MFA_SETTINGS_FIELD, ACCESS_TOKEN_FIELD));

    private final SMSMfaSettingsType smsMfaSettings;

    private final SoftwareTokenMfaSettingsType softwareTokenMfaSettings;

    private final String accessToken;

    private SetUserMfaPreferenceRequest(BuilderImpl builder) {
        super(builder);
        this.smsMfaSettings = builder.smsMfaSettings;
        this.softwareTokenMfaSettings = builder.softwareTokenMfaSettings;
        this.accessToken = builder.accessToken;
    }

    /**
     * <p>
     * The SMS text message multi-factor authentication (MFA) settings.
     * </p>
     * 
     * @return The SMS text message multi-factor authentication (MFA) settings.
     */
    public SMSMfaSettingsType smsMfaSettings() {
        return smsMfaSettings;
    }

    /**
     * <p>
     * The time-based one-time password software token MFA settings.
     * </p>
     * 
     * @return The time-based one-time password software token MFA settings.
     */
    public SoftwareTokenMfaSettingsType softwareTokenMfaSettings() {
        return softwareTokenMfaSettings;
    }

    /**
     * <p>
     * The access token.
     * </p>
     * 
     * @return The access token.
     */
    public String accessToken() {
        return accessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(smsMfaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(softwareTokenMfaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetUserMfaPreferenceRequest)) {
            return false;
        }
        SetUserMfaPreferenceRequest other = (SetUserMfaPreferenceRequest) obj;
        return Objects.equals(smsMfaSettings(), other.smsMfaSettings())
                && Objects.equals(softwareTokenMfaSettings(), other.softwareTokenMfaSettings())
                && Objects.equals(accessToken(), other.accessToken());
    }

    @Override
    public String toString() {
        return ToString.builder("SetUserMfaPreferenceRequest").add("SMSMfaSettings", smsMfaSettings())
                .add("SoftwareTokenMfaSettings", softwareTokenMfaSettings()).add("AccessToken", accessToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SMSMfaSettings":
            return Optional.ofNullable(clazz.cast(smsMfaSettings()));
        case "SoftwareTokenMfaSettings":
            return Optional.ofNullable(clazz.cast(softwareTokenMfaSettings()));
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetUserMfaPreferenceRequest, T> g) {
        return obj -> g.apply((SetUserMfaPreferenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetUserMfaPreferenceRequest> {
        /**
         * <p>
         * The SMS text message multi-factor authentication (MFA) settings.
         * </p>
         * 
         * @param smsMfaSettings
         *        The SMS text message multi-factor authentication (MFA) settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsMfaSettings(SMSMfaSettingsType smsMfaSettings);

        /**
         * <p>
         * The SMS text message multi-factor authentication (MFA) settings.
         * </p>
         * This is a convenience that creates an instance of the {@link SMSMfaSettingsType.Builder} avoiding the need to
         * create one manually via {@link SMSMfaSettingsType#builder()}.
         *
         * When the {@link Consumer} completes, {@link SMSMfaSettingsType.Builder#build()} is called immediately and its
         * result is passed to {@link #smsMfaSettings(SMSMfaSettingsType)}.
         * 
         * @param smsMfaSettings
         *        a consumer that will call methods on {@link SMSMfaSettingsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsMfaSettings(SMSMfaSettingsType)
         */
        default Builder smsMfaSettings(Consumer<SMSMfaSettingsType.Builder> smsMfaSettings) {
            return smsMfaSettings(SMSMfaSettingsType.builder().applyMutation(smsMfaSettings).build());
        }

        /**
         * <p>
         * The time-based one-time password software token MFA settings.
         * </p>
         * 
         * @param softwareTokenMfaSettings
         *        The time-based one-time password software token MFA settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareTokenMfaSettings(SoftwareTokenMfaSettingsType softwareTokenMfaSettings);

        /**
         * <p>
         * The time-based one-time password software token MFA settings.
         * </p>
         * This is a convenience that creates an instance of the {@link SoftwareTokenMfaSettingsType.Builder} avoiding
         * the need to create one manually via {@link SoftwareTokenMfaSettingsType#builder()}.
         *
         * When the {@link Consumer} completes, {@link SoftwareTokenMfaSettingsType.Builder#build()} is called
         * immediately and its result is passed to {@link #softwareTokenMfaSettings(SoftwareTokenMfaSettingsType)}.
         * 
         * @param softwareTokenMfaSettings
         *        a consumer that will call methods on {@link SoftwareTokenMfaSettingsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #softwareTokenMfaSettings(SoftwareTokenMfaSettingsType)
         */
        default Builder softwareTokenMfaSettings(Consumer<SoftwareTokenMfaSettingsType.Builder> softwareTokenMfaSettings) {
            return softwareTokenMfaSettings(SoftwareTokenMfaSettingsType.builder().applyMutation(softwareTokenMfaSettings)
                    .build());
        }

        /**
         * <p>
         * The access token.
         * </p>
         * 
         * @param accessToken
         *        The access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private SMSMfaSettingsType smsMfaSettings;

        private SoftwareTokenMfaSettingsType softwareTokenMfaSettings;

        private String accessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SetUserMfaPreferenceRequest model) {
            super(model);
            smsMfaSettings(model.smsMfaSettings);
            softwareTokenMfaSettings(model.softwareTokenMfaSettings);
            accessToken(model.accessToken);
        }

        public final SMSMfaSettingsType.Builder getSMSMfaSettings() {
            return smsMfaSettings != null ? smsMfaSettings.toBuilder() : null;
        }

        @Override
        public final Builder smsMfaSettings(SMSMfaSettingsType smsMfaSettings) {
            this.smsMfaSettings = smsMfaSettings;
            return this;
        }

        public final void setSMSMfaSettings(SMSMfaSettingsType.BuilderImpl smsMfaSettings) {
            this.smsMfaSettings = smsMfaSettings != null ? smsMfaSettings.build() : null;
        }

        public final SoftwareTokenMfaSettingsType.Builder getSoftwareTokenMfaSettings() {
            return softwareTokenMfaSettings != null ? softwareTokenMfaSettings.toBuilder() : null;
        }

        @Override
        public final Builder softwareTokenMfaSettings(SoftwareTokenMfaSettingsType softwareTokenMfaSettings) {
            this.softwareTokenMfaSettings = softwareTokenMfaSettings;
            return this;
        }

        public final void setSoftwareTokenMfaSettings(SoftwareTokenMfaSettingsType.BuilderImpl softwareTokenMfaSettings) {
            this.softwareTokenMfaSettings = softwareTokenMfaSettings != null ? softwareTokenMfaSettings.build() : null;
        }

        public final String getAccessToken() {
            return accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetUserMfaPreferenceRequest build() {
            return new SetUserMfaPreferenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
