/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for the UI customization information for a user pool's built-in app UI.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UICustomizationType implements SdkPojo, Serializable,
        ToCopyableBuilder<UICustomizationType.Builder, UICustomizationType> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UICustomizationType::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UICustomizationType::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> IMAGE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UICustomizationType::imageUrl)).setter(setter(Builder::imageUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUrl").build()).build();

    private static final SdkField<String> CSS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UICustomizationType::css)).setter(setter(Builder::css))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CSS").build()).build();

    private static final SdkField<String> CSS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UICustomizationType::cssVersion)).setter(setter(Builder::cssVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CSSVersion").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(UICustomizationType::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(UICustomizationType::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            CLIENT_ID_FIELD, IMAGE_URL_FIELD, CSS_FIELD, CSS_VERSION_FIELD, LAST_MODIFIED_DATE_FIELD, CREATION_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userPoolId;

    private final String clientId;

    private final String imageUrl;

    private final String css;

    private final String cssVersion;

    private final Instant lastModifiedDate;

    private final Instant creationDate;

    private UICustomizationType(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.imageUrl = builder.imageUrl;
        this.css = builder.css;
        this.cssVersion = builder.cssVersion;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The user pool ID for the user pool.
     * </p>
     * 
     * @return The user pool ID for the user pool.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The client ID for the client app.
     * </p>
     * 
     * @return The client ID for the client app.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The logo image for the UI customization.
     * </p>
     * 
     * @return The logo image for the UI customization.
     */
    public String imageUrl() {
        return imageUrl;
    }

    /**
     * <p>
     * The CSS values in the UI customization.
     * </p>
     * 
     * @return The CSS values in the UI customization.
     */
    public String css() {
        return css;
    }

    /**
     * <p>
     * The CSS version number.
     * </p>
     * 
     * @return The CSS version number.
     */
    public String cssVersion() {
        return cssVersion;
    }

    /**
     * <p>
     * The last-modified date for the UI customization.
     * </p>
     * 
     * @return The last-modified date for the UI customization.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The creation date for the UI customization.
     * </p>
     * 
     * @return The creation date for the UI customization.
     */
    public Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(css());
        hashCode = 31 * hashCode + Objects.hashCode(cssVersion());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UICustomizationType)) {
            return false;
        }
        UICustomizationType other = (UICustomizationType) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(imageUrl(), other.imageUrl()) && Objects.equals(css(), other.css())
                && Objects.equals(cssVersion(), other.cssVersion())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(creationDate(), other.creationDate());
    }

    @Override
    public String toString() {
        return ToString.builder("UICustomizationType").add("UserPoolId", userPoolId()).add("ClientId", clientId())
                .add("ImageUrl", imageUrl()).add("CSS", css()).add("CSSVersion", cssVersion())
                .add("LastModifiedDate", lastModifiedDate()).add("CreationDate", creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "ImageUrl":
            return Optional.ofNullable(clazz.cast(imageUrl()));
        case "CSS":
            return Optional.ofNullable(clazz.cast(css()));
        case "CSSVersion":
            return Optional.ofNullable(clazz.cast(cssVersion()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UICustomizationType, T> g) {
        return obj -> g.apply((UICustomizationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UICustomizationType> {
        /**
         * <p>
         * The user pool ID for the user pool.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The client ID for the client app.
         * </p>
         * 
         * @param clientId
         *        The client ID for the client app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The logo image for the UI customization.
         * </p>
         * 
         * @param imageUrl
         *        The logo image for the UI customization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUrl(String imageUrl);

        /**
         * <p>
         * The CSS values in the UI customization.
         * </p>
         * 
         * @param css
         *        The CSS values in the UI customization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder css(String css);

        /**
         * <p>
         * The CSS version number.
         * </p>
         * 
         * @param cssVersion
         *        The CSS version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cssVersion(String cssVersion);

        /**
         * <p>
         * The last-modified date for the UI customization.
         * </p>
         * 
         * @param lastModifiedDate
         *        The last-modified date for the UI customization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The creation date for the UI customization.
         * </p>
         * 
         * @param creationDate
         *        The creation date for the UI customization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String userPoolId;

        private String clientId;

        private String imageUrl;

        private String css;

        private String cssVersion;

        private Instant lastModifiedDate;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UICustomizationType model) {
            userPoolId(model.userPoolId);
            clientId(model.clientId);
            imageUrl(model.imageUrl);
            css(model.css);
            cssVersion(model.cssVersion);
            lastModifiedDate(model.lastModifiedDate);
            creationDate(model.creationDate);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getImageUrl() {
            return imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public final String getCSS() {
            return css;
        }

        @Override
        public final Builder css(String css) {
            this.css = css;
            return this;
        }

        public final void setCSS(String css) {
            this.css = css;
        }

        public final String getCSSVersion() {
            return cssVersion;
        }

        @Override
        public final Builder cssVersion(String cssVersion) {
            this.cssVersion = cssVersion;
            return this;
        }

        public final void setCSSVersion(String cssVersion) {
            this.cssVersion = cssVersion;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public UICustomizationType build() {
            return new UICustomizationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
