/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The event risk type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventRiskType implements SdkPojo, Serializable, ToCopyableBuilder<EventRiskType.Builder, EventRiskType> {
    private static final SdkField<String> RISK_DECISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventRiskType::riskDecisionAsString)).setter(setter(Builder::riskDecision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskDecision").build()).build();

    private static final SdkField<String> RISK_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventRiskType::riskLevelAsString)).setter(setter(Builder::riskLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RISK_DECISION_FIELD,
            RISK_LEVEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String riskDecision;

    private final String riskLevel;

    private EventRiskType(BuilderImpl builder) {
        this.riskDecision = builder.riskDecision;
        this.riskLevel = builder.riskLevel;
    }

    /**
     * <p>
     * The risk decision.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #riskDecision} will
     * return {@link RiskDecisionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskDecisionAsString}.
     * </p>
     * 
     * @return The risk decision.
     * @see RiskDecisionType
     */
    public RiskDecisionType riskDecision() {
        return RiskDecisionType.fromValue(riskDecision);
    }

    /**
     * <p>
     * The risk decision.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #riskDecision} will
     * return {@link RiskDecisionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskDecisionAsString}.
     * </p>
     * 
     * @return The risk decision.
     * @see RiskDecisionType
     */
    public String riskDecisionAsString() {
        return riskDecision;
    }

    /**
     * <p>
     * The risk level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #riskLevel} will
     * return {@link RiskLevelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskLevelAsString}.
     * </p>
     * 
     * @return The risk level.
     * @see RiskLevelType
     */
    public RiskLevelType riskLevel() {
        return RiskLevelType.fromValue(riskLevel);
    }

    /**
     * <p>
     * The risk level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #riskLevel} will
     * return {@link RiskLevelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskLevelAsString}.
     * </p>
     * 
     * @return The risk level.
     * @see RiskLevelType
     */
    public String riskLevelAsString() {
        return riskLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(riskDecisionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(riskLevelAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventRiskType)) {
            return false;
        }
        EventRiskType other = (EventRiskType) obj;
        return Objects.equals(riskDecisionAsString(), other.riskDecisionAsString())
                && Objects.equals(riskLevelAsString(), other.riskLevelAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("EventRiskType").add("RiskDecision", riskDecisionAsString())
                .add("RiskLevel", riskLevelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RiskDecision":
            return Optional.ofNullable(clazz.cast(riskDecisionAsString()));
        case "RiskLevel":
            return Optional.ofNullable(clazz.cast(riskLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventRiskType, T> g) {
        return obj -> g.apply((EventRiskType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventRiskType> {
        /**
         * <p>
         * The risk decision.
         * </p>
         * 
         * @param riskDecision
         *        The risk decision.
         * @see RiskDecisionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RiskDecisionType
         */
        Builder riskDecision(String riskDecision);

        /**
         * <p>
         * The risk decision.
         * </p>
         * 
         * @param riskDecision
         *        The risk decision.
         * @see RiskDecisionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RiskDecisionType
         */
        Builder riskDecision(RiskDecisionType riskDecision);

        /**
         * <p>
         * The risk level.
         * </p>
         * 
         * @param riskLevel
         *        The risk level.
         * @see RiskLevelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RiskLevelType
         */
        Builder riskLevel(String riskLevel);

        /**
         * <p>
         * The risk level.
         * </p>
         * 
         * @param riskLevel
         *        The risk level.
         * @see RiskLevelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RiskLevelType
         */
        Builder riskLevel(RiskLevelType riskLevel);
    }

    static final class BuilderImpl implements Builder {
        private String riskDecision;

        private String riskLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(EventRiskType model) {
            riskDecision(model.riskDecision);
            riskLevel(model.riskLevel);
        }

        public final String getRiskDecision() {
            return riskDecision;
        }

        @Override
        public final Builder riskDecision(String riskDecision) {
            this.riskDecision = riskDecision;
            return this;
        }

        @Override
        public final Builder riskDecision(RiskDecisionType riskDecision) {
            this.riskDecision(riskDecision.toString());
            return this;
        }

        public final void setRiskDecision(String riskDecision) {
            this.riskDecision = riskDecision;
        }

        public final String getRiskLevel() {
            return riskLevel;
        }

        @Override
        public final Builder riskLevel(String riskLevel) {
            this.riskLevel = riskLevel;
            return this;
        }

        @Override
        public final Builder riskLevel(RiskLevelType riskLevel) {
            this.riskLevel(riskLevel.toString());
            return this;
        }

        public final void setRiskLevel(String riskLevel) {
            this.riskLevel = riskLevel;
        }

        @Override
        public EventRiskType build() {
            return new EventRiskType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
