/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to get user attribute verification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUserAttributeVerificationCodeRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<GetUserAttributeVerificationCodeRequest.Builder, GetUserAttributeVerificationCodeRequest> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetUserAttributeVerificationCodeRequest::accessToken)).setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetUserAttributeVerificationCodeRequest::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<Map<String, String>> CLIENT_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetUserAttributeVerificationCodeRequest::clientMetadata))
            .setter(setter(Builder::clientMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            ATTRIBUTE_NAME_FIELD, CLIENT_METADATA_FIELD));

    private final String accessToken;

    private final String attributeName;

    private final Map<String, String> clientMetadata;

    private GetUserAttributeVerificationCodeRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.attributeName = builder.attributeName;
        this.clientMetadata = builder.clientMetadata;
    }

    /**
     * <p>
     * The access token returned by the server response to get the user attribute verification code.
     * </p>
     * 
     * @return The access token returned by the server response to get the user attribute verification code.
     */
    public String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The attribute name returned by the server response to get the user attribute verification code.
     * </p>
     * 
     * @return The attribute name returned by the server response to get the user attribute verification code.
     */
    public String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.
     * </p>
     * <p>
     * You create custom workflows by assigning AWS Lambda functions to user pool triggers. When you use the
     * GetUserAttributeVerificationCode API action, Amazon Cognito invokes the function that is assigned to the
     * <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the
     * function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the
     * data that you assigned to the ClientMetadata parameter in your GetUserAttributeVerificationCode request. In your
     * function code in AWS Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for
     * your specific needs.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"
     * >Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * Take the following limitations into consideration when you use the ClientMetadata parameter:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Cognito does not store the ClientMetadata value. This data is available only to AWS Lambda triggers that
     * are assigned to a user pool to support custom workflows. If your user pool configuration does not include
     * triggers, the ClientMetadata parameter serves no purpose.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito does not validate the ClientMetadata value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of custom key-value pairs that you can provide as input for any custom workflows that this action
     *         triggers. </p>
     *         <p>
     *         You create custom workflows by assigning AWS Lambda functions to user pool triggers. When you use the
     *         GetUserAttributeVerificationCode API action, Amazon Cognito invokes the function that is assigned to the
     *         <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which
     *         the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which
     *         provides the data that you assigned to the ClientMetadata parameter in your
     *         GetUserAttributeVerificationCode request. In your function code in AWS Lambda, you can process the
     *         <code>clientMetadata</code> value to enhance your workflow for your specific needs.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"
     *         >Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         Take the following limitations into consideration when you use the ClientMetadata parameter:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon Cognito does not store the ClientMetadata value. This data is available only to AWS Lambda
     *         triggers that are assigned to a user pool to support custom workflows. If your user pool configuration
     *         does not include triggers, the ClientMetadata parameter serves no purpose.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Cognito does not validate the ClientMetadata value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive
     *         information.
     *         </p>
     *         </li>
     *         </ul>
     */
    public Map<String, String> clientMetadata() {
        return clientMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(clientMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserAttributeVerificationCodeRequest)) {
            return false;
        }
        GetUserAttributeVerificationCodeRequest other = (GetUserAttributeVerificationCodeRequest) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(clientMetadata(), other.clientMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetUserAttributeVerificationCodeRequest")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AttributeName", attributeName()).add("ClientMetadata", clientMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "ClientMetadata":
            return Optional.ofNullable(clazz.cast(clientMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUserAttributeVerificationCodeRequest, T> g) {
        return obj -> g.apply((GetUserAttributeVerificationCodeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetUserAttributeVerificationCodeRequest> {
        /**
         * <p>
         * The access token returned by the server response to get the user attribute verification code.
         * </p>
         * 
         * @param accessToken
         *        The access token returned by the server response to get the user attribute verification code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The attribute name returned by the server response to get the user attribute verification code.
         * </p>
         * 
         * @param attributeName
         *        The attribute name returned by the server response to get the user attribute verification code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * A map of custom key-value pairs that you can provide as input for any custom workflows that this action
         * triggers.
         * </p>
         * <p>
         * You create custom workflows by assigning AWS Lambda functions to user pool triggers. When you use the
         * GetUserAttributeVerificationCode API action, Amazon Cognito invokes the function that is assigned to the
         * <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the
         * function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the
         * data that you assigned to the ClientMetadata parameter in your GetUserAttributeVerificationCode request. In
         * your function code in AWS Lambda, you can process the <code>clientMetadata</code> value to enhance your
         * workflow for your specific needs.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"
         * >Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * Take the following limitations into consideration when you use the ClientMetadata parameter:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Cognito does not store the ClientMetadata value. This data is available only to AWS Lambda triggers
         * that are assigned to a user pool to support custom workflows. If your user pool configuration does not
         * include triggers, the ClientMetadata parameter serves no purpose.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Cognito does not validate the ClientMetadata value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive
         * information.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param clientMetadata
         *        A map of custom key-value pairs that you can provide as input for any custom workflows that this
         *        action triggers. </p>
         *        <p>
         *        You create custom workflows by assigning AWS Lambda functions to user pool triggers. When you use the
         *        GetUserAttributeVerificationCode API action, Amazon Cognito invokes the function that is assigned to
         *        the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON
         *        payload, which the function receives as input. This payload contains a <code>clientMetadata</code>
         *        attribute, which provides the data that you assigned to the ClientMetadata parameter in your
         *        GetUserAttributeVerificationCode request. In your function code in AWS Lambda, you can process the
         *        <code>clientMetadata</code> value to enhance your workflow for your specific needs.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"
         *        >Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer
         *        Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        Take the following limitations into consideration when you use the ClientMetadata parameter:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Cognito does not store the ClientMetadata value. This data is available only to AWS Lambda
         *        triggers that are assigned to a user pool to support custom workflows. If your user pool configuration
         *        does not include triggers, the ClientMetadata parameter serves no purpose.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Cognito does not validate the ClientMetadata value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive
         *        information.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientMetadata(Map<String, String> clientMetadata);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String accessToken;

        private String attributeName;

        private Map<String, String> clientMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserAttributeVerificationCodeRequest model) {
            super(model);
            accessToken(model.accessToken);
            attributeName(model.attributeName);
            clientMetadata(model.clientMetadata);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final Map<String, String> getClientMetadata() {
            return clientMetadata;
        }

        @Override
        public final Builder clientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
            return this;
        }

        public final void setClientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUserAttributeVerificationCodeRequest build() {
            return new GetUserAttributeVerificationCodeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
