/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminSetUserPasswordRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<AdminSetUserPasswordRequest.Builder, AdminSetUserPasswordRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminSetUserPasswordRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminSetUserPasswordRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminSetUserPasswordRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<Boolean> PERMANENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AdminSetUserPasswordRequest::permanent)).setter(setter(Builder::permanent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permanent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            USERNAME_FIELD, PASSWORD_FIELD, PERMANENT_FIELD));

    private final String userPoolId;

    private final String username;

    private final String password;

    private final Boolean permanent;

    private AdminSetUserPasswordRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.username = builder.username;
        this.password = builder.password;
        this.permanent = builder.permanent;
    }

    /**
     * <p>
     * The user pool ID for the user pool where you want to set the user's password.
     * </p>
     * 
     * @return The user pool ID for the user pool where you want to set the user's password.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The user name of the user whose password you wish to set.
     * </p>
     * 
     * @return The user name of the user whose password you wish to set.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The password for the user.
     * </p>
     * 
     * @return The password for the user.
     */
    public String password() {
        return password;
    }

    /**
     * <p>
     * <code>True</code> if the password is permanent, <code>False</code> if it is temporary.
     * </p>
     * 
     * @return <code>True</code> if the password is permanent, <code>False</code> if it is temporary.
     */
    public Boolean permanent() {
        return permanent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(permanent());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminSetUserPasswordRequest)) {
            return false;
        }
        AdminSetUserPasswordRequest other = (AdminSetUserPasswordRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(username(), other.username())
                && Objects.equals(password(), other.password()) && Objects.equals(permanent(), other.permanent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AdminSetUserPasswordRequest").add("UserPoolId", userPoolId())
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").add("Permanent", permanent())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "Permanent":
            return Optional.ofNullable(clazz.cast(permanent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminSetUserPasswordRequest, T> g) {
        return obj -> g.apply((AdminSetUserPasswordRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AdminSetUserPasswordRequest> {
        /**
         * <p>
         * The user pool ID for the user pool where you want to set the user's password.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool where you want to set the user's password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The user name of the user whose password you wish to set.
         * </p>
         * 
         * @param username
         *        The user name of the user whose password you wish to set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The password for the user.
         * </p>
         * 
         * @param password
         *        The password for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * <code>True</code> if the password is permanent, <code>False</code> if it is temporary.
         * </p>
         * 
         * @param permanent
         *        <code>True</code> if the password is permanent, <code>False</code> if it is temporary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permanent(Boolean permanent);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String username;

        private String password;

        private Boolean permanent;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminSetUserPasswordRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            username(model.username);
            password(model.password);
            permanent(model.permanent);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final Boolean getPermanent() {
            return permanent;
        }

        @Override
        public final Builder permanent(Boolean permanent) {
            this.permanent = permanent;
            return this;
        }

        public final void setPermanent(Boolean permanent) {
            this.permanent = permanent;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminSetUserPasswordRequest build() {
            return new AdminSetUserPasswordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
