/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the event feedback type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventFeedbackType implements SdkPojo, Serializable,
        ToCopyableBuilder<EventFeedbackType.Builder, EventFeedbackType> {
    private static final SdkField<String> FEEDBACK_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventFeedbackType::feedbackValueAsString)).setter(setter(Builder::feedbackValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackValue").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventFeedbackType::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()).build();

    private static final SdkField<Instant> FEEDBACK_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(EventFeedbackType::feedbackDate)).setter(setter(Builder::feedbackDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEEDBACK_VALUE_FIELD,
            PROVIDER_FIELD, FEEDBACK_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String feedbackValue;

    private final String provider;

    private final Instant feedbackDate;

    private EventFeedbackType(BuilderImpl builder) {
        this.feedbackValue = builder.feedbackValue;
        this.provider = builder.provider;
        this.feedbackDate = builder.feedbackDate;
    }

    /**
     * <p>
     * The event feedback value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedbackValue}
     * will return {@link FeedbackValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #feedbackValueAsString}.
     * </p>
     * 
     * @return The event feedback value.
     * @see FeedbackValueType
     */
    public FeedbackValueType feedbackValue() {
        return FeedbackValueType.fromValue(feedbackValue);
    }

    /**
     * <p>
     * The event feedback value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedbackValue}
     * will return {@link FeedbackValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #feedbackValueAsString}.
     * </p>
     * 
     * @return The event feedback value.
     * @see FeedbackValueType
     */
    public String feedbackValueAsString() {
        return feedbackValue;
    }

    /**
     * <p>
     * The provider.
     * </p>
     * 
     * @return The provider.
     */
    public String provider() {
        return provider;
    }

    /**
     * <p>
     * The event feedback date.
     * </p>
     * 
     * @return The event feedback date.
     */
    public Instant feedbackDate() {
        return feedbackDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(feedbackValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventFeedbackType)) {
            return false;
        }
        EventFeedbackType other = (EventFeedbackType) obj;
        return Objects.equals(feedbackValueAsString(), other.feedbackValueAsString())
                && Objects.equals(provider(), other.provider()) && Objects.equals(feedbackDate(), other.feedbackDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EventFeedbackType").add("FeedbackValue", feedbackValueAsString()).add("Provider", provider())
                .add("FeedbackDate", feedbackDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeedbackValue":
            return Optional.ofNullable(clazz.cast(feedbackValueAsString()));
        case "Provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "FeedbackDate":
            return Optional.ofNullable(clazz.cast(feedbackDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventFeedbackType, T> g) {
        return obj -> g.apply((EventFeedbackType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventFeedbackType> {
        /**
         * <p>
         * The event feedback value.
         * </p>
         * 
         * @param feedbackValue
         *        The event feedback value.
         * @see FeedbackValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeedbackValueType
         */
        Builder feedbackValue(String feedbackValue);

        /**
         * <p>
         * The event feedback value.
         * </p>
         * 
         * @param feedbackValue
         *        The event feedback value.
         * @see FeedbackValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeedbackValueType
         */
        Builder feedbackValue(FeedbackValueType feedbackValue);

        /**
         * <p>
         * The provider.
         * </p>
         * 
         * @param provider
         *        The provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * The event feedback date.
         * </p>
         * 
         * @param feedbackDate
         *        The event feedback date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedbackDate(Instant feedbackDate);
    }

    static final class BuilderImpl implements Builder {
        private String feedbackValue;

        private String provider;

        private Instant feedbackDate;

        private BuilderImpl() {
        }

        private BuilderImpl(EventFeedbackType model) {
            feedbackValue(model.feedbackValue);
            provider(model.provider);
            feedbackDate(model.feedbackDate);
        }

        public final String getFeedbackValueAsString() {
            return feedbackValue;
        }

        @Override
        public final Builder feedbackValue(String feedbackValue) {
            this.feedbackValue = feedbackValue;
            return this;
        }

        @Override
        public final Builder feedbackValue(FeedbackValueType feedbackValue) {
            this.feedbackValue(feedbackValue == null ? null : feedbackValue.toString());
            return this;
        }

        public final void setFeedbackValue(String feedbackValue) {
            this.feedbackValue = feedbackValue;
        }

        public final String getProvider() {
            return provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        public final Instant getFeedbackDate() {
            return feedbackDate;
        }

        @Override
        public final Builder feedbackDate(Instant feedbackDate) {
            this.feedbackDate = feedbackDate;
            return this;
        }

        public final void setFeedbackDate(Instant feedbackDate) {
            this.feedbackDate = feedbackDate;
        }

        @Override
        public EventFeedbackType build() {
            return new EventFeedbackType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
