/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRiskConfigurationResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<DescribeRiskConfigurationResponse.Builder, DescribeRiskConfigurationResponse> {
    private static final SdkField<RiskConfigurationType> RISK_CONFIGURATION_FIELD = SdkField
            .<RiskConfigurationType> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeRiskConfigurationResponse::riskConfiguration)).setter(setter(Builder::riskConfiguration))
            .constructor(RiskConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RISK_CONFIGURATION_FIELD));

    private final RiskConfigurationType riskConfiguration;

    private DescribeRiskConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.riskConfiguration = builder.riskConfiguration;
    }

    /**
     * <p>
     * The risk configuration.
     * </p>
     * 
     * @return The risk configuration.
     */
    public RiskConfigurationType riskConfiguration() {
        return riskConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(riskConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRiskConfigurationResponse)) {
            return false;
        }
        DescribeRiskConfigurationResponse other = (DescribeRiskConfigurationResponse) obj;
        return Objects.equals(riskConfiguration(), other.riskConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeRiskConfigurationResponse").add("RiskConfiguration", riskConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RiskConfiguration":
            return Optional.ofNullable(clazz.cast(riskConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRiskConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeRiskConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRiskConfigurationResponse> {
        /**
         * <p>
         * The risk configuration.
         * </p>
         * 
         * @param riskConfiguration
         *        The risk configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskConfiguration(RiskConfigurationType riskConfiguration);

        /**
         * <p>
         * The risk configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link RiskConfigurationType.Builder} avoiding the need
         * to create one manually via {@link RiskConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link RiskConfigurationType.Builder#build()} is called immediately and
         * its result is passed to {@link #riskConfiguration(RiskConfigurationType)}.
         * 
         * @param riskConfiguration
         *        a consumer that will call methods on {@link RiskConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #riskConfiguration(RiskConfigurationType)
         */
        default Builder riskConfiguration(Consumer<RiskConfigurationType.Builder> riskConfiguration) {
            return riskConfiguration(RiskConfigurationType.builder().applyMutation(riskConfiguration).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private RiskConfigurationType riskConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRiskConfigurationResponse model) {
            super(model);
            riskConfiguration(model.riskConfiguration);
        }

        public final RiskConfigurationType.Builder getRiskConfiguration() {
            return riskConfiguration != null ? riskConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder riskConfiguration(RiskConfigurationType riskConfiguration) {
            this.riskConfiguration = riskConfiguration;
            return this;
        }

        public final void setRiskConfiguration(RiskConfigurationType.BuilderImpl riskConfiguration) {
            this.riskConfiguration = riskConfiguration != null ? riskConfiguration.build() : null;
        }

        @Override
        public DescribeRiskConfigurationResponse build() {
            return new DescribeRiskConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
