/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the user context data captured at the time of an event request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventContextDataType implements SdkPojo, Serializable,
        ToCopyableBuilder<EventContextDataType.Builder, EventContextDataType> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventContextDataType::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventContextDataType::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventContextDataType::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventContextDataType::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventContextDataType::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_FIELD,
            DEVICE_NAME_FIELD, TIMEZONE_FIELD, CITY_FIELD, COUNTRY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipAddress;

    private final String deviceName;

    private final String timezone;

    private final String city;

    private final String country;

    private EventContextDataType(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.deviceName = builder.deviceName;
        this.timezone = builder.timezone;
        this.city = builder.city;
        this.country = builder.country;
    }

    /**
     * <p>
     * The user's IP address.
     * </p>
     * 
     * @return The user's IP address.
     */
    public String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The user's device name.
     * </p>
     * 
     * @return The user's device name.
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The user's time zone.
     * </p>
     * 
     * @return The user's time zone.
     */
    public String timezone() {
        return timezone;
    }

    /**
     * <p>
     * The user's city.
     * </p>
     * 
     * @return The user's city.
     */
    public String city() {
        return city;
    }

    /**
     * <p>
     * The user's country.
     * </p>
     * 
     * @return The user's country.
     */
    public String country() {
        return country;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventContextDataType)) {
            return false;
        }
        EventContextDataType other = (EventContextDataType) obj;
        return Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(timezone(), other.timezone()) && Objects.equals(city(), other.city())
                && Objects.equals(country(), other.country());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EventContextDataType").add("IpAddress", ipAddress()).add("DeviceName", deviceName())
                .add("Timezone", timezone()).add("City", city()).add("Country", country()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventContextDataType, T> g) {
        return obj -> g.apply((EventContextDataType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventContextDataType> {
        /**
         * <p>
         * The user's IP address.
         * </p>
         * 
         * @param ipAddress
         *        The user's IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The user's device name.
         * </p>
         * 
         * @param deviceName
         *        The user's device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The user's time zone.
         * </p>
         * 
         * @param timezone
         *        The user's time zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * The user's city.
         * </p>
         * 
         * @param city
         *        The user's city.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The user's country.
         * </p>
         * 
         * @param country
         *        The user's country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);
    }

    static final class BuilderImpl implements Builder {
        private String ipAddress;

        private String deviceName;

        private String timezone;

        private String city;

        private String country;

        private BuilderImpl() {
        }

        private BuilderImpl(EventContextDataType model) {
            ipAddress(model.ipAddress);
            deviceName(model.deviceName);
            timezone(model.timezone);
            city(model.city);
            country(model.country);
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getTimezone() {
            return timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final String getCity() {
            return city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        public final String getCountry() {
            return country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public EventContextDataType build() {
            return new EventContextDataType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
