/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * You can use this parameter to set an MFA configuration that uses the SMS delivery medium.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminSetUserSettingsRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<AdminSetUserSettingsRequest.Builder, AdminSetUserSettingsRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminSetUserSettingsRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminSetUserSettingsRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<List<MFAOptionType>> MFA_OPTIONS_FIELD = SdkField
            .<List<MFAOptionType>> builder(MarshallingType.LIST)
            .getter(getter(AdminSetUserSettingsRequest::mfaOptions))
            .setter(setter(Builder::mfaOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MFAOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MFAOptionType> builder(MarshallingType.SDK_POJO)
                                            .constructor(MFAOptionType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            USERNAME_FIELD, MFA_OPTIONS_FIELD));

    private final String userPoolId;

    private final String username;

    private final List<MFAOptionType> mfaOptions;

    private AdminSetUserSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.username = builder.username;
        this.mfaOptions = builder.mfaOptions;
    }

    /**
     * <p>
     * The ID of the user pool that contains the user that you are setting options for.
     * </p>
     * 
     * @return The ID of the user pool that contains the user that you are setting options for.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The user name of the user that you are setting options for.
     * </p>
     * 
     * @return The user name of the user that you are setting options for.
     */
    public String username() {
        return username;
    }

    /**
     * Returns true if the MFAOptions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMfaOptions() {
        return mfaOptions != null && !(mfaOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can use this parameter only to set an SMS configuration that uses SMS for delivery.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMfaOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return You can use this parameter only to set an SMS configuration that uses SMS for delivery.
     */
    public List<MFAOptionType> mfaOptions() {
        return mfaOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(mfaOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminSetUserSettingsRequest)) {
            return false;
        }
        AdminSetUserSettingsRequest other = (AdminSetUserSettingsRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(username(), other.username())
                && Objects.equals(mfaOptions(), other.mfaOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AdminSetUserSettingsRequest").add("UserPoolId", userPoolId())
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***").add("MFAOptions", mfaOptions())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "MFAOptions":
            return Optional.ofNullable(clazz.cast(mfaOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminSetUserSettingsRequest, T> g) {
        return obj -> g.apply((AdminSetUserSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AdminSetUserSettingsRequest> {
        /**
         * <p>
         * The ID of the user pool that contains the user that you are setting options for.
         * </p>
         * 
         * @param userPoolId
         *        The ID of the user pool that contains the user that you are setting options for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The user name of the user that you are setting options for.
         * </p>
         * 
         * @param username
         *        The user name of the user that you are setting options for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * You can use this parameter only to set an SMS configuration that uses SMS for delivery.
         * </p>
         * 
         * @param mfaOptions
         *        You can use this parameter only to set an SMS configuration that uses SMS for delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaOptions(Collection<MFAOptionType> mfaOptions);

        /**
         * <p>
         * You can use this parameter only to set an SMS configuration that uses SMS for delivery.
         * </p>
         * 
         * @param mfaOptions
         *        You can use this parameter only to set an SMS configuration that uses SMS for delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaOptions(MFAOptionType... mfaOptions);

        /**
         * <p>
         * You can use this parameter only to set an SMS configuration that uses SMS for delivery.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MFAOptionType>.Builder} avoiding the need
         * to create one manually via {@link List<MFAOptionType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MFAOptionType>.Builder#build()} is called immediately and
         * its result is passed to {@link #mfaOptions(List<MFAOptionType>)}.
         * 
         * @param mfaOptions
         *        a consumer that will call methods on {@link List<MFAOptionType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mfaOptions(List<MFAOptionType>)
         */
        Builder mfaOptions(Consumer<MFAOptionType.Builder>... mfaOptions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String username;

        private List<MFAOptionType> mfaOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdminSetUserSettingsRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            username(model.username);
            mfaOptions(model.mfaOptions);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final Collection<MFAOptionType.Builder> getMfaOptions() {
            return mfaOptions != null ? mfaOptions.stream().map(MFAOptionType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mfaOptions(Collection<MFAOptionType> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copy(mfaOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(MFAOptionType... mfaOptions) {
            mfaOptions(Arrays.asList(mfaOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(Consumer<MFAOptionType.Builder>... mfaOptions) {
            mfaOptions(Stream.of(mfaOptions).map(c -> MFAOptionType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMfaOptions(Collection<MFAOptionType.BuilderImpl> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copyFromBuilder(mfaOptions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminSetUserSettingsRequest build() {
            return new AdminSetUserSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
