/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The UpdateUserPoolDomain request input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserPoolDomainRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<UpdateUserPoolDomainRequest.Builder, UpdateUserPoolDomainRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserPoolDomainRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserPoolDomainRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<CustomDomainConfigType> CUSTOM_DOMAIN_CONFIG_FIELD = SdkField
            .<CustomDomainConfigType> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateUserPoolDomainRequest::customDomainConfig)).setter(setter(Builder::customDomainConfig))
            .constructor(CustomDomainConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            USER_POOL_ID_FIELD, CUSTOM_DOMAIN_CONFIG_FIELD));

    private final String domain;

    private final String userPoolId;

    private final CustomDomainConfigType customDomainConfig;

    private UpdateUserPoolDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.userPoolId = builder.userPoolId;
        this.customDomainConfig = builder.customDomainConfig;
    }

    /**
     * <p>
     * The domain name for the custom domain that hosts the sign-up and sign-in pages for your application. For example:
     * <code>auth.example.com</code>.
     * </p>
     * <p>
     * This string can include only lowercase letters, numbers, and hyphens. Do not use a hyphen for the first or last
     * character. Use periods to separate subdomain names.
     * </p>
     * 
     * @return The domain name for the custom domain that hosts the sign-up and sign-in pages for your application. For
     *         example: <code>auth.example.com</code>. </p>
     *         <p>
     *         This string can include only lowercase letters, numbers, and hyphens. Do not use a hyphen for the first
     *         or last character. Use periods to separate subdomain names.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The ID of the user pool that is associated with the custom domain that you are updating the certificate for.
     * </p>
     * 
     * @return The ID of the user pool that is associated with the custom domain that you are updating the certificate
     *         for.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The configuration for a custom domain that hosts the sign-up and sign-in pages for your application. Use this
     * object to specify an SSL certificate that is managed by ACM.
     * </p>
     * 
     * @return The configuration for a custom domain that hosts the sign-up and sign-in pages for your application. Use
     *         this object to specify an SSL certificate that is managed by ACM.
     */
    public CustomDomainConfigType customDomainConfig() {
        return customDomainConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserPoolDomainRequest)) {
            return false;
        }
        UpdateUserPoolDomainRequest other = (UpdateUserPoolDomainRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(userPoolId(), other.userPoolId())
                && Objects.equals(customDomainConfig(), other.customDomainConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateUserPoolDomainRequest").add("Domain", domain()).add("UserPoolId", userPoolId())
                .add("CustomDomainConfig", customDomainConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "CustomDomainConfig":
            return Optional.ofNullable(clazz.cast(customDomainConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserPoolDomainRequest, T> g) {
        return obj -> g.apply((UpdateUserPoolDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateUserPoolDomainRequest> {
        /**
         * <p>
         * The domain name for the custom domain that hosts the sign-up and sign-in pages for your application. For
         * example: <code>auth.example.com</code>.
         * </p>
         * <p>
         * This string can include only lowercase letters, numbers, and hyphens. Do not use a hyphen for the first or
         * last character. Use periods to separate subdomain names.
         * </p>
         * 
         * @param domain
         *        The domain name for the custom domain that hosts the sign-up and sign-in pages for your application.
         *        For example: <code>auth.example.com</code>. </p>
         *        <p>
         *        This string can include only lowercase letters, numbers, and hyphens. Do not use a hyphen for the
         *        first or last character. Use periods to separate subdomain names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The ID of the user pool that is associated with the custom domain that you are updating the certificate for.
         * </p>
         * 
         * @param userPoolId
         *        The ID of the user pool that is associated with the custom domain that you are updating the
         *        certificate for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The configuration for a custom domain that hosts the sign-up and sign-in pages for your application. Use this
         * object to specify an SSL certificate that is managed by ACM.
         * </p>
         * 
         * @param customDomainConfig
         *        The configuration for a custom domain that hosts the sign-up and sign-in pages for your application.
         *        Use this object to specify an SSL certificate that is managed by ACM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainConfig(CustomDomainConfigType customDomainConfig);

        /**
         * <p>
         * The configuration for a custom domain that hosts the sign-up and sign-in pages for your application. Use this
         * object to specify an SSL certificate that is managed by ACM.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomDomainConfigType.Builder} avoiding the
         * need to create one manually via {@link CustomDomainConfigType#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomDomainConfigType.Builder#build()} is called immediately and
         * its result is passed to {@link #customDomainConfig(CustomDomainConfigType)}.
         * 
         * @param customDomainConfig
         *        a consumer that will call methods on {@link CustomDomainConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDomainConfig(CustomDomainConfigType)
         */
        default Builder customDomainConfig(Consumer<CustomDomainConfigType.Builder> customDomainConfig) {
            return customDomainConfig(CustomDomainConfigType.builder().applyMutation(customDomainConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String domain;

        private String userPoolId;

        private CustomDomainConfigType customDomainConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserPoolDomainRequest model) {
            super(model);
            domain(model.domain);
            userPoolId(model.userPoolId);
            customDomainConfig(model.customDomainConfig);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final CustomDomainConfigType.Builder getCustomDomainConfig() {
            return customDomainConfig != null ? customDomainConfig.toBuilder() : null;
        }

        @Override
        public final Builder customDomainConfig(CustomDomainConfigType customDomainConfig) {
            this.customDomainConfig = customDomainConfig;
            return this;
        }

        public final void setCustomDomainConfig(CustomDomainConfigType.BuilderImpl customDomainConfig) {
            this.customDomainConfig = customDomainConfig != null ? customDomainConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserPoolDomainRequest build() {
            return new UpdateUserPoolDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
