/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a user pool client.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserPoolClientType implements SdkPojo, Serializable,
        ToCopyableBuilder<UserPoolClientType.Builder, UserPoolClientType> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolClientType::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> CLIENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolClientType::clientName)).setter(setter(Builder::clientName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientName").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolClientType::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolClientType::clientSecret)).setter(setter(Builder::clientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSecret").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(UserPoolClientType::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(UserPoolClientType::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Integer> REFRESH_TOKEN_VALIDITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UserPoolClientType::refreshTokenValidity)).setter(setter(Builder::refreshTokenValidity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshTokenValidity").build())
            .build();

    private static final SdkField<List<String>> READ_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UserPoolClientType::readAttributes))
            .setter(setter(Builder::readAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> WRITE_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UserPoolClientType::writeAttributes))
            .setter(setter(Builder::writeAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXPLICIT_AUTH_FLOWS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UserPoolClientType::explicitAuthFlowsAsStrings))
            .setter(setter(Builder::explicitAuthFlowsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplicitAuthFlows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_IDENTITY_PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UserPoolClientType::supportedIdentityProviders))
            .setter(setter(Builder::supportedIdentityProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedIdentityProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CALLBACK_UR_LS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UserPoolClientType::callbackURLs))
            .setter(setter(Builder::callbackURLs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackURLs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LOGOUT_UR_LS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UserPoolClientType::logoutURLs))
            .setter(setter(Builder::logoutURLs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoutURLs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_REDIRECT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolClientType::defaultRedirectURI)).setter(setter(Builder::defaultRedirectURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRedirectURI").build())
            .build();

    private static final SdkField<List<String>> ALLOWED_O_AUTH_FLOWS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UserPoolClientType::allowedOAuthFlowsAsStrings))
            .setter(setter(Builder::allowedOAuthFlowsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOAuthFlows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_O_AUTH_SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UserPoolClientType::allowedOAuthScopes))
            .setter(setter(Builder::allowedOAuthScopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOAuthScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALLOWED_O_AUTH_FLOWS_USER_POOL_CLIENT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UserPoolClientType::allowedOAuthFlowsUserPoolClient))
            .setter(setter(Builder::allowedOAuthFlowsUserPoolClient))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOAuthFlowsUserPoolClient")
                    .build()).build();

    private static final SdkField<AnalyticsConfigurationType> ANALYTICS_CONFIGURATION_FIELD = SdkField
            .<AnalyticsConfigurationType> builder(MarshallingType.SDK_POJO)
            .getter(getter(UserPoolClientType::analyticsConfiguration)).setter(setter(Builder::analyticsConfiguration))
            .constructor(AnalyticsConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyticsConfiguration").build())
            .build();

    private static final SdkField<String> PREVENT_USER_EXISTENCE_ERRORS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolClientType::preventUserExistenceErrorsAsString))
            .setter(setter(Builder::preventUserExistenceErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreventUserExistenceErrors").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            CLIENT_NAME_FIELD, CLIENT_ID_FIELD, CLIENT_SECRET_FIELD, LAST_MODIFIED_DATE_FIELD, CREATION_DATE_FIELD,
            REFRESH_TOKEN_VALIDITY_FIELD, READ_ATTRIBUTES_FIELD, WRITE_ATTRIBUTES_FIELD, EXPLICIT_AUTH_FLOWS_FIELD,
            SUPPORTED_IDENTITY_PROVIDERS_FIELD, CALLBACK_UR_LS_FIELD, LOGOUT_UR_LS_FIELD, DEFAULT_REDIRECT_URI_FIELD,
            ALLOWED_O_AUTH_FLOWS_FIELD, ALLOWED_O_AUTH_SCOPES_FIELD, ALLOWED_O_AUTH_FLOWS_USER_POOL_CLIENT_FIELD,
            ANALYTICS_CONFIGURATION_FIELD, PREVENT_USER_EXISTENCE_ERRORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userPoolId;

    private final String clientName;

    private final String clientId;

    private final String clientSecret;

    private final Instant lastModifiedDate;

    private final Instant creationDate;

    private final Integer refreshTokenValidity;

    private final List<String> readAttributes;

    private final List<String> writeAttributes;

    private final List<String> explicitAuthFlows;

    private final List<String> supportedIdentityProviders;

    private final List<String> callbackURLs;

    private final List<String> logoutURLs;

    private final String defaultRedirectURI;

    private final List<String> allowedOAuthFlows;

    private final List<String> allowedOAuthScopes;

    private final Boolean allowedOAuthFlowsUserPoolClient;

    private final AnalyticsConfigurationType analyticsConfiguration;

    private final String preventUserExistenceErrors;

    private UserPoolClientType(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.clientName = builder.clientName;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
        this.refreshTokenValidity = builder.refreshTokenValidity;
        this.readAttributes = builder.readAttributes;
        this.writeAttributes = builder.writeAttributes;
        this.explicitAuthFlows = builder.explicitAuthFlows;
        this.supportedIdentityProviders = builder.supportedIdentityProviders;
        this.callbackURLs = builder.callbackURLs;
        this.logoutURLs = builder.logoutURLs;
        this.defaultRedirectURI = builder.defaultRedirectURI;
        this.allowedOAuthFlows = builder.allowedOAuthFlows;
        this.allowedOAuthScopes = builder.allowedOAuthScopes;
        this.allowedOAuthFlowsUserPoolClient = builder.allowedOAuthFlowsUserPoolClient;
        this.analyticsConfiguration = builder.analyticsConfiguration;
        this.preventUserExistenceErrors = builder.preventUserExistenceErrors;
    }

    /**
     * <p>
     * The user pool ID for the user pool client.
     * </p>
     * 
     * @return The user pool ID for the user pool client.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The client name from the user pool request of the client type.
     * </p>
     * 
     * @return The client name from the user pool request of the client type.
     */
    public String clientName() {
        return clientName;
    }

    /**
     * <p>
     * The ID of the client associated with the user pool.
     * </p>
     * 
     * @return The ID of the client associated with the user pool.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The client secret from the user pool request of the client type.
     * </p>
     * 
     * @return The client secret from the user pool request of the client type.
     */
    public String clientSecret() {
        return clientSecret;
    }

    /**
     * <p>
     * The date the user pool client was last modified.
     * </p>
     * 
     * @return The date the user pool client was last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The date the user pool client was created.
     * </p>
     * 
     * @return The date the user pool client was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The time limit, in days, after which the refresh token is no longer valid and cannot be used.
     * </p>
     * 
     * @return The time limit, in days, after which the refresh token is no longer valid and cannot be used.
     */
    public Integer refreshTokenValidity() {
        return refreshTokenValidity;
    }

    /**
     * Returns true if the ReadAttributes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasReadAttributes() {
        return readAttributes != null && !(readAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Read-only attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReadAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Read-only attributes.
     */
    public List<String> readAttributes() {
        return readAttributes;
    }

    /**
     * Returns true if the WriteAttributes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasWriteAttributes() {
        return writeAttributes != null && !(writeAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The writeable attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWriteAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The writeable attributes.
     */
    public List<String> writeAttributes() {
        return writeAttributes;
    }

    /**
     * <p>
     * The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code>
     * prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note that values with
     * <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code> prefix.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
     * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
     * this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure Remote
     * Password protocol) protocol to verify passwords.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito receives
     * the password in the request instead of using the SRP protocol to verify passwords.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExplicitAuthFlows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The authentication flows that are supported by the user pool clients. Flow names without the
     *         <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note
     *         that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code>
     *         prefix.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
     *         <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting.
     *         With this authentication flow, Cognito receives the password in the request instead of using the SRP
     *         (Secure Remote Password protocol) protocol to verify passwords.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito
     *         receives the password in the request instead of using the SRP protocol to verify passwords.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
     *         </p>
     *         </li>
     */
    public List<ExplicitAuthFlowsType> explicitAuthFlows() {
        return ExplicitAuthFlowsListTypeCopier.copyStringToEnum(explicitAuthFlows);
    }

    /**
     * Returns true if the ExplicitAuthFlows property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasExplicitAuthFlows() {
        return explicitAuthFlows != null && !(explicitAuthFlows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code>
     * prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note that values with
     * <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code> prefix.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
     * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
     * this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure Remote
     * Password protocol) protocol to verify passwords.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito receives
     * the password in the request instead of using the SRP protocol to verify passwords.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExplicitAuthFlows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The authentication flows that are supported by the user pool clients. Flow names without the
     *         <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note
     *         that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code>
     *         prefix.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
     *         <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting.
     *         With this authentication flow, Cognito receives the password in the request instead of using the SRP
     *         (Secure Remote Password protocol) protocol to verify passwords.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito
     *         receives the password in the request instead of using the SRP protocol to verify passwords.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
     *         </p>
     *         </li>
     */
    public List<String> explicitAuthFlowsAsStrings() {
        return explicitAuthFlows;
    }

    /**
     * Returns true if the SupportedIdentityProviders property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasSupportedIdentityProviders() {
        return supportedIdentityProviders != null && !(supportedIdentityProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of provider names for the identity providers that are supported on this client.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedIdentityProviders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of provider names for the identity providers that are supported on this client.
     */
    public List<String> supportedIdentityProviders() {
        return supportedIdentityProviders;
    }

    /**
     * Returns true if the CallbackURLs property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCallbackURLs() {
        return callbackURLs != null && !(callbackURLs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of allowed redirect (callback) URLs for the identity providers.
     * </p>
     * <p>
     * A redirect URI must:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Be an absolute URI.
     * </p>
     * </li>
     * <li>
     * <p>
     * Be registered with the authorization server.
     * </p>
     * </li>
     * <li>
     * <p>
     * Not include a fragment component.
     * </p>
     * </li>
     * </ul>
     * <p>
     * See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
     * </p>
     * <p>
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     * </p>
     * <p>
     * App callback URLs such as myapp://example are also supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCallbackURLs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of allowed redirect (callback) URLs for the identity providers.</p>
     *         <p>
     *         A redirect URI must:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Be an absolute URI.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be registered with the authorization server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not include a fragment component.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
     *         </p>
     *         <p>
     *         Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     *         </p>
     *         <p>
     *         App callback URLs such as myapp://example are also supported.
     */
    public List<String> callbackURLs() {
        return callbackURLs;
    }

    /**
     * Returns true if the LogoutURLs property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLogoutURLs() {
        return logoutURLs != null && !(logoutURLs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of allowed logout URLs for the identity providers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLogoutURLs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of allowed logout URLs for the identity providers.
     */
    public List<String> logoutURLs() {
        return logoutURLs;
    }

    /**
     * <p>
     * The default redirect URI. Must be in the <code>CallbackURLs</code> list.
     * </p>
     * <p>
     * A redirect URI must:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Be an absolute URI.
     * </p>
     * </li>
     * <li>
     * <p>
     * Be registered with the authorization server.
     * </p>
     * </li>
     * <li>
     * <p>
     * Not include a fragment component.
     * </p>
     * </li>
     * </ul>
     * <p>
     * See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
     * </p>
     * <p>
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     * </p>
     * <p>
     * App callback URLs such as myapp://example are also supported.
     * </p>
     * 
     * @return The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
     *         <p>
     *         A redirect URI must:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Be an absolute URI.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be registered with the authorization server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not include a fragment component.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
     *         </p>
     *         <p>
     *         Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     *         </p>
     *         <p>
     *         App callback URLs such as myapp://example are also supported.
     */
    public String defaultRedirectURI() {
        return defaultRedirectURI;
    }

    /**
     * <p>
     * Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response.
     * This code can be exchanged for access tokens with the token endpoint.
     * </p>
     * <p>
     * Set to <code>token</code> to specify that the client should get the access token (and, optionally, ID token,
     * based on scopes) directly.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedOAuthFlows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the
     *         response. This code can be exchanged for access tokens with the token endpoint.</p>
     *         <p>
     *         Set to <code>token</code> to specify that the client should get the access token (and, optionally, ID
     *         token, based on scopes) directly.
     */
    public List<OAuthFlowType> allowedOAuthFlows() {
        return OAuthFlowsTypeCopier.copyStringToEnum(allowedOAuthFlows);
    }

    /**
     * Returns true if the AllowedOAuthFlows property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAllowedOAuthFlows() {
        return allowedOAuthFlows != null && !(allowedOAuthFlows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response.
     * This code can be exchanged for access tokens with the token endpoint.
     * </p>
     * <p>
     * Set to <code>token</code> to specify that the client should get the access token (and, optionally, ID token,
     * based on scopes) directly.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedOAuthFlows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the
     *         response. This code can be exchanged for access tokens with the token endpoint.</p>
     *         <p>
     *         Set to <code>token</code> to specify that the client should get the access token (and, optionally, ID
     *         token, based on scopes) directly.
     */
    public List<String> allowedOAuthFlowsAsStrings() {
        return allowedOAuthFlows;
    }

    /**
     * Returns true if the AllowedOAuthScopes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAllowedOAuthScopes() {
        return allowedOAuthScopes != null && !(allowedOAuthScopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of allowed <code>OAuth</code> scopes. Currently supported values are <code>"phone"</code>,
     * <code>"email"</code>, <code>"openid"</code>, and <code>"Cognito"</code>. In addition to these values, custom
     * scopes created in Resource Servers are also supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedOAuthScopes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of allowed <code>OAuth</code> scopes. Currently supported values are <code>"phone"</code>,
     *         <code>"email"</code>, <code>"openid"</code>, and <code>"Cognito"</code>. In addition to these values,
     *         custom scopes created in Resource Servers are also supported.
     */
    public List<String> allowedOAuthScopes() {
        return allowedOAuthScopes;
    }

    /**
     * <p>
     * Set to TRUE if the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.
     * </p>
     * 
     * @return Set to TRUE if the client is allowed to follow the OAuth protocol when interacting with Cognito user
     *         pools.
     */
    public Boolean allowedOAuthFlowsUserPoolClient() {
        return allowedOAuthFlowsUserPoolClient;
    }

    /**
     * <p>
     * The Amazon Pinpoint analytics configuration for the user pool client.
     * </p>
     * 
     * @return The Amazon Pinpoint analytics configuration for the user pool client.
     */
    public AnalyticsConfigurationType analyticsConfiguration() {
        return analyticsConfiguration;
    }

    /**
     * <p>
     * Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account
     * confirmation, and password recovery when the user does not exist in the user pool. When set to
     * <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the username
     * or password was incorrect, and account confirmation and password recovery return a response indicating a code was
     * sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will return a
     * <code>UserNotFoundException</code> exception if the user does not exist in the user pool.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> - This prevents user existence-related errors.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are not
     * prevented.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This setting affects the behavior of following APIs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>AdminInitiateAuth</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>AdminRespondToAuthChallenge</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>InitiateAuth</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>RespondToAuthChallenge</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ForgotPassword</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ConfirmForgotPassword</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ConfirmSignUp</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ResendConfirmationCode</a>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * After January 1st 2020, the value of <code>PreventUserExistenceErrors</code> will default to <code>ENABLED</code>
     * for newly created user pool clients if no value is provided.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #preventUserExistenceErrors} will return {@link PreventUserExistenceErrorTypes#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #preventUserExistenceErrorsAsString}.
     * </p>
     * 
     * @return Use this setting to choose which errors and responses are returned by Cognito APIs during authentication,
     *         account confirmation, and password recovery when the user does not exist in the user pool. When set to
     *         <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the
     *         username or password was incorrect, and account confirmation and password recovery return a response
     *         indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will
     *         return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - This prevents user existence-related errors.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are
     *         not prevented.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This setting affects the behavior of following APIs:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>AdminInitiateAuth</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>AdminRespondToAuthChallenge</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>InitiateAuth</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>RespondToAuthChallenge</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>ForgotPassword</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>ConfirmForgotPassword</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>ConfirmSignUp</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>ResendConfirmationCode</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         After January 1st 2020, the value of <code>PreventUserExistenceErrors</code> will default to
     *         <code>ENABLED</code> for newly created user pool clients if no value is provided.
     *         </p>
     * @see PreventUserExistenceErrorTypes
     */
    public PreventUserExistenceErrorTypes preventUserExistenceErrors() {
        return PreventUserExistenceErrorTypes.fromValue(preventUserExistenceErrors);
    }

    /**
     * <p>
     * Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account
     * confirmation, and password recovery when the user does not exist in the user pool. When set to
     * <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the username
     * or password was incorrect, and account confirmation and password recovery return a response indicating a code was
     * sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will return a
     * <code>UserNotFoundException</code> exception if the user does not exist in the user pool.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> - This prevents user existence-related errors.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are not
     * prevented.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This setting affects the behavior of following APIs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>AdminInitiateAuth</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>AdminRespondToAuthChallenge</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>InitiateAuth</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>RespondToAuthChallenge</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ForgotPassword</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ConfirmForgotPassword</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ConfirmSignUp</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ResendConfirmationCode</a>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * After January 1st 2020, the value of <code>PreventUserExistenceErrors</code> will default to <code>ENABLED</code>
     * for newly created user pool clients if no value is provided.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #preventUserExistenceErrors} will return {@link PreventUserExistenceErrorTypes#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #preventUserExistenceErrorsAsString}.
     * </p>
     * 
     * @return Use this setting to choose which errors and responses are returned by Cognito APIs during authentication,
     *         account confirmation, and password recovery when the user does not exist in the user pool. When set to
     *         <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the
     *         username or password was incorrect, and account confirmation and password recovery return a response
     *         indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will
     *         return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - This prevents user existence-related errors.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are
     *         not prevented.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This setting affects the behavior of following APIs:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>AdminInitiateAuth</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>AdminRespondToAuthChallenge</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>InitiateAuth</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>RespondToAuthChallenge</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>ForgotPassword</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>ConfirmForgotPassword</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>ConfirmSignUp</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>ResendConfirmationCode</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         After January 1st 2020, the value of <code>PreventUserExistenceErrors</code> will default to
     *         <code>ENABLED</code> for newly created user pool clients if no value is provided.
     *         </p>
     * @see PreventUserExistenceErrorTypes
     */
    public String preventUserExistenceErrorsAsString() {
        return preventUserExistenceErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(clientName());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(refreshTokenValidity());
        hashCode = 31 * hashCode + Objects.hashCode(readAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(writeAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(explicitAuthFlowsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(supportedIdentityProviders());
        hashCode = 31 * hashCode + Objects.hashCode(callbackURLs());
        hashCode = 31 * hashCode + Objects.hashCode(logoutURLs());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRedirectURI());
        hashCode = 31 * hashCode + Objects.hashCode(allowedOAuthFlowsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(allowedOAuthScopes());
        hashCode = 31 * hashCode + Objects.hashCode(allowedOAuthFlowsUserPoolClient());
        hashCode = 31 * hashCode + Objects.hashCode(analyticsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(preventUserExistenceErrorsAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolClientType)) {
            return false;
        }
        UserPoolClientType other = (UserPoolClientType) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(clientName(), other.clientName())
                && Objects.equals(clientId(), other.clientId()) && Objects.equals(clientSecret(), other.clientSecret())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(refreshTokenValidity(), other.refreshTokenValidity())
                && Objects.equals(readAttributes(), other.readAttributes())
                && Objects.equals(writeAttributes(), other.writeAttributes())
                && Objects.equals(explicitAuthFlowsAsStrings(), other.explicitAuthFlowsAsStrings())
                && Objects.equals(supportedIdentityProviders(), other.supportedIdentityProviders())
                && Objects.equals(callbackURLs(), other.callbackURLs()) && Objects.equals(logoutURLs(), other.logoutURLs())
                && Objects.equals(defaultRedirectURI(), other.defaultRedirectURI())
                && Objects.equals(allowedOAuthFlowsAsStrings(), other.allowedOAuthFlowsAsStrings())
                && Objects.equals(allowedOAuthScopes(), other.allowedOAuthScopes())
                && Objects.equals(allowedOAuthFlowsUserPoolClient(), other.allowedOAuthFlowsUserPoolClient())
                && Objects.equals(analyticsConfiguration(), other.analyticsConfiguration())
                && Objects.equals(preventUserExistenceErrorsAsString(), other.preventUserExistenceErrorsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UserPoolClientType").add("UserPoolId", userPoolId()).add("ClientName", clientName())
                .add("ClientId", clientId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientSecret", clientSecret() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastModifiedDate", lastModifiedDate()).add("CreationDate", creationDate())
                .add("RefreshTokenValidity", refreshTokenValidity()).add("ReadAttributes", readAttributes())
                .add("WriteAttributes", writeAttributes()).add("ExplicitAuthFlows", explicitAuthFlowsAsStrings())
                .add("SupportedIdentityProviders", supportedIdentityProviders()).add("CallbackURLs", callbackURLs())
                .add("LogoutURLs", logoutURLs()).add("DefaultRedirectURI", defaultRedirectURI())
                .add("AllowedOAuthFlows", allowedOAuthFlowsAsStrings()).add("AllowedOAuthScopes", allowedOAuthScopes())
                .add("AllowedOAuthFlowsUserPoolClient", allowedOAuthFlowsUserPoolClient())
                .add("AnalyticsConfiguration", analyticsConfiguration())
                .add("PreventUserExistenceErrors", preventUserExistenceErrorsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ClientName":
            return Optional.ofNullable(clazz.cast(clientName()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "ClientSecret":
            return Optional.ofNullable(clazz.cast(clientSecret()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "RefreshTokenValidity":
            return Optional.ofNullable(clazz.cast(refreshTokenValidity()));
        case "ReadAttributes":
            return Optional.ofNullable(clazz.cast(readAttributes()));
        case "WriteAttributes":
            return Optional.ofNullable(clazz.cast(writeAttributes()));
        case "ExplicitAuthFlows":
            return Optional.ofNullable(clazz.cast(explicitAuthFlowsAsStrings()));
        case "SupportedIdentityProviders":
            return Optional.ofNullable(clazz.cast(supportedIdentityProviders()));
        case "CallbackURLs":
            return Optional.ofNullable(clazz.cast(callbackURLs()));
        case "LogoutURLs":
            return Optional.ofNullable(clazz.cast(logoutURLs()));
        case "DefaultRedirectURI":
            return Optional.ofNullable(clazz.cast(defaultRedirectURI()));
        case "AllowedOAuthFlows":
            return Optional.ofNullable(clazz.cast(allowedOAuthFlowsAsStrings()));
        case "AllowedOAuthScopes":
            return Optional.ofNullable(clazz.cast(allowedOAuthScopes()));
        case "AllowedOAuthFlowsUserPoolClient":
            return Optional.ofNullable(clazz.cast(allowedOAuthFlowsUserPoolClient()));
        case "AnalyticsConfiguration":
            return Optional.ofNullable(clazz.cast(analyticsConfiguration()));
        case "PreventUserExistenceErrors":
            return Optional.ofNullable(clazz.cast(preventUserExistenceErrorsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserPoolClientType, T> g) {
        return obj -> g.apply((UserPoolClientType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserPoolClientType> {
        /**
         * <p>
         * The user pool ID for the user pool client.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The client name from the user pool request of the client type.
         * </p>
         * 
         * @param clientName
         *        The client name from the user pool request of the client type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientName(String clientName);

        /**
         * <p>
         * The ID of the client associated with the user pool.
         * </p>
         * 
         * @param clientId
         *        The ID of the client associated with the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The client secret from the user pool request of the client type.
         * </p>
         * 
         * @param clientSecret
         *        The client secret from the user pool request of the client type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecret(String clientSecret);

        /**
         * <p>
         * The date the user pool client was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date the user pool client was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The date the user pool client was created.
         * </p>
         * 
         * @param creationDate
         *        The date the user pool client was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The time limit, in days, after which the refresh token is no longer valid and cannot be used.
         * </p>
         * 
         * @param refreshTokenValidity
         *        The time limit, in days, after which the refresh token is no longer valid and cannot be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshTokenValidity(Integer refreshTokenValidity);

        /**
         * <p>
         * The Read-only attributes.
         * </p>
         * 
         * @param readAttributes
         *        The Read-only attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readAttributes(Collection<String> readAttributes);

        /**
         * <p>
         * The Read-only attributes.
         * </p>
         * 
         * @param readAttributes
         *        The Read-only attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readAttributes(String... readAttributes);

        /**
         * <p>
         * The writeable attributes.
         * </p>
         * 
         * @param writeAttributes
         *        The writeable attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeAttributes(Collection<String> writeAttributes);

        /**
         * <p>
         * The writeable attributes.
         * </p>
         * 
         * @param writeAttributes
         *        The writeable attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeAttributes(String... writeAttributes);

        /**
         * <p>
         * The authentication flows that are supported by the user pool clients. Flow names without the
         * <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note
         * that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code>
         * prefix.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
         * this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure
         * Remote Password protocol) protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito
         * receives the password in the request instead of using the SRP protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param explicitAuthFlows
         *        The authentication flows that are supported by the user pool clients. Flow names without the
         *        <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix.
         *        Note that values with <code>ALLOW_</code> prefix cannot be used along with values without
         *        <code>ALLOW_</code> prefix.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         *        <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code>
         *        setting. With this authentication flow, Cognito receives the password in the request instead of using
         *        the SRP (Secure Remote Password protocol) protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow,
         *        Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitAuthFlowsWithStrings(Collection<String> explicitAuthFlows);

        /**
         * <p>
         * The authentication flows that are supported by the user pool clients. Flow names without the
         * <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note
         * that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code>
         * prefix.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
         * this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure
         * Remote Password protocol) protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito
         * receives the password in the request instead of using the SRP protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param explicitAuthFlows
         *        The authentication flows that are supported by the user pool clients. Flow names without the
         *        <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix.
         *        Note that values with <code>ALLOW_</code> prefix cannot be used along with values without
         *        <code>ALLOW_</code> prefix.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         *        <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code>
         *        setting. With this authentication flow, Cognito receives the password in the request instead of using
         *        the SRP (Secure Remote Password protocol) protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow,
         *        Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitAuthFlowsWithStrings(String... explicitAuthFlows);

        /**
         * <p>
         * The authentication flows that are supported by the user pool clients. Flow names without the
         * <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note
         * that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code>
         * prefix.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
         * this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure
         * Remote Password protocol) protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito
         * receives the password in the request instead of using the SRP protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param explicitAuthFlows
         *        The authentication flows that are supported by the user pool clients. Flow names without the
         *        <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix.
         *        Note that values with <code>ALLOW_</code> prefix cannot be used along with values without
         *        <code>ALLOW_</code> prefix.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         *        <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code>
         *        setting. With this authentication flow, Cognito receives the password in the request instead of using
         *        the SRP (Secure Remote Password protocol) protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow,
         *        Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitAuthFlows(Collection<ExplicitAuthFlowsType> explicitAuthFlows);

        /**
         * <p>
         * The authentication flows that are supported by the user pool clients. Flow names without the
         * <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note
         * that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code>
         * prefix.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
         * this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure
         * Remote Password protocol) protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito
         * receives the password in the request instead of using the SRP protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param explicitAuthFlows
         *        The authentication flows that are supported by the user pool clients. Flow names without the
         *        <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix.
         *        Note that values with <code>ALLOW_</code> prefix cannot be used along with values without
         *        <code>ALLOW_</code> prefix.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         *        <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code>
         *        setting. With this authentication flow, Cognito receives the password in the request instead of using
         *        the SRP (Secure Remote Password protocol) protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow,
         *        Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitAuthFlows(ExplicitAuthFlowsType... explicitAuthFlows);

        /**
         * <p>
         * A list of provider names for the identity providers that are supported on this client.
         * </p>
         * 
         * @param supportedIdentityProviders
         *        A list of provider names for the identity providers that are supported on this client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedIdentityProviders(Collection<String> supportedIdentityProviders);

        /**
         * <p>
         * A list of provider names for the identity providers that are supported on this client.
         * </p>
         * 
         * @param supportedIdentityProviders
         *        A list of provider names for the identity providers that are supported on this client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedIdentityProviders(String... supportedIdentityProviders);

        /**
         * <p>
         * A list of allowed redirect (callback) URLs for the identity providers.
         * </p>
         * <p>
         * A redirect URI must:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Be an absolute URI.
         * </p>
         * </li>
         * <li>
         * <p>
         * Be registered with the authorization server.
         * </p>
         * </li>
         * <li>
         * <p>
         * Not include a fragment component.
         * </p>
         * </li>
         * </ul>
         * <p>
         * See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         * </p>
         * <p>
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         * </p>
         * <p>
         * App callback URLs such as myapp://example are also supported.
         * </p>
         * 
         * @param callbackURLs
         *        A list of allowed redirect (callback) URLs for the identity providers.</p>
         *        <p>
         *        A redirect URI must:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Be an absolute URI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Be registered with the authorization server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Not include a fragment component.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         *        </p>
         *        <p>
         *        Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         *        </p>
         *        <p>
         *        App callback URLs such as myapp://example are also supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackURLs(Collection<String> callbackURLs);

        /**
         * <p>
         * A list of allowed redirect (callback) URLs for the identity providers.
         * </p>
         * <p>
         * A redirect URI must:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Be an absolute URI.
         * </p>
         * </li>
         * <li>
         * <p>
         * Be registered with the authorization server.
         * </p>
         * </li>
         * <li>
         * <p>
         * Not include a fragment component.
         * </p>
         * </li>
         * </ul>
         * <p>
         * See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         * </p>
         * <p>
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         * </p>
         * <p>
         * App callback URLs such as myapp://example are also supported.
         * </p>
         * 
         * @param callbackURLs
         *        A list of allowed redirect (callback) URLs for the identity providers.</p>
         *        <p>
         *        A redirect URI must:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Be an absolute URI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Be registered with the authorization server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Not include a fragment component.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         *        </p>
         *        <p>
         *        Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         *        </p>
         *        <p>
         *        App callback URLs such as myapp://example are also supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackURLs(String... callbackURLs);

        /**
         * <p>
         * A list of allowed logout URLs for the identity providers.
         * </p>
         * 
         * @param logoutURLs
         *        A list of allowed logout URLs for the identity providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoutURLs(Collection<String> logoutURLs);

        /**
         * <p>
         * A list of allowed logout URLs for the identity providers.
         * </p>
         * 
         * @param logoutURLs
         *        A list of allowed logout URLs for the identity providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoutURLs(String... logoutURLs);

        /**
         * <p>
         * The default redirect URI. Must be in the <code>CallbackURLs</code> list.
         * </p>
         * <p>
         * A redirect URI must:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Be an absolute URI.
         * </p>
         * </li>
         * <li>
         * <p>
         * Be registered with the authorization server.
         * </p>
         * </li>
         * <li>
         * <p>
         * Not include a fragment component.
         * </p>
         * </li>
         * </ul>
         * <p>
         * See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         * </p>
         * <p>
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         * </p>
         * <p>
         * App callback URLs such as myapp://example are also supported.
         * </p>
         * 
         * @param defaultRedirectURI
         *        The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
         *        <p>
         *        A redirect URI must:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Be an absolute URI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Be registered with the authorization server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Not include a fragment component.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         *        </p>
         *        <p>
         *        Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         *        </p>
         *        <p>
         *        App callback URLs such as myapp://example are also supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRedirectURI(String defaultRedirectURI);

        /**
         * <p>
         * Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response.
         * This code can be exchanged for access tokens with the token endpoint.
         * </p>
         * <p>
         * Set to <code>token</code> to specify that the client should get the access token (and, optionally, ID token,
         * based on scopes) directly.
         * </p>
         * 
         * @param allowedOAuthFlows
         *        Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the
         *        response. This code can be exchanged for access tokens with the token endpoint.</p>
         *        <p>
         *        Set to <code>token</code> to specify that the client should get the access token (and, optionally, ID
         *        token, based on scopes) directly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthFlowsWithStrings(Collection<String> allowedOAuthFlows);

        /**
         * <p>
         * Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response.
         * This code can be exchanged for access tokens with the token endpoint.
         * </p>
         * <p>
         * Set to <code>token</code> to specify that the client should get the access token (and, optionally, ID token,
         * based on scopes) directly.
         * </p>
         * 
         * @param allowedOAuthFlows
         *        Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the
         *        response. This code can be exchanged for access tokens with the token endpoint.</p>
         *        <p>
         *        Set to <code>token</code> to specify that the client should get the access token (and, optionally, ID
         *        token, based on scopes) directly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthFlowsWithStrings(String... allowedOAuthFlows);

        /**
         * <p>
         * Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response.
         * This code can be exchanged for access tokens with the token endpoint.
         * </p>
         * <p>
         * Set to <code>token</code> to specify that the client should get the access token (and, optionally, ID token,
         * based on scopes) directly.
         * </p>
         * 
         * @param allowedOAuthFlows
         *        Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the
         *        response. This code can be exchanged for access tokens with the token endpoint.</p>
         *        <p>
         *        Set to <code>token</code> to specify that the client should get the access token (and, optionally, ID
         *        token, based on scopes) directly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthFlows(Collection<OAuthFlowType> allowedOAuthFlows);

        /**
         * <p>
         * Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response.
         * This code can be exchanged for access tokens with the token endpoint.
         * </p>
         * <p>
         * Set to <code>token</code> to specify that the client should get the access token (and, optionally, ID token,
         * based on scopes) directly.
         * </p>
         * 
         * @param allowedOAuthFlows
         *        Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the
         *        response. This code can be exchanged for access tokens with the token endpoint.</p>
         *        <p>
         *        Set to <code>token</code> to specify that the client should get the access token (and, optionally, ID
         *        token, based on scopes) directly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthFlows(OAuthFlowType... allowedOAuthFlows);

        /**
         * <p>
         * A list of allowed <code>OAuth</code> scopes. Currently supported values are <code>"phone"</code>,
         * <code>"email"</code>, <code>"openid"</code>, and <code>"Cognito"</code>. In addition to these values, custom
         * scopes created in Resource Servers are also supported.
         * </p>
         * 
         * @param allowedOAuthScopes
         *        A list of allowed <code>OAuth</code> scopes. Currently supported values are <code>"phone"</code>,
         *        <code>"email"</code>, <code>"openid"</code>, and <code>"Cognito"</code>. In addition to these values,
         *        custom scopes created in Resource Servers are also supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthScopes(Collection<String> allowedOAuthScopes);

        /**
         * <p>
         * A list of allowed <code>OAuth</code> scopes. Currently supported values are <code>"phone"</code>,
         * <code>"email"</code>, <code>"openid"</code>, and <code>"Cognito"</code>. In addition to these values, custom
         * scopes created in Resource Servers are also supported.
         * </p>
         * 
         * @param allowedOAuthScopes
         *        A list of allowed <code>OAuth</code> scopes. Currently supported values are <code>"phone"</code>,
         *        <code>"email"</code>, <code>"openid"</code>, and <code>"Cognito"</code>. In addition to these values,
         *        custom scopes created in Resource Servers are also supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthScopes(String... allowedOAuthScopes);

        /**
         * <p>
         * Set to TRUE if the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.
         * </p>
         * 
         * @param allowedOAuthFlowsUserPoolClient
         *        Set to TRUE if the client is allowed to follow the OAuth protocol when interacting with Cognito user
         *        pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient);

        /**
         * <p>
         * The Amazon Pinpoint analytics configuration for the user pool client.
         * </p>
         * 
         * @param analyticsConfiguration
         *        The Amazon Pinpoint analytics configuration for the user pool client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyticsConfiguration(AnalyticsConfigurationType analyticsConfiguration);

        /**
         * <p>
         * The Amazon Pinpoint analytics configuration for the user pool client.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalyticsConfigurationType.Builder} avoiding the
         * need to create one manually via {@link AnalyticsConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalyticsConfigurationType.Builder#build()} is called immediately
         * and its result is passed to {@link #analyticsConfiguration(AnalyticsConfigurationType)}.
         * 
         * @param analyticsConfiguration
         *        a consumer that will call methods on {@link AnalyticsConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analyticsConfiguration(AnalyticsConfigurationType)
         */
        default Builder analyticsConfiguration(Consumer<AnalyticsConfigurationType.Builder> analyticsConfiguration) {
            return analyticsConfiguration(AnalyticsConfigurationType.builder().applyMutation(analyticsConfiguration).build());
        }

        /**
         * <p>
         * Use this setting to choose which errors and responses are returned by Cognito APIs during authentication,
         * account confirmation, and password recovery when the user does not exist in the user pool. When set to
         * <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the
         * username or password was incorrect, and account confirmation and password recovery return a response
         * indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will
         * return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> - This prevents user existence-related errors.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are not
         * prevented.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This setting affects the behavior of following APIs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>AdminInitiateAuth</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>AdminRespondToAuthChallenge</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>InitiateAuth</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>RespondToAuthChallenge</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>ForgotPassword</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>ConfirmForgotPassword</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>ConfirmSignUp</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>ResendConfirmationCode</a>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * After January 1st 2020, the value of <code>PreventUserExistenceErrors</code> will default to
         * <code>ENABLED</code> for newly created user pool clients if no value is provided.
         * </p>
         * </note>
         * 
         * @param preventUserExistenceErrors
         *        Use this setting to choose which errors and responses are returned by Cognito APIs during
         *        authentication, account confirmation, and password recovery when the user does not exist in the user
         *        pool. When set to <code>ENABLED</code> and the user does not exist, authentication returns an error
         *        indicating either the username or password was incorrect, and account confirmation and password
         *        recovery return a response indicating a code was sent to a simulated destination. When set to
         *        <code>LEGACY</code>, those APIs will return a <code>UserNotFoundException</code> exception if the user
         *        does not exist in the user pool.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - This prevents user existence-related errors.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors
         *        are not prevented.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This setting affects the behavior of following APIs:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>AdminInitiateAuth</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>AdminRespondToAuthChallenge</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>InitiateAuth</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>RespondToAuthChallenge</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>ForgotPassword</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>ConfirmForgotPassword</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>ConfirmSignUp</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>ResendConfirmationCode</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        After January 1st 2020, the value of <code>PreventUserExistenceErrors</code> will default to
         *        <code>ENABLED</code> for newly created user pool clients if no value is provided.
         *        </p>
         * @see PreventUserExistenceErrorTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreventUserExistenceErrorTypes
         */
        Builder preventUserExistenceErrors(String preventUserExistenceErrors);

        /**
         * <p>
         * Use this setting to choose which errors and responses are returned by Cognito APIs during authentication,
         * account confirmation, and password recovery when the user does not exist in the user pool. When set to
         * <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the
         * username or password was incorrect, and account confirmation and password recovery return a response
         * indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will
         * return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> - This prevents user existence-related errors.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are not
         * prevented.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This setting affects the behavior of following APIs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>AdminInitiateAuth</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>AdminRespondToAuthChallenge</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>InitiateAuth</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>RespondToAuthChallenge</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>ForgotPassword</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>ConfirmForgotPassword</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>ConfirmSignUp</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>ResendConfirmationCode</a>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * After January 1st 2020, the value of <code>PreventUserExistenceErrors</code> will default to
         * <code>ENABLED</code> for newly created user pool clients if no value is provided.
         * </p>
         * </note>
         * 
         * @param preventUserExistenceErrors
         *        Use this setting to choose which errors and responses are returned by Cognito APIs during
         *        authentication, account confirmation, and password recovery when the user does not exist in the user
         *        pool. When set to <code>ENABLED</code> and the user does not exist, authentication returns an error
         *        indicating either the username or password was incorrect, and account confirmation and password
         *        recovery return a response indicating a code was sent to a simulated destination. When set to
         *        <code>LEGACY</code>, those APIs will return a <code>UserNotFoundException</code> exception if the user
         *        does not exist in the user pool.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - This prevents user existence-related errors.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors
         *        are not prevented.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This setting affects the behavior of following APIs:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>AdminInitiateAuth</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>AdminRespondToAuthChallenge</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>InitiateAuth</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>RespondToAuthChallenge</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>ForgotPassword</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>ConfirmForgotPassword</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>ConfirmSignUp</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>ResendConfirmationCode</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        After January 1st 2020, the value of <code>PreventUserExistenceErrors</code> will default to
         *        <code>ENABLED</code> for newly created user pool clients if no value is provided.
         *        </p>
         * @see PreventUserExistenceErrorTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreventUserExistenceErrorTypes
         */
        Builder preventUserExistenceErrors(PreventUserExistenceErrorTypes preventUserExistenceErrors);
    }

    static final class BuilderImpl implements Builder {
        private String userPoolId;

        private String clientName;

        private String clientId;

        private String clientSecret;

        private Instant lastModifiedDate;

        private Instant creationDate;

        private Integer refreshTokenValidity;

        private List<String> readAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> writeAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> explicitAuthFlows = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedIdentityProviders = DefaultSdkAutoConstructList.getInstance();

        private List<String> callbackURLs = DefaultSdkAutoConstructList.getInstance();

        private List<String> logoutURLs = DefaultSdkAutoConstructList.getInstance();

        private String defaultRedirectURI;

        private List<String> allowedOAuthFlows = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedOAuthScopes = DefaultSdkAutoConstructList.getInstance();

        private Boolean allowedOAuthFlowsUserPoolClient;

        private AnalyticsConfigurationType analyticsConfiguration;

        private String preventUserExistenceErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPoolClientType model) {
            userPoolId(model.userPoolId);
            clientName(model.clientName);
            clientId(model.clientId);
            clientSecret(model.clientSecret);
            lastModifiedDate(model.lastModifiedDate);
            creationDate(model.creationDate);
            refreshTokenValidity(model.refreshTokenValidity);
            readAttributes(model.readAttributes);
            writeAttributes(model.writeAttributes);
            explicitAuthFlowsWithStrings(model.explicitAuthFlows);
            supportedIdentityProviders(model.supportedIdentityProviders);
            callbackURLs(model.callbackURLs);
            logoutURLs(model.logoutURLs);
            defaultRedirectURI(model.defaultRedirectURI);
            allowedOAuthFlowsWithStrings(model.allowedOAuthFlows);
            allowedOAuthScopes(model.allowedOAuthScopes);
            allowedOAuthFlowsUserPoolClient(model.allowedOAuthFlowsUserPoolClient);
            analyticsConfiguration(model.analyticsConfiguration);
            preventUserExistenceErrors(model.preventUserExistenceErrors);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getClientName() {
            return clientName;
        }

        @Override
        public final Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public final void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getClientSecret() {
            return clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Integer getRefreshTokenValidity() {
            return refreshTokenValidity;
        }

        @Override
        public final Builder refreshTokenValidity(Integer refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
            return this;
        }

        public final void setRefreshTokenValidity(Integer refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
        }

        public final Collection<String> getReadAttributes() {
            return readAttributes;
        }

        @Override
        public final Builder readAttributes(Collection<String> readAttributes) {
            this.readAttributes = ClientPermissionListTypeCopier.copy(readAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readAttributes(String... readAttributes) {
            readAttributes(Arrays.asList(readAttributes));
            return this;
        }

        public final void setReadAttributes(Collection<String> readAttributes) {
            this.readAttributes = ClientPermissionListTypeCopier.copy(readAttributes);
        }

        public final Collection<String> getWriteAttributes() {
            return writeAttributes;
        }

        @Override
        public final Builder writeAttributes(Collection<String> writeAttributes) {
            this.writeAttributes = ClientPermissionListTypeCopier.copy(writeAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder writeAttributes(String... writeAttributes) {
            writeAttributes(Arrays.asList(writeAttributes));
            return this;
        }

        public final void setWriteAttributes(Collection<String> writeAttributes) {
            this.writeAttributes = ClientPermissionListTypeCopier.copy(writeAttributes);
        }

        public final Collection<String> getExplicitAuthFlowsAsStrings() {
            return explicitAuthFlows;
        }

        @Override
        public final Builder explicitAuthFlowsWithStrings(Collection<String> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copy(explicitAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explicitAuthFlowsWithStrings(String... explicitAuthFlows) {
            explicitAuthFlowsWithStrings(Arrays.asList(explicitAuthFlows));
            return this;
        }

        @Override
        public final Builder explicitAuthFlows(Collection<ExplicitAuthFlowsType> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copyEnumToString(explicitAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explicitAuthFlows(ExplicitAuthFlowsType... explicitAuthFlows) {
            explicitAuthFlows(Arrays.asList(explicitAuthFlows));
            return this;
        }

        public final void setExplicitAuthFlowsWithStrings(Collection<String> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copy(explicitAuthFlows);
        }

        public final Collection<String> getSupportedIdentityProviders() {
            return supportedIdentityProviders;
        }

        @Override
        public final Builder supportedIdentityProviders(Collection<String> supportedIdentityProviders) {
            this.supportedIdentityProviders = SupportedIdentityProvidersListTypeCopier.copy(supportedIdentityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedIdentityProviders(String... supportedIdentityProviders) {
            supportedIdentityProviders(Arrays.asList(supportedIdentityProviders));
            return this;
        }

        public final void setSupportedIdentityProviders(Collection<String> supportedIdentityProviders) {
            this.supportedIdentityProviders = SupportedIdentityProvidersListTypeCopier.copy(supportedIdentityProviders);
        }

        public final Collection<String> getCallbackURLs() {
            return callbackURLs;
        }

        @Override
        public final Builder callbackURLs(Collection<String> callbackURLs) {
            this.callbackURLs = CallbackURLsListTypeCopier.copy(callbackURLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callbackURLs(String... callbackURLs) {
            callbackURLs(Arrays.asList(callbackURLs));
            return this;
        }

        public final void setCallbackURLs(Collection<String> callbackURLs) {
            this.callbackURLs = CallbackURLsListTypeCopier.copy(callbackURLs);
        }

        public final Collection<String> getLogoutURLs() {
            return logoutURLs;
        }

        @Override
        public final Builder logoutURLs(Collection<String> logoutURLs) {
            this.logoutURLs = LogoutURLsListTypeCopier.copy(logoutURLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logoutURLs(String... logoutURLs) {
            logoutURLs(Arrays.asList(logoutURLs));
            return this;
        }

        public final void setLogoutURLs(Collection<String> logoutURLs) {
            this.logoutURLs = LogoutURLsListTypeCopier.copy(logoutURLs);
        }

        public final String getDefaultRedirectURI() {
            return defaultRedirectURI;
        }

        @Override
        public final Builder defaultRedirectURI(String defaultRedirectURI) {
            this.defaultRedirectURI = defaultRedirectURI;
            return this;
        }

        public final void setDefaultRedirectURI(String defaultRedirectURI) {
            this.defaultRedirectURI = defaultRedirectURI;
        }

        public final Collection<String> getAllowedOAuthFlowsAsStrings() {
            return allowedOAuthFlows;
        }

        @Override
        public final Builder allowedOAuthFlowsWithStrings(Collection<String> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copy(allowedOAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthFlowsWithStrings(String... allowedOAuthFlows) {
            allowedOAuthFlowsWithStrings(Arrays.asList(allowedOAuthFlows));
            return this;
        }

        @Override
        public final Builder allowedOAuthFlows(Collection<OAuthFlowType> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copyEnumToString(allowedOAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthFlows(OAuthFlowType... allowedOAuthFlows) {
            allowedOAuthFlows(Arrays.asList(allowedOAuthFlows));
            return this;
        }

        public final void setAllowedOAuthFlowsWithStrings(Collection<String> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copy(allowedOAuthFlows);
        }

        public final Collection<String> getAllowedOAuthScopes() {
            return allowedOAuthScopes;
        }

        @Override
        public final Builder allowedOAuthScopes(Collection<String> allowedOAuthScopes) {
            this.allowedOAuthScopes = ScopeListTypeCopier.copy(allowedOAuthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthScopes(String... allowedOAuthScopes) {
            allowedOAuthScopes(Arrays.asList(allowedOAuthScopes));
            return this;
        }

        public final void setAllowedOAuthScopes(Collection<String> allowedOAuthScopes) {
            this.allowedOAuthScopes = ScopeListTypeCopier.copy(allowedOAuthScopes);
        }

        public final Boolean getAllowedOAuthFlowsUserPoolClient() {
            return allowedOAuthFlowsUserPoolClient;
        }

        @Override
        public final Builder allowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient) {
            this.allowedOAuthFlowsUserPoolClient = allowedOAuthFlowsUserPoolClient;
            return this;
        }

        public final void setAllowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient) {
            this.allowedOAuthFlowsUserPoolClient = allowedOAuthFlowsUserPoolClient;
        }

        public final AnalyticsConfigurationType.Builder getAnalyticsConfiguration() {
            return analyticsConfiguration != null ? analyticsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder analyticsConfiguration(AnalyticsConfigurationType analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration;
            return this;
        }

        public final void setAnalyticsConfiguration(AnalyticsConfigurationType.BuilderImpl analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration != null ? analyticsConfiguration.build() : null;
        }

        public final String getPreventUserExistenceErrorsAsString() {
            return preventUserExistenceErrors;
        }

        @Override
        public final Builder preventUserExistenceErrors(String preventUserExistenceErrors) {
            this.preventUserExistenceErrors = preventUserExistenceErrors;
            return this;
        }

        @Override
        public final Builder preventUserExistenceErrors(PreventUserExistenceErrorTypes preventUserExistenceErrors) {
            this.preventUserExistenceErrors(preventUserExistenceErrors == null ? null : preventUserExistenceErrors.toString());
            return this;
        }

        public final void setPreventUserExistenceErrors(String preventUserExistenceErrors) {
            this.preventUserExistenceErrors = preventUserExistenceErrors;
        }

        @Override
        public UserPoolClientType build() {
            return new UserPoolClientType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
