/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of the user pool client.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserPoolClientDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<UserPoolClientDescription.Builder, UserPoolClientDescription> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolClientDescription::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolClientDescription::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> CLIENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolClientDescription::clientName)).setter(setter(Builder::clientName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            USER_POOL_ID_FIELD, CLIENT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientId;

    private final String userPoolId;

    private final String clientName;

    private UserPoolClientDescription(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.userPoolId = builder.userPoolId;
        this.clientName = builder.clientName;
    }

    /**
     * <p>
     * The ID of the client associated with the user pool.
     * </p>
     * 
     * @return The ID of the client associated with the user pool.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The user pool ID for the user pool where you want to describe the user pool client.
     * </p>
     * 
     * @return The user pool ID for the user pool where you want to describe the user pool client.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The client name from the user pool client description.
     * </p>
     * 
     * @return The client name from the user pool client description.
     */
    public String clientName() {
        return clientName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(clientName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolClientDescription)) {
            return false;
        }
        UserPoolClientDescription other = (UserPoolClientDescription) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(userPoolId(), other.userPoolId())
                && Objects.equals(clientName(), other.clientName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UserPoolClientDescription")
                .add("ClientId", clientId() == null ? null : "*** Sensitive Data Redacted ***").add("UserPoolId", userPoolId())
                .add("ClientName", clientName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ClientName":
            return Optional.ofNullable(clazz.cast(clientName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserPoolClientDescription, T> g) {
        return obj -> g.apply((UserPoolClientDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserPoolClientDescription> {
        /**
         * <p>
         * The ID of the client associated with the user pool.
         * </p>
         * 
         * @param clientId
         *        The ID of the client associated with the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The user pool ID for the user pool where you want to describe the user pool client.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool where you want to describe the user pool client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The client name from the user pool client description.
         * </p>
         * 
         * @param clientName
         *        The client name from the user pool client description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientName(String clientName);
    }

    static final class BuilderImpl implements Builder {
        private String clientId;

        private String userPoolId;

        private String clientName;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPoolClientDescription model) {
            clientId(model.clientId);
            userPoolId(model.userPoolId);
            clientName(model.clientName);
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getClientName() {
            return clientName;
        }

        @Override
        public final Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public final void setClientName(String clientName) {
            this.clientName = clientName;
        }

        @Override
        public UserPoolClientDescription build() {
            return new UserPoolClientDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
