/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserPoolDomainResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<CreateUserPoolDomainResponse.Builder, CreateUserPoolDomainResponse> {
    private static final SdkField<String> CLOUD_FRONT_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserPoolDomainResponse::cloudFrontDomain)).setter(setter(Builder::cloudFrontDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontDomain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FRONT_DOMAIN_FIELD));

    private final String cloudFrontDomain;

    private CreateUserPoolDomainResponse(BuilderImpl builder) {
        super(builder);
        this.cloudFrontDomain = builder.cloudFrontDomain;
    }

    /**
     * <p>
     * The Amazon CloudFront endpoint that you use as the target of the alias that you set up with your Domain Name
     * Service (DNS) provider.
     * </p>
     * 
     * @return The Amazon CloudFront endpoint that you use as the target of the alias that you set up with your Domain
     *         Name Service (DNS) provider.
     */
    public String cloudFrontDomain() {
        return cloudFrontDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cloudFrontDomain());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserPoolDomainResponse)) {
            return false;
        }
        CreateUserPoolDomainResponse other = (CreateUserPoolDomainResponse) obj;
        return Objects.equals(cloudFrontDomain(), other.cloudFrontDomain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateUserPoolDomainResponse").add("CloudFrontDomain", cloudFrontDomain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFrontDomain":
            return Optional.ofNullable(clazz.cast(cloudFrontDomain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserPoolDomainResponse, T> g) {
        return obj -> g.apply((CreateUserPoolDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateUserPoolDomainResponse> {
        /**
         * <p>
         * The Amazon CloudFront endpoint that you use as the target of the alias that you set up with your Domain Name
         * Service (DNS) provider.
         * </p>
         * 
         * @param cloudFrontDomain
         *        The Amazon CloudFront endpoint that you use as the target of the alias that you set up with your
         *        Domain Name Service (DNS) provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontDomain(String cloudFrontDomain);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private String cloudFrontDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserPoolDomainResponse model) {
            super(model);
            cloudFrontDomain(model.cloudFrontDomain);
        }

        public final String getCloudFrontDomain() {
            return cloudFrontDomain;
        }

        @Override
        public final Builder cloudFrontDomain(String cloudFrontDomain) {
            this.cloudFrontDomain = cloudFrontDomain;
            return this;
        }

        public final void setCloudFrontDomain(String cloudFrontDomain) {
            this.cloudFrontDomain = cloudFrontDomain;
        }

        @Override
        public CreateUserPoolDomainResponse build() {
            return new CreateUserPoolDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
