/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to create a user pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserPoolRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<CreateUserPoolRequest.Builder, CreateUserPoolRequest> {
    private static final SdkField<String> POOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserPoolRequest::poolName)).setter(setter(Builder::poolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()).build();

    private static final SdkField<UserPoolPolicyType> POLICIES_FIELD = SdkField
            .<UserPoolPolicyType> builder(MarshallingType.SDK_POJO).getter(getter(CreateUserPoolRequest::policies))
            .setter(setter(Builder::policies)).constructor(UserPoolPolicyType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build()).build();

    private static final SdkField<LambdaConfigType> LAMBDA_CONFIG_FIELD = SdkField
            .<LambdaConfigType> builder(MarshallingType.SDK_POJO).getter(getter(CreateUserPoolRequest::lambdaConfig))
            .setter(setter(Builder::lambdaConfig)).constructor(LambdaConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaConfig").build()).build();

    private static final SdkField<List<String>> AUTO_VERIFIED_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateUserPoolRequest::autoVerifiedAttributesAsStrings))
            .setter(setter(Builder::autoVerifiedAttributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoVerifiedAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALIAS_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateUserPoolRequest::aliasAttributesAsStrings))
            .setter(setter(Builder::aliasAttributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USERNAME_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateUserPoolRequest::usernameAttributesAsStrings))
            .setter(setter(Builder::usernameAttributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernameAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SMS_VERIFICATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserPoolRequest::smsVerificationMessage)).setter(setter(Builder::smsVerificationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsVerificationMessage").build())
            .build();

    private static final SdkField<String> EMAIL_VERIFICATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserPoolRequest::emailVerificationMessage)).setter(setter(Builder::emailVerificationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailVerificationMessage").build())
            .build();

    private static final SdkField<String> EMAIL_VERIFICATION_SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserPoolRequest::emailVerificationSubject)).setter(setter(Builder::emailVerificationSubject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailVerificationSubject").build())
            .build();

    private static final SdkField<VerificationMessageTemplateType> VERIFICATION_MESSAGE_TEMPLATE_FIELD = SdkField
            .<VerificationMessageTemplateType> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateUserPoolRequest::verificationMessageTemplate))
            .setter(setter(Builder::verificationMessageTemplate))
            .constructor(VerificationMessageTemplateType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationMessageTemplate")
                    .build()).build();

    private static final SdkField<String> SMS_AUTHENTICATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserPoolRequest::smsAuthenticationMessage)).setter(setter(Builder::smsAuthenticationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsAuthenticationMessage").build())
            .build();

    private static final SdkField<String> MFA_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserPoolRequest::mfaConfigurationAsString)).setter(setter(Builder::mfaConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MfaConfiguration").build()).build();

    private static final SdkField<DeviceConfigurationType> DEVICE_CONFIGURATION_FIELD = SdkField
            .<DeviceConfigurationType> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateUserPoolRequest::deviceConfiguration)).setter(setter(Builder::deviceConfiguration))
            .constructor(DeviceConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceConfiguration").build())
            .build();

    private static final SdkField<EmailConfigurationType> EMAIL_CONFIGURATION_FIELD = SdkField
            .<EmailConfigurationType> builder(MarshallingType.SDK_POJO).getter(getter(CreateUserPoolRequest::emailConfiguration))
            .setter(setter(Builder::emailConfiguration)).constructor(EmailConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailConfiguration").build())
            .build();

    private static final SdkField<SmsConfigurationType> SMS_CONFIGURATION_FIELD = SdkField
            .<SmsConfigurationType> builder(MarshallingType.SDK_POJO).getter(getter(CreateUserPoolRequest::smsConfiguration))
            .setter(setter(Builder::smsConfiguration)).constructor(SmsConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsConfiguration").build()).build();

    private static final SdkField<Map<String, String>> USER_POOL_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateUserPoolRequest::userPoolTags))
            .setter(setter(Builder::userPoolTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AdminCreateUserConfigType> ADMIN_CREATE_USER_CONFIG_FIELD = SdkField
            .<AdminCreateUserConfigType> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateUserPoolRequest::adminCreateUserConfig)).setter(setter(Builder::adminCreateUserConfig))
            .constructor(AdminCreateUserConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminCreateUserConfig").build())
            .build();

    private static final SdkField<List<SchemaAttributeType>> SCHEMA_FIELD = SdkField
            .<List<SchemaAttributeType>> builder(MarshallingType.LIST)
            .getter(getter(CreateUserPoolRequest::schema))
            .setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaAttributeType> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaAttributeType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<UserPoolAddOnsType> USER_POOL_ADD_ONS_FIELD = SdkField
            .<UserPoolAddOnsType> builder(MarshallingType.SDK_POJO).getter(getter(CreateUserPoolRequest::userPoolAddOns))
            .setter(setter(Builder::userPoolAddOns)).constructor(UserPoolAddOnsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolAddOns").build()).build();

    private static final SdkField<UsernameConfigurationType> USERNAME_CONFIGURATION_FIELD = SdkField
            .<UsernameConfigurationType> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateUserPoolRequest::usernameConfiguration)).setter(setter(Builder::usernameConfiguration))
            .constructor(UsernameConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernameConfiguration").build())
            .build();

    private static final SdkField<AccountRecoverySettingType> ACCOUNT_RECOVERY_SETTING_FIELD = SdkField
            .<AccountRecoverySettingType> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateUserPoolRequest::accountRecoverySetting)).setter(setter(Builder::accountRecoverySetting))
            .constructor(AccountRecoverySettingType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountRecoverySetting").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_NAME_FIELD,
            POLICIES_FIELD, LAMBDA_CONFIG_FIELD, AUTO_VERIFIED_ATTRIBUTES_FIELD, ALIAS_ATTRIBUTES_FIELD,
            USERNAME_ATTRIBUTES_FIELD, SMS_VERIFICATION_MESSAGE_FIELD, EMAIL_VERIFICATION_MESSAGE_FIELD,
            EMAIL_VERIFICATION_SUBJECT_FIELD, VERIFICATION_MESSAGE_TEMPLATE_FIELD, SMS_AUTHENTICATION_MESSAGE_FIELD,
            MFA_CONFIGURATION_FIELD, DEVICE_CONFIGURATION_FIELD, EMAIL_CONFIGURATION_FIELD, SMS_CONFIGURATION_FIELD,
            USER_POOL_TAGS_FIELD, ADMIN_CREATE_USER_CONFIG_FIELD, SCHEMA_FIELD, USER_POOL_ADD_ONS_FIELD,
            USERNAME_CONFIGURATION_FIELD, ACCOUNT_RECOVERY_SETTING_FIELD));

    private final String poolName;

    private final UserPoolPolicyType policies;

    private final LambdaConfigType lambdaConfig;

    private final List<String> autoVerifiedAttributes;

    private final List<String> aliasAttributes;

    private final List<String> usernameAttributes;

    private final String smsVerificationMessage;

    private final String emailVerificationMessage;

    private final String emailVerificationSubject;

    private final VerificationMessageTemplateType verificationMessageTemplate;

    private final String smsAuthenticationMessage;

    private final String mfaConfiguration;

    private final DeviceConfigurationType deviceConfiguration;

    private final EmailConfigurationType emailConfiguration;

    private final SmsConfigurationType smsConfiguration;

    private final Map<String, String> userPoolTags;

    private final AdminCreateUserConfigType adminCreateUserConfig;

    private final List<SchemaAttributeType> schema;

    private final UserPoolAddOnsType userPoolAddOns;

    private final UsernameConfigurationType usernameConfiguration;

    private final AccountRecoverySettingType accountRecoverySetting;

    private CreateUserPoolRequest(BuilderImpl builder) {
        super(builder);
        this.poolName = builder.poolName;
        this.policies = builder.policies;
        this.lambdaConfig = builder.lambdaConfig;
        this.autoVerifiedAttributes = builder.autoVerifiedAttributes;
        this.aliasAttributes = builder.aliasAttributes;
        this.usernameAttributes = builder.usernameAttributes;
        this.smsVerificationMessage = builder.smsVerificationMessage;
        this.emailVerificationMessage = builder.emailVerificationMessage;
        this.emailVerificationSubject = builder.emailVerificationSubject;
        this.verificationMessageTemplate = builder.verificationMessageTemplate;
        this.smsAuthenticationMessage = builder.smsAuthenticationMessage;
        this.mfaConfiguration = builder.mfaConfiguration;
        this.deviceConfiguration = builder.deviceConfiguration;
        this.emailConfiguration = builder.emailConfiguration;
        this.smsConfiguration = builder.smsConfiguration;
        this.userPoolTags = builder.userPoolTags;
        this.adminCreateUserConfig = builder.adminCreateUserConfig;
        this.schema = builder.schema;
        this.userPoolAddOns = builder.userPoolAddOns;
        this.usernameConfiguration = builder.usernameConfiguration;
        this.accountRecoverySetting = builder.accountRecoverySetting;
    }

    /**
     * <p>
     * A string used to name the user pool.
     * </p>
     * 
     * @return A string used to name the user pool.
     */
    public String poolName() {
        return poolName;
    }

    /**
     * <p>
     * The policies associated with the new user pool.
     * </p>
     * 
     * @return The policies associated with the new user pool.
     */
    public UserPoolPolicyType policies() {
        return policies;
    }

    /**
     * <p>
     * The Lambda trigger configuration information for the new user pool.
     * </p>
     * <note>
     * <p>
     * In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function.
     * So you will need to make an extra call to add permission for these event sources to invoke your Lambda function.
     * </p>
     * <p/>
     * <p>
     * For more information on using the Lambda API to add permission, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html"> AddPermission </a>.
     * </p>
     * <p>
     * For adding permission using the AWS CLI, see <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html"> add-permission </a>.
     * </p>
     * </note>
     * 
     * @return The Lambda trigger configuration information for the new user pool.</p> <note>
     *         <p>
     *         In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a
     *         function. So you will need to make an extra call to add permission for these event sources to invoke your
     *         Lambda function.
     *         </p>
     *         <p/>
     *         <p>
     *         For more information on using the Lambda API to add permission, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html"> AddPermission </a>.
     *         </p>
     *         <p>
     *         For adding permission using the AWS CLI, see <a
     *         href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html"> add-permission </a>.
     *         </p>
     */
    public LambdaConfigType lambdaConfig() {
        return lambdaConfig;
    }

    /**
     * <p>
     * The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAutoVerifiedAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.
     */
    public List<VerifiedAttributeType> autoVerifiedAttributes() {
        return VerifiedAttributesListTypeCopier.copyStringToEnum(autoVerifiedAttributes);
    }

    /**
     * Returns true if the AutoVerifiedAttributes property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAutoVerifiedAttributes() {
        return autoVerifiedAttributes != null && !(autoVerifiedAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAutoVerifiedAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.
     */
    public List<String> autoVerifiedAttributesAsStrings() {
        return autoVerifiedAttributes;
    }

    /**
     * <p>
     * Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or
     * <b>preferred_username</b>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAliasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>,
     *         or <b>preferred_username</b>.
     */
    public List<AliasAttributeType> aliasAttributes() {
        return AliasAttributesListTypeCopier.copyStringToEnum(aliasAttributes);
    }

    /**
     * Returns true if the AliasAttributes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAliasAttributes() {
        return aliasAttributes != null && !(aliasAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or
     * <b>preferred_username</b>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAliasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>,
     *         or <b>preferred_username</b>.
     */
    public List<String> aliasAttributesAsStrings() {
        return aliasAttributes;
    }

    /**
     * <p>
     * Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUsernameAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
     */
    public List<UsernameAttributeType> usernameAttributes() {
        return UsernameAttributesListTypeCopier.copyStringToEnum(usernameAttributes);
    }

    /**
     * Returns true if the UsernameAttributes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasUsernameAttributes() {
        return usernameAttributes != null && !(usernameAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUsernameAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
     */
    public List<String> usernameAttributesAsStrings() {
        return usernameAttributes;
    }

    /**
     * <p>
     * A string representing the SMS verification message.
     * </p>
     * 
     * @return A string representing the SMS verification message.
     */
    public String smsVerificationMessage() {
        return smsVerificationMessage;
    }

    /**
     * <p>
     * A string representing the email verification message.
     * </p>
     * 
     * @return A string representing the email verification message.
     */
    public String emailVerificationMessage() {
        return emailVerificationMessage;
    }

    /**
     * <p>
     * A string representing the email verification subject.
     * </p>
     * 
     * @return A string representing the email verification subject.
     */
    public String emailVerificationSubject() {
        return emailVerificationSubject;
    }

    /**
     * <p>
     * The template for the verification message that the user sees when the app requests permission to access the
     * user's information.
     * </p>
     * 
     * @return The template for the verification message that the user sees when the app requests permission to access
     *         the user's information.
     */
    public VerificationMessageTemplateType verificationMessageTemplate() {
        return verificationMessageTemplate;
    }

    /**
     * <p>
     * A string representing the SMS authentication message.
     * </p>
     * 
     * @return A string representing the SMS authentication message.
     */
    public String smsAuthenticationMessage() {
        return smsAuthenticationMessage;
    }

    /**
     * <p>
     * Specifies MFA configuration details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaConfiguration}
     * will return {@link UserPoolMfaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mfaConfigurationAsString}.
     * </p>
     * 
     * @return Specifies MFA configuration details.
     * @see UserPoolMfaType
     */
    public UserPoolMfaType mfaConfiguration() {
        return UserPoolMfaType.fromValue(mfaConfiguration);
    }

    /**
     * <p>
     * Specifies MFA configuration details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaConfiguration}
     * will return {@link UserPoolMfaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mfaConfigurationAsString}.
     * </p>
     * 
     * @return Specifies MFA configuration details.
     * @see UserPoolMfaType
     */
    public String mfaConfigurationAsString() {
        return mfaConfiguration;
    }

    /**
     * <p>
     * The device configuration.
     * </p>
     * 
     * @return The device configuration.
     */
    public DeviceConfigurationType deviceConfiguration() {
        return deviceConfiguration;
    }

    /**
     * <p>
     * The email configuration.
     * </p>
     * 
     * @return The email configuration.
     */
    public EmailConfigurationType emailConfiguration() {
        return emailConfiguration;
    }

    /**
     * <p>
     * The SMS configuration.
     * </p>
     * 
     * @return The SMS configuration.
     */
    public SmsConfigurationType smsConfiguration() {
        return smsConfiguration;
    }

    /**
     * Returns true if the UserPoolTags property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUserPoolTags() {
        return userPoolTags != null && !(userPoolTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage
     * user pools in different ways, such as by purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserPoolTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and
     *         manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
     */
    public Map<String, String> userPoolTags() {
        return userPoolTags;
    }

    /**
     * <p>
     * The configuration for <code>AdminCreateUser</code> requests.
     * </p>
     * 
     * @return The configuration for <code>AdminCreateUser</code> requests.
     */
    public AdminCreateUserConfigType adminCreateUserConfig() {
        return adminCreateUserConfig;
    }

    /**
     * Returns true if the Schema property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSchema() {
        return schema != null && !(schema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of schema attributes for the new user pool. These attributes can be standard or custom attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSchema()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of schema attributes for the new user pool. These attributes can be standard or custom
     *         attributes.
     */
    public List<SchemaAttributeType> schema() {
        return schema;
    }

    /**
     * <p>
     * Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value
     * "AUDIT".
     * </p>
     * 
     * @return Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the
     *         value "AUDIT".
     */
    public UserPoolAddOnsType userPoolAddOns() {
        return userPoolAddOns;
    }

    /**
     * <p>
     * You can choose to set case sensitivity on the username input for the selected sign-in option. For example, when
     * this is set to <code>False</code>, users will be able to sign in using either "username" or "Username". This
     * configuration is immutable once it has been set. For more information, see .
     * </p>
     * 
     * @return You can choose to set case sensitivity on the username input for the selected sign-in option. For
     *         example, when this is set to <code>False</code>, users will be able to sign in using either "username" or
     *         "Username". This configuration is immutable once it has been set. For more information, see .
     */
    public UsernameConfigurationType usernameConfiguration() {
        return usernameConfiguration;
    }

    /**
     * <p>
     * Use this setting to define which verified available method a user can use to recover their password when they
     * call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has more than one method
     * available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has
     * SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery
     * method where SMS is preferred over email.
     * </p>
     * <note>
     * <p>
     * Starting February 1, 2020, the value of <code>AccountRecoverySetting</code> will default to
     * <code>verified_email</code> first and <code>verified_phone_number</code> as the second option for newly created
     * user pools if no value is provided.
     * </p>
     * </note>
     * 
     * @return Use this setting to define which verified available method a user can use to recover their password when
     *         they call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has more
     *         than one method available. With this setting, SMS does not qualify for a valid password recovery
     *         mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy
     *         behavior to determine the recovery method where SMS is preferred over email.</p> <note>
     *         <p>
     *         Starting February 1, 2020, the value of <code>AccountRecoverySetting</code> will default to
     *         <code>verified_email</code> first and <code>verified_phone_number</code> as the second option for newly
     *         created user pools if no value is provided.
     *         </p>
     */
    public AccountRecoverySettingType accountRecoverySetting() {
        return accountRecoverySetting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(poolName());
        hashCode = 31 * hashCode + Objects.hashCode(policies());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(autoVerifiedAttributesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(aliasAttributesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(usernameAttributesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(smsVerificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailVerificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailVerificationSubject());
        hashCode = 31 * hashCode + Objects.hashCode(verificationMessageTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(smsAuthenticationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(mfaConfigurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(emailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(smsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolTags());
        hashCode = 31 * hashCode + Objects.hashCode(adminCreateUserConfig());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolAddOns());
        hashCode = 31 * hashCode + Objects.hashCode(usernameConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(accountRecoverySetting());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserPoolRequest)) {
            return false;
        }
        CreateUserPoolRequest other = (CreateUserPoolRequest) obj;
        return Objects.equals(poolName(), other.poolName()) && Objects.equals(policies(), other.policies())
                && Objects.equals(lambdaConfig(), other.lambdaConfig())
                && Objects.equals(autoVerifiedAttributesAsStrings(), other.autoVerifiedAttributesAsStrings())
                && Objects.equals(aliasAttributesAsStrings(), other.aliasAttributesAsStrings())
                && Objects.equals(usernameAttributesAsStrings(), other.usernameAttributesAsStrings())
                && Objects.equals(smsVerificationMessage(), other.smsVerificationMessage())
                && Objects.equals(emailVerificationMessage(), other.emailVerificationMessage())
                && Objects.equals(emailVerificationSubject(), other.emailVerificationSubject())
                && Objects.equals(verificationMessageTemplate(), other.verificationMessageTemplate())
                && Objects.equals(smsAuthenticationMessage(), other.smsAuthenticationMessage())
                && Objects.equals(mfaConfigurationAsString(), other.mfaConfigurationAsString())
                && Objects.equals(deviceConfiguration(), other.deviceConfiguration())
                && Objects.equals(emailConfiguration(), other.emailConfiguration())
                && Objects.equals(smsConfiguration(), other.smsConfiguration())
                && Objects.equals(userPoolTags(), other.userPoolTags())
                && Objects.equals(adminCreateUserConfig(), other.adminCreateUserConfig())
                && Objects.equals(schema(), other.schema()) && Objects.equals(userPoolAddOns(), other.userPoolAddOns())
                && Objects.equals(usernameConfiguration(), other.usernameConfiguration())
                && Objects.equals(accountRecoverySetting(), other.accountRecoverySetting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateUserPoolRequest").add("PoolName", poolName()).add("Policies", policies())
                .add("LambdaConfig", lambdaConfig()).add("AutoVerifiedAttributes", autoVerifiedAttributesAsStrings())
                .add("AliasAttributes", aliasAttributesAsStrings()).add("UsernameAttributes", usernameAttributesAsStrings())
                .add("SmsVerificationMessage", smsVerificationMessage())
                .add("EmailVerificationMessage", emailVerificationMessage())
                .add("EmailVerificationSubject", emailVerificationSubject())
                .add("VerificationMessageTemplate", verificationMessageTemplate())
                .add("SmsAuthenticationMessage", smsAuthenticationMessage()).add("MfaConfiguration", mfaConfigurationAsString())
                .add("DeviceConfiguration", deviceConfiguration()).add("EmailConfiguration", emailConfiguration())
                .add("SmsConfiguration", smsConfiguration()).add("UserPoolTags", userPoolTags())
                .add("AdminCreateUserConfig", adminCreateUserConfig()).add("Schema", schema())
                .add("UserPoolAddOns", userPoolAddOns()).add("UsernameConfiguration", usernameConfiguration())
                .add("AccountRecoverySetting", accountRecoverySetting()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolName":
            return Optional.ofNullable(clazz.cast(poolName()));
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        case "LambdaConfig":
            return Optional.ofNullable(clazz.cast(lambdaConfig()));
        case "AutoVerifiedAttributes":
            return Optional.ofNullable(clazz.cast(autoVerifiedAttributesAsStrings()));
        case "AliasAttributes":
            return Optional.ofNullable(clazz.cast(aliasAttributesAsStrings()));
        case "UsernameAttributes":
            return Optional.ofNullable(clazz.cast(usernameAttributesAsStrings()));
        case "SmsVerificationMessage":
            return Optional.ofNullable(clazz.cast(smsVerificationMessage()));
        case "EmailVerificationMessage":
            return Optional.ofNullable(clazz.cast(emailVerificationMessage()));
        case "EmailVerificationSubject":
            return Optional.ofNullable(clazz.cast(emailVerificationSubject()));
        case "VerificationMessageTemplate":
            return Optional.ofNullable(clazz.cast(verificationMessageTemplate()));
        case "SmsAuthenticationMessage":
            return Optional.ofNullable(clazz.cast(smsAuthenticationMessage()));
        case "MfaConfiguration":
            return Optional.ofNullable(clazz.cast(mfaConfigurationAsString()));
        case "DeviceConfiguration":
            return Optional.ofNullable(clazz.cast(deviceConfiguration()));
        case "EmailConfiguration":
            return Optional.ofNullable(clazz.cast(emailConfiguration()));
        case "SmsConfiguration":
            return Optional.ofNullable(clazz.cast(smsConfiguration()));
        case "UserPoolTags":
            return Optional.ofNullable(clazz.cast(userPoolTags()));
        case "AdminCreateUserConfig":
            return Optional.ofNullable(clazz.cast(adminCreateUserConfig()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "UserPoolAddOns":
            return Optional.ofNullable(clazz.cast(userPoolAddOns()));
        case "UsernameConfiguration":
            return Optional.ofNullable(clazz.cast(usernameConfiguration()));
        case "AccountRecoverySetting":
            return Optional.ofNullable(clazz.cast(accountRecoverySetting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserPoolRequest, T> g) {
        return obj -> g.apply((CreateUserPoolRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateUserPoolRequest> {
        /**
         * <p>
         * A string used to name the user pool.
         * </p>
         * 
         * @param poolName
         *        A string used to name the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolName(String poolName);

        /**
         * <p>
         * The policies associated with the new user pool.
         * </p>
         * 
         * @param policies
         *        The policies associated with the new user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(UserPoolPolicyType policies);

        /**
         * <p>
         * The policies associated with the new user pool.
         * </p>
         * This is a convenience that creates an instance of the {@link UserPoolPolicyType.Builder} avoiding the need to
         * create one manually via {@link UserPoolPolicyType#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPoolPolicyType.Builder#build()} is called immediately and its
         * result is passed to {@link #policies(UserPoolPolicyType)}.
         * 
         * @param policies
         *        a consumer that will call methods on {@link UserPoolPolicyType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(UserPoolPolicyType)
         */
        default Builder policies(Consumer<UserPoolPolicyType.Builder> policies) {
            return policies(UserPoolPolicyType.builder().applyMutation(policies).build());
        }

        /**
         * <p>
         * The Lambda trigger configuration information for the new user pool.
         * </p>
         * <note>
         * <p>
         * In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a
         * function. So you will need to make an extra call to add permission for these event sources to invoke your
         * Lambda function.
         * </p>
         * <p/>
         * <p>
         * For more information on using the Lambda API to add permission, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html"> AddPermission </a>.
         * </p>
         * <p>
         * For adding permission using the AWS CLI, see <a
         * href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html"> add-permission </a>.
         * </p>
         * </note>
         * 
         * @param lambdaConfig
         *        The Lambda trigger configuration information for the new user pool.</p> <note>
         *        <p>
         *        In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a
         *        function. So you will need to make an extra call to add permission for these event sources to invoke
         *        your Lambda function.
         *        </p>
         *        <p/>
         *        <p>
         *        For more information on using the Lambda API to add permission, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html"> AddPermission </a>.
         *        </p>
         *        <p>
         *        For adding permission using the AWS CLI, see <a
         *        href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html"> add-permission
         *        </a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaConfig(LambdaConfigType lambdaConfig);

        /**
         * <p>
         * The Lambda trigger configuration information for the new user pool.
         * </p>
         * <note>
         * <p>
         * In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a
         * function. So you will need to make an extra call to add permission for these event sources to invoke your
         * Lambda function.
         * </p>
         * <p/>
         * <p>
         * For more information on using the Lambda API to add permission, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html"> AddPermission </a>.
         * </p>
         * <p>
         * For adding permission using the AWS CLI, see <a
         * href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html"> add-permission </a>.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link LambdaConfigType.Builder} avoiding the
         * need to create one manually via {@link LambdaConfigType#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaConfigType.Builder#build()} is called immediately and its
         * result is passed to {@link #lambdaConfig(LambdaConfigType)}.
         * 
         * @param lambdaConfig
         *        a consumer that will call methods on {@link LambdaConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaConfig(LambdaConfigType)
         */
        default Builder lambdaConfig(Consumer<LambdaConfigType.Builder> lambdaConfig) {
            return lambdaConfig(LambdaConfigType.builder().applyMutation(lambdaConfig).build());
        }

        /**
         * <p>
         * The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributesWithStrings(Collection<String> autoVerifiedAttributes);

        /**
         * <p>
         * The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributesWithStrings(String... autoVerifiedAttributes);

        /**
         * <p>
         * The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributes(Collection<VerifiedAttributeType> autoVerifiedAttributes);

        /**
         * <p>
         * The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributes(VerifiedAttributeType... autoVerifiedAttributes);

        /**
         * <p>
         * Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or
         * <b>preferred_username</b>.
         * </p>
         * 
         * @param aliasAttributes
         *        Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>,
         *        <b>email</b>, or <b>preferred_username</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasAttributesWithStrings(Collection<String> aliasAttributes);

        /**
         * <p>
         * Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or
         * <b>preferred_username</b>.
         * </p>
         * 
         * @param aliasAttributes
         *        Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>,
         *        <b>email</b>, or <b>preferred_username</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasAttributesWithStrings(String... aliasAttributes);

        /**
         * <p>
         * Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or
         * <b>preferred_username</b>.
         * </p>
         * 
         * @param aliasAttributes
         *        Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>,
         *        <b>email</b>, or <b>preferred_username</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasAttributes(Collection<AliasAttributeType> aliasAttributes);

        /**
         * <p>
         * Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or
         * <b>preferred_username</b>.
         * </p>
         * 
         * @param aliasAttributes
         *        Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>,
         *        <b>email</b>, or <b>preferred_username</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasAttributes(AliasAttributeType... aliasAttributes);

        /**
         * <p>
         * Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * </p>
         * 
         * @param usernameAttributes
         *        Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameAttributesWithStrings(Collection<String> usernameAttributes);

        /**
         * <p>
         * Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * </p>
         * 
         * @param usernameAttributes
         *        Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameAttributesWithStrings(String... usernameAttributes);

        /**
         * <p>
         * Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * </p>
         * 
         * @param usernameAttributes
         *        Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameAttributes(Collection<UsernameAttributeType> usernameAttributes);

        /**
         * <p>
         * Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * </p>
         * 
         * @param usernameAttributes
         *        Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameAttributes(UsernameAttributeType... usernameAttributes);

        /**
         * <p>
         * A string representing the SMS verification message.
         * </p>
         * 
         * @param smsVerificationMessage
         *        A string representing the SMS verification message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsVerificationMessage(String smsVerificationMessage);

        /**
         * <p>
         * A string representing the email verification message.
         * </p>
         * 
         * @param emailVerificationMessage
         *        A string representing the email verification message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailVerificationMessage(String emailVerificationMessage);

        /**
         * <p>
         * A string representing the email verification subject.
         * </p>
         * 
         * @param emailVerificationSubject
         *        A string representing the email verification subject.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailVerificationSubject(String emailVerificationSubject);

        /**
         * <p>
         * The template for the verification message that the user sees when the app requests permission to access the
         * user's information.
         * </p>
         * 
         * @param verificationMessageTemplate
         *        The template for the verification message that the user sees when the app requests permission to
         *        access the user's information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationMessageTemplate(VerificationMessageTemplateType verificationMessageTemplate);

        /**
         * <p>
         * The template for the verification message that the user sees when the app requests permission to access the
         * user's information.
         * </p>
         * This is a convenience that creates an instance of the {@link VerificationMessageTemplateType.Builder}
         * avoiding the need to create one manually via {@link VerificationMessageTemplateType#builder()}.
         *
         * When the {@link Consumer} completes, {@link VerificationMessageTemplateType.Builder#build()} is called
         * immediately and its result is passed to {@link #verificationMessageTemplate(VerificationMessageTemplateType)}
         * .
         * 
         * @param verificationMessageTemplate
         *        a consumer that will call methods on {@link VerificationMessageTemplateType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verificationMessageTemplate(VerificationMessageTemplateType)
         */
        default Builder verificationMessageTemplate(Consumer<VerificationMessageTemplateType.Builder> verificationMessageTemplate) {
            return verificationMessageTemplate(VerificationMessageTemplateType.builder()
                    .applyMutation(verificationMessageTemplate).build());
        }

        /**
         * <p>
         * A string representing the SMS authentication message.
         * </p>
         * 
         * @param smsAuthenticationMessage
         *        A string representing the SMS authentication message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsAuthenticationMessage(String smsAuthenticationMessage);

        /**
         * <p>
         * Specifies MFA configuration details.
         * </p>
         * 
         * @param mfaConfiguration
         *        Specifies MFA configuration details.
         * @see UserPoolMfaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserPoolMfaType
         */
        Builder mfaConfiguration(String mfaConfiguration);

        /**
         * <p>
         * Specifies MFA configuration details.
         * </p>
         * 
         * @param mfaConfiguration
         *        Specifies MFA configuration details.
         * @see UserPoolMfaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserPoolMfaType
         */
        Builder mfaConfiguration(UserPoolMfaType mfaConfiguration);

        /**
         * <p>
         * The device configuration.
         * </p>
         * 
         * @param deviceConfiguration
         *        The device configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceConfiguration(DeviceConfigurationType deviceConfiguration);

        /**
         * <p>
         * The device configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link DeviceConfigurationType.Builder} avoiding the
         * need to create one manually via {@link DeviceConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceConfigurationType.Builder#build()} is called immediately
         * and its result is passed to {@link #deviceConfiguration(DeviceConfigurationType)}.
         * 
         * @param deviceConfiguration
         *        a consumer that will call methods on {@link DeviceConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceConfiguration(DeviceConfigurationType)
         */
        default Builder deviceConfiguration(Consumer<DeviceConfigurationType.Builder> deviceConfiguration) {
            return deviceConfiguration(DeviceConfigurationType.builder().applyMutation(deviceConfiguration).build());
        }

        /**
         * <p>
         * The email configuration.
         * </p>
         * 
         * @param emailConfiguration
         *        The email configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailConfiguration(EmailConfigurationType emailConfiguration);

        /**
         * <p>
         * The email configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link EmailConfigurationType.Builder} avoiding the
         * need to create one manually via {@link EmailConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link EmailConfigurationType.Builder#build()} is called immediately and
         * its result is passed to {@link #emailConfiguration(EmailConfigurationType)}.
         * 
         * @param emailConfiguration
         *        a consumer that will call methods on {@link EmailConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailConfiguration(EmailConfigurationType)
         */
        default Builder emailConfiguration(Consumer<EmailConfigurationType.Builder> emailConfiguration) {
            return emailConfiguration(EmailConfigurationType.builder().applyMutation(emailConfiguration).build());
        }

        /**
         * <p>
         * The SMS configuration.
         * </p>
         * 
         * @param smsConfiguration
         *        The SMS configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsConfiguration(SmsConfigurationType smsConfiguration);

        /**
         * <p>
         * The SMS configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link SmsConfigurationType.Builder} avoiding the need
         * to create one manually via {@link SmsConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link SmsConfigurationType.Builder#build()} is called immediately and
         * its result is passed to {@link #smsConfiguration(SmsConfigurationType)}.
         * 
         * @param smsConfiguration
         *        a consumer that will call methods on {@link SmsConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsConfiguration(SmsConfigurationType)
         */
        default Builder smsConfiguration(Consumer<SmsConfigurationType.Builder> smsConfiguration) {
            return smsConfiguration(SmsConfigurationType.builder().applyMutation(smsConfiguration).build());
        }

        /**
         * <p>
         * The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and
         * manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
         * </p>
         * 
         * @param userPoolTags
         *        The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize
         *        and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolTags(Map<String, String> userPoolTags);

        /**
         * <p>
         * The configuration for <code>AdminCreateUser</code> requests.
         * </p>
         * 
         * @param adminCreateUserConfig
         *        The configuration for <code>AdminCreateUser</code> requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminCreateUserConfig(AdminCreateUserConfigType adminCreateUserConfig);

        /**
         * <p>
         * The configuration for <code>AdminCreateUser</code> requests.
         * </p>
         * This is a convenience that creates an instance of the {@link AdminCreateUserConfigType.Builder} avoiding the
         * need to create one manually via {@link AdminCreateUserConfigType#builder()}.
         *
         * When the {@link Consumer} completes, {@link AdminCreateUserConfigType.Builder#build()} is called immediately
         * and its result is passed to {@link #adminCreateUserConfig(AdminCreateUserConfigType)}.
         * 
         * @param adminCreateUserConfig
         *        a consumer that will call methods on {@link AdminCreateUserConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adminCreateUserConfig(AdminCreateUserConfigType)
         */
        default Builder adminCreateUserConfig(Consumer<AdminCreateUserConfigType.Builder> adminCreateUserConfig) {
            return adminCreateUserConfig(AdminCreateUserConfigType.builder().applyMutation(adminCreateUserConfig).build());
        }

        /**
         * <p>
         * An array of schema attributes for the new user pool. These attributes can be standard or custom attributes.
         * </p>
         * 
         * @param schema
         *        An array of schema attributes for the new user pool. These attributes can be standard or custom
         *        attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Collection<SchemaAttributeType> schema);

        /**
         * <p>
         * An array of schema attributes for the new user pool. These attributes can be standard or custom attributes.
         * </p>
         * 
         * @param schema
         *        An array of schema attributes for the new user pool. These attributes can be standard or custom
         *        attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(SchemaAttributeType... schema);

        /**
         * <p>
         * An array of schema attributes for the new user pool. These attributes can be standard or custom attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SchemaAttributeType>.Builder} avoiding the
         * need to create one manually via {@link List<SchemaAttributeType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SchemaAttributeType>.Builder#build()} is called immediately
         * and its result is passed to {@link #schema(List<SchemaAttributeType>)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link List<SchemaAttributeType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(List<SchemaAttributeType>)
         */
        Builder schema(Consumer<SchemaAttributeType.Builder>... schema);

        /**
         * <p>
         * Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value
         * "AUDIT".
         * </p>
         * 
         * @param userPoolAddOns
         *        Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the
         *        value "AUDIT".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolAddOns(UserPoolAddOnsType userPoolAddOns);

        /**
         * <p>
         * Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value
         * "AUDIT".
         * </p>
         * This is a convenience that creates an instance of the {@link UserPoolAddOnsType.Builder} avoiding the need to
         * create one manually via {@link UserPoolAddOnsType#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPoolAddOnsType.Builder#build()} is called immediately and its
         * result is passed to {@link #userPoolAddOns(UserPoolAddOnsType)}.
         * 
         * @param userPoolAddOns
         *        a consumer that will call methods on {@link UserPoolAddOnsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPoolAddOns(UserPoolAddOnsType)
         */
        default Builder userPoolAddOns(Consumer<UserPoolAddOnsType.Builder> userPoolAddOns) {
            return userPoolAddOns(UserPoolAddOnsType.builder().applyMutation(userPoolAddOns).build());
        }

        /**
         * <p>
         * You can choose to set case sensitivity on the username input for the selected sign-in option. For example,
         * when this is set to <code>False</code>, users will be able to sign in using either "username" or "Username".
         * This configuration is immutable once it has been set. For more information, see .
         * </p>
         * 
         * @param usernameConfiguration
         *        You can choose to set case sensitivity on the username input for the selected sign-in option. For
         *        example, when this is set to <code>False</code>, users will be able to sign in using either "username"
         *        or "Username". This configuration is immutable once it has been set. For more information, see .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameConfiguration(UsernameConfigurationType usernameConfiguration);

        /**
         * <p>
         * You can choose to set case sensitivity on the username input for the selected sign-in option. For example,
         * when this is set to <code>False</code>, users will be able to sign in using either "username" or "Username".
         * This configuration is immutable once it has been set. For more information, see .
         * </p>
         * This is a convenience that creates an instance of the {@link UsernameConfigurationType.Builder} avoiding the
         * need to create one manually via {@link UsernameConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link UsernameConfigurationType.Builder#build()} is called immediately
         * and its result is passed to {@link #usernameConfiguration(UsernameConfigurationType)}.
         * 
         * @param usernameConfiguration
         *        a consumer that will call methods on {@link UsernameConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usernameConfiguration(UsernameConfigurationType)
         */
        default Builder usernameConfiguration(Consumer<UsernameConfigurationType.Builder> usernameConfiguration) {
            return usernameConfiguration(UsernameConfigurationType.builder().applyMutation(usernameConfiguration).build());
        }

        /**
         * <p>
         * Use this setting to define which verified available method a user can use to recover their password when they
         * call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has more than one
         * method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user
         * also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the
         * recovery method where SMS is preferred over email.
         * </p>
         * <note>
         * <p>
         * Starting February 1, 2020, the value of <code>AccountRecoverySetting</code> will default to
         * <code>verified_email</code> first and <code>verified_phone_number</code> as the second option for newly
         * created user pools if no value is provided.
         * </p>
         * </note>
         * 
         * @param accountRecoverySetting
         *        Use this setting to define which verified available method a user can use to recover their password
         *        when they call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has
         *        more than one method available. With this setting, SMS does not qualify for a valid password recovery
         *        mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the
         *        legacy behavior to determine the recovery method where SMS is preferred over email.</p> <note>
         *        <p>
         *        Starting February 1, 2020, the value of <code>AccountRecoverySetting</code> will default to
         *        <code>verified_email</code> first and <code>verified_phone_number</code> as the second option for
         *        newly created user pools if no value is provided.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountRecoverySetting(AccountRecoverySettingType accountRecoverySetting);

        /**
         * <p>
         * Use this setting to define which verified available method a user can use to recover their password when they
         * call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has more than one
         * method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user
         * also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the
         * recovery method where SMS is preferred over email.
         * </p>
         * <note>
         * <p>
         * Starting February 1, 2020, the value of <code>AccountRecoverySetting</code> will default to
         * <code>verified_email</code> first and <code>verified_phone_number</code> as the second option for newly
         * created user pools if no value is provided.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link AccountRecoverySettingType.Builder}
         * avoiding the need to create one manually via {@link AccountRecoverySettingType#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccountRecoverySettingType.Builder#build()} is called immediately
         * and its result is passed to {@link #accountRecoverySetting(AccountRecoverySettingType)}.
         * 
         * @param accountRecoverySetting
         *        a consumer that will call methods on {@link AccountRecoverySettingType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountRecoverySetting(AccountRecoverySettingType)
         */
        default Builder accountRecoverySetting(Consumer<AccountRecoverySettingType.Builder> accountRecoverySetting) {
            return accountRecoverySetting(AccountRecoverySettingType.builder().applyMutation(accountRecoverySetting).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String poolName;

        private UserPoolPolicyType policies;

        private LambdaConfigType lambdaConfig;

        private List<String> autoVerifiedAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> aliasAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> usernameAttributes = DefaultSdkAutoConstructList.getInstance();

        private String smsVerificationMessage;

        private String emailVerificationMessage;

        private String emailVerificationSubject;

        private VerificationMessageTemplateType verificationMessageTemplate;

        private String smsAuthenticationMessage;

        private String mfaConfiguration;

        private DeviceConfigurationType deviceConfiguration;

        private EmailConfigurationType emailConfiguration;

        private SmsConfigurationType smsConfiguration;

        private Map<String, String> userPoolTags = DefaultSdkAutoConstructMap.getInstance();

        private AdminCreateUserConfigType adminCreateUserConfig;

        private List<SchemaAttributeType> schema = DefaultSdkAutoConstructList.getInstance();

        private UserPoolAddOnsType userPoolAddOns;

        private UsernameConfigurationType usernameConfiguration;

        private AccountRecoverySettingType accountRecoverySetting;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserPoolRequest model) {
            super(model);
            poolName(model.poolName);
            policies(model.policies);
            lambdaConfig(model.lambdaConfig);
            autoVerifiedAttributesWithStrings(model.autoVerifiedAttributes);
            aliasAttributesWithStrings(model.aliasAttributes);
            usernameAttributesWithStrings(model.usernameAttributes);
            smsVerificationMessage(model.smsVerificationMessage);
            emailVerificationMessage(model.emailVerificationMessage);
            emailVerificationSubject(model.emailVerificationSubject);
            verificationMessageTemplate(model.verificationMessageTemplate);
            smsAuthenticationMessage(model.smsAuthenticationMessage);
            mfaConfiguration(model.mfaConfiguration);
            deviceConfiguration(model.deviceConfiguration);
            emailConfiguration(model.emailConfiguration);
            smsConfiguration(model.smsConfiguration);
            userPoolTags(model.userPoolTags);
            adminCreateUserConfig(model.adminCreateUserConfig);
            schema(model.schema);
            userPoolAddOns(model.userPoolAddOns);
            usernameConfiguration(model.usernameConfiguration);
            accountRecoverySetting(model.accountRecoverySetting);
        }

        public final String getPoolName() {
            return poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        public final UserPoolPolicyType.Builder getPolicies() {
            return policies != null ? policies.toBuilder() : null;
        }

        @Override
        public final Builder policies(UserPoolPolicyType policies) {
            this.policies = policies;
            return this;
        }

        public final void setPolicies(UserPoolPolicyType.BuilderImpl policies) {
            this.policies = policies != null ? policies.build() : null;
        }

        public final LambdaConfigType.Builder getLambdaConfig() {
            return lambdaConfig != null ? lambdaConfig.toBuilder() : null;
        }

        @Override
        public final Builder lambdaConfig(LambdaConfigType lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        public final void setLambdaConfig(LambdaConfigType.BuilderImpl lambdaConfig) {
            this.lambdaConfig = lambdaConfig != null ? lambdaConfig.build() : null;
        }

        public final Collection<String> getAutoVerifiedAttributesAsStrings() {
            return autoVerifiedAttributes;
        }

        @Override
        public final Builder autoVerifiedAttributesWithStrings(Collection<String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copy(autoVerifiedAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoVerifiedAttributesWithStrings(String... autoVerifiedAttributes) {
            autoVerifiedAttributesWithStrings(Arrays.asList(autoVerifiedAttributes));
            return this;
        }

        @Override
        public final Builder autoVerifiedAttributes(Collection<VerifiedAttributeType> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copyEnumToString(autoVerifiedAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoVerifiedAttributes(VerifiedAttributeType... autoVerifiedAttributes) {
            autoVerifiedAttributes(Arrays.asList(autoVerifiedAttributes));
            return this;
        }

        public final void setAutoVerifiedAttributesWithStrings(Collection<String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copy(autoVerifiedAttributes);
        }

        public final Collection<String> getAliasAttributesAsStrings() {
            return aliasAttributes;
        }

        @Override
        public final Builder aliasAttributesWithStrings(Collection<String> aliasAttributes) {
            this.aliasAttributes = AliasAttributesListTypeCopier.copy(aliasAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasAttributesWithStrings(String... aliasAttributes) {
            aliasAttributesWithStrings(Arrays.asList(aliasAttributes));
            return this;
        }

        @Override
        public final Builder aliasAttributes(Collection<AliasAttributeType> aliasAttributes) {
            this.aliasAttributes = AliasAttributesListTypeCopier.copyEnumToString(aliasAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasAttributes(AliasAttributeType... aliasAttributes) {
            aliasAttributes(Arrays.asList(aliasAttributes));
            return this;
        }

        public final void setAliasAttributesWithStrings(Collection<String> aliasAttributes) {
            this.aliasAttributes = AliasAttributesListTypeCopier.copy(aliasAttributes);
        }

        public final Collection<String> getUsernameAttributesAsStrings() {
            return usernameAttributes;
        }

        @Override
        public final Builder usernameAttributesWithStrings(Collection<String> usernameAttributes) {
            this.usernameAttributes = UsernameAttributesListTypeCopier.copy(usernameAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usernameAttributesWithStrings(String... usernameAttributes) {
            usernameAttributesWithStrings(Arrays.asList(usernameAttributes));
            return this;
        }

        @Override
        public final Builder usernameAttributes(Collection<UsernameAttributeType> usernameAttributes) {
            this.usernameAttributes = UsernameAttributesListTypeCopier.copyEnumToString(usernameAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usernameAttributes(UsernameAttributeType... usernameAttributes) {
            usernameAttributes(Arrays.asList(usernameAttributes));
            return this;
        }

        public final void setUsernameAttributesWithStrings(Collection<String> usernameAttributes) {
            this.usernameAttributes = UsernameAttributesListTypeCopier.copy(usernameAttributes);
        }

        public final String getSmsVerificationMessage() {
            return smsVerificationMessage;
        }

        @Override
        public final Builder smsVerificationMessage(String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
            return this;
        }

        public final void setSmsVerificationMessage(String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
        }

        public final String getEmailVerificationMessage() {
            return emailVerificationMessage;
        }

        @Override
        public final Builder emailVerificationMessage(String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
            return this;
        }

        public final void setEmailVerificationMessage(String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
        }

        public final String getEmailVerificationSubject() {
            return emailVerificationSubject;
        }

        @Override
        public final Builder emailVerificationSubject(String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
            return this;
        }

        public final void setEmailVerificationSubject(String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
        }

        public final VerificationMessageTemplateType.Builder getVerificationMessageTemplate() {
            return verificationMessageTemplate != null ? verificationMessageTemplate.toBuilder() : null;
        }

        @Override
        public final Builder verificationMessageTemplate(VerificationMessageTemplateType verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate;
            return this;
        }

        public final void setVerificationMessageTemplate(VerificationMessageTemplateType.BuilderImpl verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate != null ? verificationMessageTemplate.build() : null;
        }

        public final String getSmsAuthenticationMessage() {
            return smsAuthenticationMessage;
        }

        @Override
        public final Builder smsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
            return this;
        }

        public final void setSmsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
        }

        public final String getMfaConfigurationAsString() {
            return mfaConfiguration;
        }

        @Override
        public final Builder mfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
            return this;
        }

        @Override
        public final Builder mfaConfiguration(UserPoolMfaType mfaConfiguration) {
            this.mfaConfiguration(mfaConfiguration == null ? null : mfaConfiguration.toString());
            return this;
        }

        public final void setMfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
        }

        public final DeviceConfigurationType.Builder getDeviceConfiguration() {
            return deviceConfiguration != null ? deviceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder deviceConfiguration(DeviceConfigurationType deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
            return this;
        }

        public final void setDeviceConfiguration(DeviceConfigurationType.BuilderImpl deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration != null ? deviceConfiguration.build() : null;
        }

        public final EmailConfigurationType.Builder getEmailConfiguration() {
            return emailConfiguration != null ? emailConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder emailConfiguration(EmailConfigurationType emailConfiguration) {
            this.emailConfiguration = emailConfiguration;
            return this;
        }

        public final void setEmailConfiguration(EmailConfigurationType.BuilderImpl emailConfiguration) {
            this.emailConfiguration = emailConfiguration != null ? emailConfiguration.build() : null;
        }

        public final SmsConfigurationType.Builder getSmsConfiguration() {
            return smsConfiguration != null ? smsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder smsConfiguration(SmsConfigurationType smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        public final void setSmsConfiguration(SmsConfigurationType.BuilderImpl smsConfiguration) {
            this.smsConfiguration = smsConfiguration != null ? smsConfiguration.build() : null;
        }

        public final Map<String, String> getUserPoolTags() {
            return userPoolTags;
        }

        @Override
        public final Builder userPoolTags(Map<String, String> userPoolTags) {
            this.userPoolTags = UserPoolTagsTypeCopier.copy(userPoolTags);
            return this;
        }

        public final void setUserPoolTags(Map<String, String> userPoolTags) {
            this.userPoolTags = UserPoolTagsTypeCopier.copy(userPoolTags);
        }

        public final AdminCreateUserConfigType.Builder getAdminCreateUserConfig() {
            return adminCreateUserConfig != null ? adminCreateUserConfig.toBuilder() : null;
        }

        @Override
        public final Builder adminCreateUserConfig(AdminCreateUserConfigType adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig;
            return this;
        }

        public final void setAdminCreateUserConfig(AdminCreateUserConfigType.BuilderImpl adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig != null ? adminCreateUserConfig.build() : null;
        }

        public final Collection<SchemaAttributeType.Builder> getSchema() {
            return schema != null ? schema.stream().map(SchemaAttributeType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schema(Collection<SchemaAttributeType> schema) {
            this.schema = SchemaAttributesListTypeCopier.copy(schema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(SchemaAttributeType... schema) {
            schema(Arrays.asList(schema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(Consumer<SchemaAttributeType.Builder>... schema) {
            schema(Stream.of(schema).map(c -> SchemaAttributeType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSchema(Collection<SchemaAttributeType.BuilderImpl> schema) {
            this.schema = SchemaAttributesListTypeCopier.copyFromBuilder(schema);
        }

        public final UserPoolAddOnsType.Builder getUserPoolAddOns() {
            return userPoolAddOns != null ? userPoolAddOns.toBuilder() : null;
        }

        @Override
        public final Builder userPoolAddOns(UserPoolAddOnsType userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns;
            return this;
        }

        public final void setUserPoolAddOns(UserPoolAddOnsType.BuilderImpl userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns != null ? userPoolAddOns.build() : null;
        }

        public final UsernameConfigurationType.Builder getUsernameConfiguration() {
            return usernameConfiguration != null ? usernameConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder usernameConfiguration(UsernameConfigurationType usernameConfiguration) {
            this.usernameConfiguration = usernameConfiguration;
            return this;
        }

        public final void setUsernameConfiguration(UsernameConfigurationType.BuilderImpl usernameConfiguration) {
            this.usernameConfiguration = usernameConfiguration != null ? usernameConfiguration.build() : null;
        }

        public final AccountRecoverySettingType.Builder getAccountRecoverySetting() {
            return accountRecoverySetting != null ? accountRecoverySetting.toBuilder() : null;
        }

        @Override
        public final Builder accountRecoverySetting(AccountRecoverySettingType accountRecoverySetting) {
            this.accountRecoverySetting = accountRecoverySetting;
            return this;
        }

        public final void setAccountRecoverySetting(AccountRecoverySettingType.BuilderImpl accountRecoverySetting) {
            this.accountRecoverySetting = accountRecoverySetting != null ? accountRecoverySetting.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserPoolRequest build() {
            return new CreateUserPoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
