/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server for the request to create a user pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserPoolResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<CreateUserPoolResponse.Builder, CreateUserPoolResponse> {
    private static final SdkField<UserPoolType> USER_POOL_FIELD = SdkField.<UserPoolType> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateUserPoolResponse::userPool)).setter(setter(Builder::userPool))
            .constructor(UserPoolType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPool").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_FIELD));

    private final UserPoolType userPool;

    private CreateUserPoolResponse(BuilderImpl builder) {
        super(builder);
        this.userPool = builder.userPool;
    }

    /**
     * <p>
     * A container for the user pool details.
     * </p>
     * 
     * @return A container for the user pool details.
     */
    public UserPoolType userPool() {
        return userPool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPool());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserPoolResponse)) {
            return false;
        }
        CreateUserPoolResponse other = (CreateUserPoolResponse) obj;
        return Objects.equals(userPool(), other.userPool());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateUserPoolResponse").add("UserPool", userPool()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPool":
            return Optional.ofNullable(clazz.cast(userPool()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserPoolResponse, T> g) {
        return obj -> g.apply((CreateUserPoolResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateUserPoolResponse> {
        /**
         * <p>
         * A container for the user pool details.
         * </p>
         * 
         * @param userPool
         *        A container for the user pool details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPool(UserPoolType userPool);

        /**
         * <p>
         * A container for the user pool details.
         * </p>
         * This is a convenience that creates an instance of the {@link UserPoolType.Builder} avoiding the need to
         * create one manually via {@link UserPoolType#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPoolType.Builder#build()} is called immediately and its
         * result is passed to {@link #userPool(UserPoolType)}.
         * 
         * @param userPool
         *        a consumer that will call methods on {@link UserPoolType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPool(UserPoolType)
         */
        default Builder userPool(Consumer<UserPoolType.Builder> userPool) {
            return userPool(UserPoolType.builder().applyMutation(userPool).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private UserPoolType userPool;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserPoolResponse model) {
            super(model);
            userPool(model.userPool);
        }

        public final UserPoolType.Builder getUserPool() {
            return userPool != null ? userPool.toBuilder() : null;
        }

        @Override
        public final Builder userPool(UserPoolType userPool) {
            this.userPool = userPool;
            return this;
        }

        public final void setUserPool(UserPoolType.BuilderImpl userPool) {
            this.userPool = userPool != null ? userPool.build() : null;
        }

        @Override
        public CreateUserPoolResponse build() {
            return new CreateUserPoolResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
