/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to update the device status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDeviceStatusRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<UpdateDeviceStatusRequest.Builder, UpdateDeviceStatusRequest> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDeviceStatusRequest::accessToken)).setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()).build();

    private static final SdkField<String> DEVICE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDeviceStatusRequest::deviceKey)).setter(setter(Builder::deviceKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceKey").build()).build();

    private static final SdkField<String> DEVICE_REMEMBERED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDeviceStatusRequest::deviceRememberedStatusAsString))
            .setter(setter(Builder::deviceRememberedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceRememberedStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            DEVICE_KEY_FIELD, DEVICE_REMEMBERED_STATUS_FIELD));

    private final String accessToken;

    private final String deviceKey;

    private final String deviceRememberedStatus;

    private UpdateDeviceStatusRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.deviceKey = builder.deviceKey;
        this.deviceRememberedStatus = builder.deviceRememberedStatus;
    }

    /**
     * <p>
     * The access token.
     * </p>
     * 
     * @return The access token.
     */
    public String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The device key.
     * </p>
     * 
     * @return The device key.
     */
    public String deviceKey() {
        return deviceKey;
    }

    /**
     * <p>
     * The status of whether a device is remembered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceRememberedStatus} will return {@link DeviceRememberedStatusType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceRememberedStatusAsString}.
     * </p>
     * 
     * @return The status of whether a device is remembered.
     * @see DeviceRememberedStatusType
     */
    public DeviceRememberedStatusType deviceRememberedStatus() {
        return DeviceRememberedStatusType.fromValue(deviceRememberedStatus);
    }

    /**
     * <p>
     * The status of whether a device is remembered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceRememberedStatus} will return {@link DeviceRememberedStatusType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceRememberedStatusAsString}.
     * </p>
     * 
     * @return The status of whether a device is remembered.
     * @see DeviceRememberedStatusType
     */
    public String deviceRememberedStatusAsString() {
        return deviceRememberedStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(deviceKey());
        hashCode = 31 * hashCode + Objects.hashCode(deviceRememberedStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeviceStatusRequest)) {
            return false;
        }
        UpdateDeviceStatusRequest other = (UpdateDeviceStatusRequest) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(deviceKey(), other.deviceKey())
                && Objects.equals(deviceRememberedStatusAsString(), other.deviceRememberedStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDeviceStatusRequest")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DeviceKey", deviceKey()).add("DeviceRememberedStatus", deviceRememberedStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "DeviceKey":
            return Optional.ofNullable(clazz.cast(deviceKey()));
        case "DeviceRememberedStatus":
            return Optional.ofNullable(clazz.cast(deviceRememberedStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeviceStatusRequest, T> g) {
        return obj -> g.apply((UpdateDeviceStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDeviceStatusRequest> {
        /**
         * <p>
         * The access token.
         * </p>
         * 
         * @param accessToken
         *        The access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The device key.
         * </p>
         * 
         * @param deviceKey
         *        The device key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceKey(String deviceKey);

        /**
         * <p>
         * The status of whether a device is remembered.
         * </p>
         * 
         * @param deviceRememberedStatus
         *        The status of whether a device is remembered.
         * @see DeviceRememberedStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceRememberedStatusType
         */
        Builder deviceRememberedStatus(String deviceRememberedStatus);

        /**
         * <p>
         * The status of whether a device is remembered.
         * </p>
         * 
         * @param deviceRememberedStatus
         *        The status of whether a device is remembered.
         * @see DeviceRememberedStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceRememberedStatusType
         */
        Builder deviceRememberedStatus(DeviceRememberedStatusType deviceRememberedStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String accessToken;

        private String deviceKey;

        private String deviceRememberedStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeviceStatusRequest model) {
            super(model);
            accessToken(model.accessToken);
            deviceKey(model.deviceKey);
            deviceRememberedStatus(model.deviceRememberedStatus);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final String getDeviceKey() {
            return deviceKey;
        }

        @Override
        public final Builder deviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
            return this;
        }

        public final void setDeviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
        }

        public final String getDeviceRememberedStatusAsString() {
            return deviceRememberedStatus;
        }

        @Override
        public final Builder deviceRememberedStatus(String deviceRememberedStatus) {
            this.deviceRememberedStatus = deviceRememberedStatus;
            return this;
        }

        @Override
        public final Builder deviceRememberedStatus(DeviceRememberedStatusType deviceRememberedStatus) {
            this.deviceRememberedStatus(deviceRememberedStatus == null ? null : deviceRememberedStatus.toString());
            return this;
        }

        public final void setDeviceRememberedStatus(String deviceRememberedStatus) {
            this.deviceRememberedStatus = deviceRememberedStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeviceStatusRequest build() {
            return new UpdateDeviceStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
