/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetUserPoolMfaConfigRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<SetUserPoolMfaConfigRequest.Builder, SetUserPoolMfaConfigRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetUserPoolMfaConfigRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<SmsMfaConfigType> SMS_MFA_CONFIGURATION_FIELD = SdkField
            .<SmsMfaConfigType> builder(MarshallingType.SDK_POJO)
            .getter(getter(SetUserPoolMfaConfigRequest::smsMfaConfiguration)).setter(setter(Builder::smsMfaConfiguration))
            .constructor(SmsMfaConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsMfaConfiguration").build())
            .build();

    private static final SdkField<SoftwareTokenMfaConfigType> SOFTWARE_TOKEN_MFA_CONFIGURATION_FIELD = SdkField
            .<SoftwareTokenMfaConfigType> builder(MarshallingType.SDK_POJO)
            .getter(getter(SetUserPoolMfaConfigRequest::softwareTokenMfaConfiguration))
            .setter(setter(Builder::softwareTokenMfaConfiguration))
            .constructor(SoftwareTokenMfaConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareTokenMfaConfiguration")
                    .build()).build();

    private static final SdkField<String> MFA_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetUserPoolMfaConfigRequest::mfaConfigurationAsString)).setter(setter(Builder::mfaConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MfaConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            SMS_MFA_CONFIGURATION_FIELD, SOFTWARE_TOKEN_MFA_CONFIGURATION_FIELD, MFA_CONFIGURATION_FIELD));

    private final String userPoolId;

    private final SmsMfaConfigType smsMfaConfiguration;

    private final SoftwareTokenMfaConfigType softwareTokenMfaConfiguration;

    private final String mfaConfiguration;

    private SetUserPoolMfaConfigRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.smsMfaConfiguration = builder.smsMfaConfiguration;
        this.softwareTokenMfaConfiguration = builder.softwareTokenMfaConfiguration;
        this.mfaConfiguration = builder.mfaConfiguration;
    }

    /**
     * <p>
     * The user pool ID.
     * </p>
     * 
     * @return The user pool ID.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The SMS text message MFA configuration.
     * </p>
     * 
     * @return The SMS text message MFA configuration.
     */
    public SmsMfaConfigType smsMfaConfiguration() {
        return smsMfaConfiguration;
    }

    /**
     * <p>
     * The software token MFA configuration.
     * </p>
     * 
     * @return The software token MFA configuration.
     */
    public SoftwareTokenMfaConfigType softwareTokenMfaConfiguration() {
        return softwareTokenMfaConfiguration;
    }

    /**
     * <p>
     * The MFA configuration. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OFF</code> MFA will not be used for any users.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ON</code> MFA is required for all users to sign in.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaConfiguration}
     * will return {@link UserPoolMfaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mfaConfigurationAsString}.
     * </p>
     * 
     * @return The MFA configuration. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OFF</code> MFA will not be used for any users.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ON</code> MFA is required for all users to sign in.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.
     *         </p>
     *         </li>
     * @see UserPoolMfaType
     */
    public UserPoolMfaType mfaConfiguration() {
        return UserPoolMfaType.fromValue(mfaConfiguration);
    }

    /**
     * <p>
     * The MFA configuration. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OFF</code> MFA will not be used for any users.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ON</code> MFA is required for all users to sign in.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaConfiguration}
     * will return {@link UserPoolMfaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mfaConfigurationAsString}.
     * </p>
     * 
     * @return The MFA configuration. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OFF</code> MFA will not be used for any users.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ON</code> MFA is required for all users to sign in.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.
     *         </p>
     *         </li>
     * @see UserPoolMfaType
     */
    public String mfaConfigurationAsString() {
        return mfaConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(smsMfaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(softwareTokenMfaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(mfaConfigurationAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetUserPoolMfaConfigRequest)) {
            return false;
        }
        SetUserPoolMfaConfigRequest other = (SetUserPoolMfaConfigRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId())
                && Objects.equals(smsMfaConfiguration(), other.smsMfaConfiguration())
                && Objects.equals(softwareTokenMfaConfiguration(), other.softwareTokenMfaConfiguration())
                && Objects.equals(mfaConfigurationAsString(), other.mfaConfigurationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SetUserPoolMfaConfigRequest").add("UserPoolId", userPoolId())
                .add("SmsMfaConfiguration", smsMfaConfiguration())
                .add("SoftwareTokenMfaConfiguration", softwareTokenMfaConfiguration())
                .add("MfaConfiguration", mfaConfigurationAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "SmsMfaConfiguration":
            return Optional.ofNullable(clazz.cast(smsMfaConfiguration()));
        case "SoftwareTokenMfaConfiguration":
            return Optional.ofNullable(clazz.cast(softwareTokenMfaConfiguration()));
        case "MfaConfiguration":
            return Optional.ofNullable(clazz.cast(mfaConfigurationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetUserPoolMfaConfigRequest, T> g) {
        return obj -> g.apply((SetUserPoolMfaConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetUserPoolMfaConfigRequest> {
        /**
         * <p>
         * The user pool ID.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The SMS text message MFA configuration.
         * </p>
         * 
         * @param smsMfaConfiguration
         *        The SMS text message MFA configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsMfaConfiguration(SmsMfaConfigType smsMfaConfiguration);

        /**
         * <p>
         * The SMS text message MFA configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link SmsMfaConfigType.Builder} avoiding the need to
         * create one manually via {@link SmsMfaConfigType#builder()}.
         *
         * When the {@link Consumer} completes, {@link SmsMfaConfigType.Builder#build()} is called immediately and its
         * result is passed to {@link #smsMfaConfiguration(SmsMfaConfigType)}.
         * 
         * @param smsMfaConfiguration
         *        a consumer that will call methods on {@link SmsMfaConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsMfaConfiguration(SmsMfaConfigType)
         */
        default Builder smsMfaConfiguration(Consumer<SmsMfaConfigType.Builder> smsMfaConfiguration) {
            return smsMfaConfiguration(SmsMfaConfigType.builder().applyMutation(smsMfaConfiguration).build());
        }

        /**
         * <p>
         * The software token MFA configuration.
         * </p>
         * 
         * @param softwareTokenMfaConfiguration
         *        The software token MFA configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType softwareTokenMfaConfiguration);

        /**
         * <p>
         * The software token MFA configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link SoftwareTokenMfaConfigType.Builder} avoiding the
         * need to create one manually via {@link SoftwareTokenMfaConfigType#builder()}.
         *
         * When the {@link Consumer} completes, {@link SoftwareTokenMfaConfigType.Builder#build()} is called immediately
         * and its result is passed to {@link #softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType)}.
         * 
         * @param softwareTokenMfaConfiguration
         *        a consumer that will call methods on {@link SoftwareTokenMfaConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType)
         */
        default Builder softwareTokenMfaConfiguration(Consumer<SoftwareTokenMfaConfigType.Builder> softwareTokenMfaConfiguration) {
            return softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType.builder()
                    .applyMutation(softwareTokenMfaConfiguration).build());
        }

        /**
         * <p>
         * The MFA configuration. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OFF</code> MFA will not be used for any users.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ON</code> MFA is required for all users to sign in.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mfaConfiguration
         *        The MFA configuration. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OFF</code> MFA will not be used for any users.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ON</code> MFA is required for all users to sign in.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.
         *        </p>
         *        </li>
         * @see UserPoolMfaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserPoolMfaType
         */
        Builder mfaConfiguration(String mfaConfiguration);

        /**
         * <p>
         * The MFA configuration. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OFF</code> MFA will not be used for any users.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ON</code> MFA is required for all users to sign in.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mfaConfiguration
         *        The MFA configuration. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OFF</code> MFA will not be used for any users.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ON</code> MFA is required for all users to sign in.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.
         *        </p>
         *        </li>
         * @see UserPoolMfaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserPoolMfaType
         */
        Builder mfaConfiguration(UserPoolMfaType mfaConfiguration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private SmsMfaConfigType smsMfaConfiguration;

        private SoftwareTokenMfaConfigType softwareTokenMfaConfiguration;

        private String mfaConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SetUserPoolMfaConfigRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            smsMfaConfiguration(model.smsMfaConfiguration);
            softwareTokenMfaConfiguration(model.softwareTokenMfaConfiguration);
            mfaConfiguration(model.mfaConfiguration);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final SmsMfaConfigType.Builder getSmsMfaConfiguration() {
            return smsMfaConfiguration != null ? smsMfaConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder smsMfaConfiguration(SmsMfaConfigType smsMfaConfiguration) {
            this.smsMfaConfiguration = smsMfaConfiguration;
            return this;
        }

        public final void setSmsMfaConfiguration(SmsMfaConfigType.BuilderImpl smsMfaConfiguration) {
            this.smsMfaConfiguration = smsMfaConfiguration != null ? smsMfaConfiguration.build() : null;
        }

        public final SoftwareTokenMfaConfigType.Builder getSoftwareTokenMfaConfiguration() {
            return softwareTokenMfaConfiguration != null ? softwareTokenMfaConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType softwareTokenMfaConfiguration) {
            this.softwareTokenMfaConfiguration = softwareTokenMfaConfiguration;
            return this;
        }

        public final void setSoftwareTokenMfaConfiguration(SoftwareTokenMfaConfigType.BuilderImpl softwareTokenMfaConfiguration) {
            this.softwareTokenMfaConfiguration = softwareTokenMfaConfiguration != null ? softwareTokenMfaConfiguration.build()
                    : null;
        }

        public final String getMfaConfigurationAsString() {
            return mfaConfiguration;
        }

        @Override
        public final Builder mfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
            return this;
        }

        @Override
        public final Builder mfaConfiguration(UserPoolMfaType mfaConfiguration) {
            this.mfaConfiguration(mfaConfiguration == null ? null : mfaConfiguration.toString());
            return this;
        }

        public final void setMfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetUserPoolMfaConfigRequest build() {
            return new SetUserPoolMfaConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
