/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SMS configuration type that includes the settings the Cognito User Pool needs to call for the Amazon SNS service
 * to send an SMS message from your AWS account. The Cognito User Pool makes the request to the Amazon SNS Service by
 * using an AWS IAM role that you provide for your AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SmsConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<SmsConfigurationType.Builder, SmsConfigurationType> {
    private static final SdkField<String> SNS_CALLER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SmsConfigurationType::snsCallerArn)).setter(setter(Builder::snsCallerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsCallerArn").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SmsConfigurationType::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_CALLER_ARN_FIELD,
            EXTERNAL_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String snsCallerArn;

    private final String externalId;

    private SmsConfigurationType(BuilderImpl builder) {
        this.snsCallerArn = builder.snsCallerArn;
        this.externalId = builder.externalId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) caller. This is the ARN of the IAM
     * role in your AWS account which Cognito will use to send SMS messages.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) caller. This is the ARN of
     *         the IAM role in your AWS account which Cognito will use to send SMS messages.
     */
    public String snsCallerArn() {
        return snsCallerArn;
    }

    /**
     * <p>
     * The external ID is a value that we recommend you use to add security to your IAM role which is used to call
     * Amazon SNS to send SMS messages for your user pool. If you provide an <code>ExternalId</code>, the Cognito User
     * Pool will include it when attempting to assume your IAM role, so that you can set your roles trust policy to
     * require the <code>ExternalID</code>. If you use the Cognito Management Console to create a role for SMS MFA,
     * Cognito will create a role with the required permissions and a trust policy that demonstrates use of the
     * <code>ExternalId</code>.
     * </p>
     * 
     * @return The external ID is a value that we recommend you use to add security to your IAM role which is used to
     *         call Amazon SNS to send SMS messages for your user pool. If you provide an <code>ExternalId</code>, the
     *         Cognito User Pool will include it when attempting to assume your IAM role, so that you can set your roles
     *         trust policy to require the <code>ExternalID</code>. If you use the Cognito Management Console to create
     *         a role for SMS MFA, Cognito will create a role with the required permissions and a trust policy that
     *         demonstrates use of the <code>ExternalId</code>.
     */
    public String externalId() {
        return externalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snsCallerArn());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmsConfigurationType)) {
            return false;
        }
        SmsConfigurationType other = (SmsConfigurationType) obj;
        return Objects.equals(snsCallerArn(), other.snsCallerArn()) && Objects.equals(externalId(), other.externalId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SmsConfigurationType").add("SnsCallerArn", snsCallerArn()).add("ExternalId", externalId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnsCallerArn":
            return Optional.ofNullable(clazz.cast(snsCallerArn()));
        case "ExternalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SmsConfigurationType, T> g) {
        return obj -> g.apply((SmsConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SmsConfigurationType> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) caller. This is the ARN of the
         * IAM role in your AWS account which Cognito will use to send SMS messages.
         * </p>
         * 
         * @param snsCallerArn
         *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) caller. This is the ARN
         *        of the IAM role in your AWS account which Cognito will use to send SMS messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsCallerArn(String snsCallerArn);

        /**
         * <p>
         * The external ID is a value that we recommend you use to add security to your IAM role which is used to call
         * Amazon SNS to send SMS messages for your user pool. If you provide an <code>ExternalId</code>, the Cognito
         * User Pool will include it when attempting to assume your IAM role, so that you can set your roles trust
         * policy to require the <code>ExternalID</code>. If you use the Cognito Management Console to create a role for
         * SMS MFA, Cognito will create a role with the required permissions and a trust policy that demonstrates use of
         * the <code>ExternalId</code>.
         * </p>
         * 
         * @param externalId
         *        The external ID is a value that we recommend you use to add security to your IAM role which is used to
         *        call Amazon SNS to send SMS messages for your user pool. If you provide an <code>ExternalId</code>,
         *        the Cognito User Pool will include it when attempting to assume your IAM role, so that you can set
         *        your roles trust policy to require the <code>ExternalID</code>. If you use the Cognito Management
         *        Console to create a role for SMS MFA, Cognito will create a role with the required permissions and a
         *        trust policy that demonstrates use of the <code>ExternalId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);
    }

    static final class BuilderImpl implements Builder {
        private String snsCallerArn;

        private String externalId;

        private BuilderImpl() {
        }

        private BuilderImpl(SmsConfigurationType model) {
            snsCallerArn(model.snsCallerArn);
            externalId(model.externalId);
        }

        public final String getSnsCallerArn() {
            return snsCallerArn;
        }

        @Override
        public final Builder snsCallerArn(String snsCallerArn) {
            this.snsCallerArn = snsCallerArn;
            return this;
        }

        public final void setSnsCallerArn(String snsCallerArn) {
            this.snsCallerArn = snsCallerArn;
        }

        public final String getExternalId() {
            return externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public SmsConfigurationType build() {
            return new SmsConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
