/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server from a request to describe the user pool client.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserPoolClientResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<DescribeUserPoolClientResponse.Builder, DescribeUserPoolClientResponse> {
    private static final SdkField<UserPoolClientType> USER_POOL_CLIENT_FIELD = SdkField
            .<UserPoolClientType> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeUserPoolClientResponse::userPoolClient)).setter(setter(Builder::userPoolClient))
            .constructor(UserPoolClientType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolClient").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_CLIENT_FIELD));

    private final UserPoolClientType userPoolClient;

    private DescribeUserPoolClientResponse(BuilderImpl builder) {
        super(builder);
        this.userPoolClient = builder.userPoolClient;
    }

    /**
     * <p>
     * The user pool client from a server response to describe the user pool client.
     * </p>
     * 
     * @return The user pool client from a server response to describe the user pool client.
     */
    public UserPoolClientType userPoolClient() {
        return userPoolClient;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolClient());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserPoolClientResponse)) {
            return false;
        }
        DescribeUserPoolClientResponse other = (DescribeUserPoolClientResponse) obj;
        return Objects.equals(userPoolClient(), other.userPoolClient());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeUserPoolClientResponse").add("UserPoolClient", userPoolClient()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolClient":
            return Optional.ofNullable(clazz.cast(userPoolClient()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserPoolClientResponse, T> g) {
        return obj -> g.apply((DescribeUserPoolClientResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeUserPoolClientResponse> {
        /**
         * <p>
         * The user pool client from a server response to describe the user pool client.
         * </p>
         * 
         * @param userPoolClient
         *        The user pool client from a server response to describe the user pool client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolClient(UserPoolClientType userPoolClient);

        /**
         * <p>
         * The user pool client from a server response to describe the user pool client.
         * </p>
         * This is a convenience that creates an instance of the {@link UserPoolClientType.Builder} avoiding the need to
         * create one manually via {@link UserPoolClientType#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPoolClientType.Builder#build()} is called immediately and its
         * result is passed to {@link #userPoolClient(UserPoolClientType)}.
         * 
         * @param userPoolClient
         *        a consumer that will call methods on {@link UserPoolClientType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPoolClient(UserPoolClientType)
         */
        default Builder userPoolClient(Consumer<UserPoolClientType.Builder> userPoolClient) {
            return userPoolClient(UserPoolClientType.builder().applyMutation(userPoolClient).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private UserPoolClientType userPoolClient;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserPoolClientResponse model) {
            super(model);
            userPoolClient(model.userPoolClient);
        }

        public final UserPoolClientType.Builder getUserPoolClient() {
            return userPoolClient != null ? userPoolClient.toBuilder() : null;
        }

        @Override
        public final Builder userPoolClient(UserPoolClientType userPoolClient) {
            this.userPoolClient = userPoolClient;
            return this;
        }

        public final void setUserPoolClient(UserPoolClientType.BuilderImpl userPoolClient) {
            this.userPoolClient = userPoolClient != null ? userPoolClient.build() : null;
        }

        @Override
        public DescribeUserPoolClientResponse build() {
            return new DescribeUserPoolClientResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
