/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The type of the configuration to override the risk decision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RiskExceptionConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<RiskExceptionConfigurationType.Builder, RiskExceptionConfigurationType> {
    private static final SdkField<List<String>> BLOCKED_IP_RANGE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RiskExceptionConfigurationType::blockedIPRangeList))
            .setter(setter(Builder::blockedIPRangeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockedIPRangeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SKIPPED_IP_RANGE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RiskExceptionConfigurationType::skippedIPRangeList))
            .setter(setter(Builder::skippedIPRangeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkippedIPRangeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKED_IP_RANGE_LIST_FIELD,
            SKIPPED_IP_RANGE_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> blockedIPRangeList;

    private final List<String> skippedIPRangeList;

    private RiskExceptionConfigurationType(BuilderImpl builder) {
        this.blockedIPRangeList = builder.blockedIPRangeList;
        this.skippedIPRangeList = builder.skippedIPRangeList;
    }

    /**
     * Returns true if the BlockedIPRangeList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBlockedIPRangeList() {
        return blockedIPRangeList != null && !(blockedIPRangeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Overrides the risk decision to always block the pre-authentication requests. The IP range is in CIDR notation: a
     * compact representation of an IP address and its associated routing prefix.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBlockedIPRangeList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Overrides the risk decision to always block the pre-authentication requests. The IP range is in CIDR
     *         notation: a compact representation of an IP address and its associated routing prefix.
     */
    public List<String> blockedIPRangeList() {
        return blockedIPRangeList;
    }

    /**
     * Returns true if the SkippedIPRangeList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSkippedIPRangeList() {
        return skippedIPRangeList != null && !(skippedIPRangeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Risk detection is not performed on the IP addresses in the range list. The IP range is in CIDR notation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSkippedIPRangeList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Risk detection is not performed on the IP addresses in the range list. The IP range is in CIDR notation.
     */
    public List<String> skippedIPRangeList() {
        return skippedIPRangeList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blockedIPRangeList());
        hashCode = 31 * hashCode + Objects.hashCode(skippedIPRangeList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RiskExceptionConfigurationType)) {
            return false;
        }
        RiskExceptionConfigurationType other = (RiskExceptionConfigurationType) obj;
        return Objects.equals(blockedIPRangeList(), other.blockedIPRangeList())
                && Objects.equals(skippedIPRangeList(), other.skippedIPRangeList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RiskExceptionConfigurationType").add("BlockedIPRangeList", blockedIPRangeList())
                .add("SkippedIPRangeList", skippedIPRangeList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockedIPRangeList":
            return Optional.ofNullable(clazz.cast(blockedIPRangeList()));
        case "SkippedIPRangeList":
            return Optional.ofNullable(clazz.cast(skippedIPRangeList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RiskExceptionConfigurationType, T> g) {
        return obj -> g.apply((RiskExceptionConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RiskExceptionConfigurationType> {
        /**
         * <p>
         * Overrides the risk decision to always block the pre-authentication requests. The IP range is in CIDR
         * notation: a compact representation of an IP address and its associated routing prefix.
         * </p>
         * 
         * @param blockedIPRangeList
         *        Overrides the risk decision to always block the pre-authentication requests. The IP range is in CIDR
         *        notation: a compact representation of an IP address and its associated routing prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedIPRangeList(Collection<String> blockedIPRangeList);

        /**
         * <p>
         * Overrides the risk decision to always block the pre-authentication requests. The IP range is in CIDR
         * notation: a compact representation of an IP address and its associated routing prefix.
         * </p>
         * 
         * @param blockedIPRangeList
         *        Overrides the risk decision to always block the pre-authentication requests. The IP range is in CIDR
         *        notation: a compact representation of an IP address and its associated routing prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedIPRangeList(String... blockedIPRangeList);

        /**
         * <p>
         * Risk detection is not performed on the IP addresses in the range list. The IP range is in CIDR notation.
         * </p>
         * 
         * @param skippedIPRangeList
         *        Risk detection is not performed on the IP addresses in the range list. The IP range is in CIDR
         *        notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skippedIPRangeList(Collection<String> skippedIPRangeList);

        /**
         * <p>
         * Risk detection is not performed on the IP addresses in the range list. The IP range is in CIDR notation.
         * </p>
         * 
         * @param skippedIPRangeList
         *        Risk detection is not performed on the IP addresses in the range list. The IP range is in CIDR
         *        notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skippedIPRangeList(String... skippedIPRangeList);
    }

    static final class BuilderImpl implements Builder {
        private List<String> blockedIPRangeList = DefaultSdkAutoConstructList.getInstance();

        private List<String> skippedIPRangeList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RiskExceptionConfigurationType model) {
            blockedIPRangeList(model.blockedIPRangeList);
            skippedIPRangeList(model.skippedIPRangeList);
        }

        public final Collection<String> getBlockedIPRangeList() {
            return blockedIPRangeList;
        }

        @Override
        public final Builder blockedIPRangeList(Collection<String> blockedIPRangeList) {
            this.blockedIPRangeList = BlockedIPRangeListTypeCopier.copy(blockedIPRangeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedIPRangeList(String... blockedIPRangeList) {
            blockedIPRangeList(Arrays.asList(blockedIPRangeList));
            return this;
        }

        public final void setBlockedIPRangeList(Collection<String> blockedIPRangeList) {
            this.blockedIPRangeList = BlockedIPRangeListTypeCopier.copy(blockedIPRangeList);
        }

        public final Collection<String> getSkippedIPRangeList() {
            return skippedIPRangeList;
        }

        @Override
        public final Builder skippedIPRangeList(Collection<String> skippedIPRangeList) {
            this.skippedIPRangeList = SkippedIPRangeListTypeCopier.copy(skippedIPRangeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skippedIPRangeList(String... skippedIPRangeList) {
            skippedIPRangeList(Arrays.asList(skippedIPRangeList));
            return this;
        }

        public final void setSkippedIPRangeList(Collection<String> skippedIPRangeList) {
            this.skippedIPRangeList = SkippedIPRangeListTypeCopier.copy(skippedIPRangeList);
        }

        @Override
        public RiskExceptionConfigurationType build() {
            return new RiskExceptionConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
