/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Pinpoint analytics configuration for collecting metrics for a user pool.
 * </p>
 * <note>
 * <p>
 * In regions where Pinpoint is not available, Cognito User Pools only supports sending events to Amazon Pinpoint
 * projects in us-east-1. In regions where Pinpoint is available, Cognito User Pools will support sending events to
 * Amazon Pinpoint projects within that same region.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyticsConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyticsConfigurationType.Builder, AnalyticsConfigurationType> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalyticsConfigurationType::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalyticsConfigurationType::applicationArn)).setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalyticsConfigurationType::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalyticsConfigurationType::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()).build();

    private static final SdkField<Boolean> USER_DATA_SHARED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AnalyticsConfigurationType::userDataShared)).setter(setter(Builder::userDataShared))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDataShared").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            APPLICATION_ARN_FIELD, ROLE_ARN_FIELD, EXTERNAL_ID_FIELD, USER_DATA_SHARED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String applicationArn;

    private final String roleArn;

    private final String externalId;

    private final Boolean userDataShared;

    private AnalyticsConfigurationType(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.applicationArn = builder.applicationArn;
        this.roleArn = builder.roleArn;
        this.externalId = builder.externalId;
        this.userDataShared = builder.userDataShared;
    }

    /**
     * <p>
     * The application ID for an Amazon Pinpoint application.
     * </p>
     * 
     * @return The application ID for an Amazon Pinpoint application.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the Amazon Pinpoint project for
     * Pinpoint integration with the chosen User Pool Client. Amazon Cognito publishes events to the pinpoint project
     * declared by the app ARN.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the Amazon Pinpoint project for
     *         Pinpoint integration with the chosen User Pool Client. Amazon Cognito publishes events to the pinpoint
     *         project declared by the app ARN.
     */
    public String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.
     * </p>
     * 
     * @return The ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The external ID.
     * </p>
     * 
     * @return The external ID.
     */
    public String externalId() {
        return externalId;
    }

    /**
     * <p>
     * If <code>UserDataShared</code> is <code>true</code>, Amazon Cognito will include user data in the events it
     * publishes to Amazon Pinpoint analytics.
     * </p>
     * 
     * @return If <code>UserDataShared</code> is <code>true</code>, Amazon Cognito will include user data in the events
     *         it publishes to Amazon Pinpoint analytics.
     */
    public Boolean userDataShared() {
        return userDataShared;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(userDataShared());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsConfigurationType)) {
            return false;
        }
        AnalyticsConfigurationType other = (AnalyticsConfigurationType) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(applicationArn(), other.applicationArn())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(externalId(), other.externalId())
                && Objects.equals(userDataShared(), other.userDataShared());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AnalyticsConfigurationType").add("ApplicationId", applicationId())
                .add("ApplicationArn", applicationArn()).add("RoleArn", roleArn()).add("ExternalId", externalId())
                .add("UserDataShared", userDataShared()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ExternalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "UserDataShared":
            return Optional.ofNullable(clazz.cast(userDataShared()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsConfigurationType, T> g) {
        return obj -> g.apply((AnalyticsConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyticsConfigurationType> {
        /**
         * <p>
         * The application ID for an Amazon Pinpoint application.
         * </p>
         * 
         * @param applicationId
         *        The application ID for an Amazon Pinpoint application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the Amazon Pinpoint project for
         * Pinpoint integration with the chosen User Pool Client. Amazon Cognito publishes events to the pinpoint
         * project declared by the app ARN.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the Amazon Pinpoint project
         *        for Pinpoint integration with the chosen User Pool Client. Amazon Cognito publishes events to the
         *        pinpoint project declared by the app ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.
         * </p>
         * 
         * @param roleArn
         *        The ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The external ID.
         * </p>
         * 
         * @param externalId
         *        The external ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * If <code>UserDataShared</code> is <code>true</code>, Amazon Cognito will include user data in the events it
         * publishes to Amazon Pinpoint analytics.
         * </p>
         * 
         * @param userDataShared
         *        If <code>UserDataShared</code> is <code>true</code>, Amazon Cognito will include user data in the
         *        events it publishes to Amazon Pinpoint analytics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDataShared(Boolean userDataShared);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String applicationArn;

        private String roleArn;

        private String externalId;

        private Boolean userDataShared;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsConfigurationType model) {
            applicationId(model.applicationId);
            applicationArn(model.applicationArn);
            roleArn(model.roleArn);
            externalId(model.externalId);
            userDataShared(model.userDataShared);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getExternalId() {
            return externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final Boolean getUserDataShared() {
            return userDataShared;
        }

        @Override
        public final Builder userDataShared(Boolean userDataShared) {
            this.userDataShared = userDataShared;
            return this;
        }

        public final void setUserDataShared(Boolean userDataShared) {
            this.userDataShared = userDataShared;
        }

        @Override
        public AnalyticsConfigurationType build() {
            return new AnalyticsConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
