/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGroupResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<GetGroupResponse.Builder, GetGroupResponse> {
    private static final SdkField<GroupType> GROUP_FIELD = SdkField.<GroupType> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetGroupResponse::group)).setter(setter(Builder::group)).constructor(GroupType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD));

    private final GroupType group;

    private GetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.group = builder.group;
    }

    /**
     * <p>
     * The group object for the group.
     * </p>
     * 
     * @return The group object for the group.
     */
    public GroupType group() {
        return group;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(group());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupResponse)) {
            return false;
        }
        GetGroupResponse other = (GetGroupResponse) obj;
        return Objects.equals(group(), other.group());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetGroupResponse").add("Group", group()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Group":
            return Optional.ofNullable(clazz.cast(group()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGroupResponse, T> g) {
        return obj -> g.apply((GetGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetGroupResponse> {
        /**
         * <p>
         * The group object for the group.
         * </p>
         * 
         * @param group
         *        The group object for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(GroupType group);

        /**
         * <p>
         * The group object for the group.
         * </p>
         * This is a convenience that creates an instance of the {@link GroupType.Builder} avoiding the need to create
         * one manually via {@link GroupType#builder()}.
         *
         * When the {@link Consumer} completes, {@link GroupType.Builder#build()} is called immediately and its result
         * is passed to {@link #group(GroupType)}.
         * 
         * @param group
         *        a consumer that will call methods on {@link GroupType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #group(GroupType)
         */
        default Builder group(Consumer<GroupType.Builder> group) {
            return group(GroupType.builder().applyMutation(group).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private GroupType group;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupResponse model) {
            super(model);
            group(model.group);
        }

        public final GroupType.Builder getGroup() {
            return group != null ? group.toBuilder() : null;
        }

        @Override
        public final Builder group(GroupType group) {
            this.group = group;
            return this;
        }

        public final void setGroup(GroupType.BuilderImpl group) {
            this.group = group != null ? group.build() : null;
        }

        @Override
        public GetGroupResponse build() {
            return new GetGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
