/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for information about an identity provider for a user pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProviderUserIdentifierType implements SdkPojo, Serializable,
        ToCopyableBuilder<ProviderUserIdentifierType.Builder, ProviderUserIdentifierType> {
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProviderUserIdentifierType::providerName)).setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderName").build()).build();

    private static final SdkField<String> PROVIDER_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProviderUserIdentifierType::providerAttributeName)).setter(setter(Builder::providerAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderAttributeName").build())
            .build();

    private static final SdkField<String> PROVIDER_ATTRIBUTE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProviderUserIdentifierType::providerAttributeValue)).setter(setter(Builder::providerAttributeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderAttributeValue").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_NAME_FIELD,
            PROVIDER_ATTRIBUTE_NAME_FIELD, PROVIDER_ATTRIBUTE_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String providerName;

    private final String providerAttributeName;

    private final String providerAttributeValue;

    private ProviderUserIdentifierType(BuilderImpl builder) {
        this.providerName = builder.providerName;
        this.providerAttributeName = builder.providerAttributeName;
        this.providerAttributeValue = builder.providerAttributeValue;
    }

    /**
     * <p>
     * The name of the provider, for example, Facebook, Google, or Login with Amazon.
     * </p>
     * 
     * @return The name of the provider, for example, Facebook, Google, or Login with Amazon.
     */
    public String providerName() {
        return providerName;
    }

    /**
     * <p>
     * The name of the provider attribute to link to, for example, <code>NameID</code>.
     * </p>
     * 
     * @return The name of the provider attribute to link to, for example, <code>NameID</code>.
     */
    public String providerAttributeName() {
        return providerAttributeName;
    }

    /**
     * <p>
     * The value of the provider attribute to link to, for example, <code>xxxxx_account</code>.
     * </p>
     * 
     * @return The value of the provider attribute to link to, for example, <code>xxxxx_account</code>.
     */
    public String providerAttributeValue() {
        return providerAttributeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(providerAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(providerAttributeValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderUserIdentifierType)) {
            return false;
        }
        ProviderUserIdentifierType other = (ProviderUserIdentifierType) obj;
        return Objects.equals(providerName(), other.providerName())
                && Objects.equals(providerAttributeName(), other.providerAttributeName())
                && Objects.equals(providerAttributeValue(), other.providerAttributeValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProviderUserIdentifierType").add("ProviderName", providerName())
                .add("ProviderAttributeName", providerAttributeName()).add("ProviderAttributeValue", providerAttributeValue())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProviderName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "ProviderAttributeName":
            return Optional.ofNullable(clazz.cast(providerAttributeName()));
        case "ProviderAttributeValue":
            return Optional.ofNullable(clazz.cast(providerAttributeValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProviderUserIdentifierType, T> g) {
        return obj -> g.apply((ProviderUserIdentifierType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProviderUserIdentifierType> {
        /**
         * <p>
         * The name of the provider, for example, Facebook, Google, or Login with Amazon.
         * </p>
         * 
         * @param providerName
         *        The name of the provider, for example, Facebook, Google, or Login with Amazon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The name of the provider attribute to link to, for example, <code>NameID</code>.
         * </p>
         * 
         * @param providerAttributeName
         *        The name of the provider attribute to link to, for example, <code>NameID</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerAttributeName(String providerAttributeName);

        /**
         * <p>
         * The value of the provider attribute to link to, for example, <code>xxxxx_account</code>.
         * </p>
         * 
         * @param providerAttributeValue
         *        The value of the provider attribute to link to, for example, <code>xxxxx_account</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerAttributeValue(String providerAttributeValue);
    }

    static final class BuilderImpl implements Builder {
        private String providerName;

        private String providerAttributeName;

        private String providerAttributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderUserIdentifierType model) {
            providerName(model.providerName);
            providerAttributeName(model.providerAttributeName);
            providerAttributeValue(model.providerAttributeValue);
        }

        public final String getProviderName() {
            return providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getProviderAttributeName() {
            return providerAttributeName;
        }

        @Override
        public final Builder providerAttributeName(String providerAttributeName) {
            this.providerAttributeName = providerAttributeName;
            return this;
        }

        public final void setProviderAttributeName(String providerAttributeName) {
            this.providerAttributeName = providerAttributeName;
        }

        public final String getProviderAttributeValue() {
            return providerAttributeValue;
        }

        @Override
        public final Builder providerAttributeValue(String providerAttributeValue) {
            this.providerAttributeValue = providerAttributeValue;
            return this;
        }

        public final void setProviderAttributeValue(String providerAttributeValue) {
            this.providerAttributeValue = providerAttributeValue;
        }

        @Override
        public ProviderUserIdentifierType build() {
            return new ProviderUserIdentifierType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
