/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetRiskConfigurationRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<SetRiskConfigurationRequest.Builder, SetRiskConfigurationRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(SetRiskConfigurationRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(SetRiskConfigurationRequest::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<CompromisedCredentialsRiskConfigurationType> COMPROMISED_CREDENTIALS_RISK_CONFIGURATION_FIELD = SdkField
            .<CompromisedCredentialsRiskConfigurationType> builder(MarshallingType.SDK_POJO)
            .memberName("CompromisedCredentialsRiskConfiguration")
            .getter(getter(SetRiskConfigurationRequest::compromisedCredentialsRiskConfiguration))
            .setter(setter(Builder::compromisedCredentialsRiskConfiguration))
            .constructor(CompromisedCredentialsRiskConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CompromisedCredentialsRiskConfiguration").build()).build();

    private static final SdkField<AccountTakeoverRiskConfigurationType> ACCOUNT_TAKEOVER_RISK_CONFIGURATION_FIELD = SdkField
            .<AccountTakeoverRiskConfigurationType> builder(MarshallingType.SDK_POJO)
            .memberName("AccountTakeoverRiskConfiguration")
            .getter(getter(SetRiskConfigurationRequest::accountTakeoverRiskConfiguration))
            .setter(setter(Builder::accountTakeoverRiskConfiguration))
            .constructor(AccountTakeoverRiskConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountTakeoverRiskConfiguration")
                    .build()).build();

    private static final SdkField<RiskExceptionConfigurationType> RISK_EXCEPTION_CONFIGURATION_FIELD = SdkField
            .<RiskExceptionConfigurationType> builder(MarshallingType.SDK_POJO)
            .memberName("RiskExceptionConfiguration")
            .getter(getter(SetRiskConfigurationRequest::riskExceptionConfiguration))
            .setter(setter(Builder::riskExceptionConfiguration))
            .constructor(RiskExceptionConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskExceptionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            CLIENT_ID_FIELD, COMPROMISED_CREDENTIALS_RISK_CONFIGURATION_FIELD, ACCOUNT_TAKEOVER_RISK_CONFIGURATION_FIELD,
            RISK_EXCEPTION_CONFIGURATION_FIELD));

    private final String userPoolId;

    private final String clientId;

    private final CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration;

    private final AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration;

    private final RiskExceptionConfigurationType riskExceptionConfiguration;

    private SetRiskConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.compromisedCredentialsRiskConfiguration = builder.compromisedCredentialsRiskConfiguration;
        this.accountTakeoverRiskConfiguration = builder.accountTakeoverRiskConfiguration;
        this.riskExceptionConfiguration = builder.riskExceptionConfiguration;
    }

    /**
     * <p>
     * The user pool ID.
     * </p>
     * 
     * @return The user pool ID.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The app client ID. If <code>ClientId</code> is null, then the risk configuration is mapped to
     * <code>userPoolId</code>. When the client ID is null, the same risk configuration is applied to all the clients in
     * the userPool.
     * </p>
     * <p>
     * Otherwise, <code>ClientId</code> is mapped to the client. When the client ID is not null, the user pool
     * configuration is overridden and the risk configuration for the client is used instead.
     * </p>
     * 
     * @return The app client ID. If <code>ClientId</code> is null, then the risk configuration is mapped to
     *         <code>userPoolId</code>. When the client ID is null, the same risk configuration is applied to all the
     *         clients in the userPool.</p>
     *         <p>
     *         Otherwise, <code>ClientId</code> is mapped to the client. When the client ID is not null, the user pool
     *         configuration is overridden and the risk configuration for the client is used instead.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The compromised credentials risk configuration.
     * </p>
     * 
     * @return The compromised credentials risk configuration.
     */
    public CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration() {
        return compromisedCredentialsRiskConfiguration;
    }

    /**
     * <p>
     * The account takeover risk configuration.
     * </p>
     * 
     * @return The account takeover risk configuration.
     */
    public AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration() {
        return accountTakeoverRiskConfiguration;
    }

    /**
     * <p>
     * The configuration to override the risk decision.
     * </p>
     * 
     * @return The configuration to override the risk decision.
     */
    public RiskExceptionConfigurationType riskExceptionConfiguration() {
        return riskExceptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(compromisedCredentialsRiskConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(accountTakeoverRiskConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(riskExceptionConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetRiskConfigurationRequest)) {
            return false;
        }
        SetRiskConfigurationRequest other = (SetRiskConfigurationRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(compromisedCredentialsRiskConfiguration(), other.compromisedCredentialsRiskConfiguration())
                && Objects.equals(accountTakeoverRiskConfiguration(), other.accountTakeoverRiskConfiguration())
                && Objects.equals(riskExceptionConfiguration(), other.riskExceptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SetRiskConfigurationRequest").add("UserPoolId", userPoolId())
                .add("ClientId", clientId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CompromisedCredentialsRiskConfiguration", compromisedCredentialsRiskConfiguration())
                .add("AccountTakeoverRiskConfiguration", accountTakeoverRiskConfiguration())
                .add("RiskExceptionConfiguration", riskExceptionConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "CompromisedCredentialsRiskConfiguration":
            return Optional.ofNullable(clazz.cast(compromisedCredentialsRiskConfiguration()));
        case "AccountTakeoverRiskConfiguration":
            return Optional.ofNullable(clazz.cast(accountTakeoverRiskConfiguration()));
        case "RiskExceptionConfiguration":
            return Optional.ofNullable(clazz.cast(riskExceptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetRiskConfigurationRequest, T> g) {
        return obj -> g.apply((SetRiskConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetRiskConfigurationRequest> {
        /**
         * <p>
         * The user pool ID.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The app client ID. If <code>ClientId</code> is null, then the risk configuration is mapped to
         * <code>userPoolId</code>. When the client ID is null, the same risk configuration is applied to all the
         * clients in the userPool.
         * </p>
         * <p>
         * Otherwise, <code>ClientId</code> is mapped to the client. When the client ID is not null, the user pool
         * configuration is overridden and the risk configuration for the client is used instead.
         * </p>
         * 
         * @param clientId
         *        The app client ID. If <code>ClientId</code> is null, then the risk configuration is mapped to
         *        <code>userPoolId</code>. When the client ID is null, the same risk configuration is applied to all the
         *        clients in the userPool.</p>
         *        <p>
         *        Otherwise, <code>ClientId</code> is mapped to the client. When the client ID is not null, the user
         *        pool configuration is overridden and the risk configuration for the client is used instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The compromised credentials risk configuration.
         * </p>
         * 
         * @param compromisedCredentialsRiskConfiguration
         *        The compromised credentials risk configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compromisedCredentialsRiskConfiguration(
                CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration);

        /**
         * <p>
         * The compromised credentials risk configuration.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link CompromisedCredentialsRiskConfigurationType.Builder} avoiding the need to create one manually via
         * {@link CompromisedCredentialsRiskConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link CompromisedCredentialsRiskConfigurationType.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #compromisedCredentialsRiskConfiguration(CompromisedCredentialsRiskConfigurationType)}.
         * 
         * @param compromisedCredentialsRiskConfiguration
         *        a consumer that will call methods on {@link CompromisedCredentialsRiskConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compromisedCredentialsRiskConfiguration(CompromisedCredentialsRiskConfigurationType)
         */
        default Builder compromisedCredentialsRiskConfiguration(
                Consumer<CompromisedCredentialsRiskConfigurationType.Builder> compromisedCredentialsRiskConfiguration) {
            return compromisedCredentialsRiskConfiguration(CompromisedCredentialsRiskConfigurationType.builder()
                    .applyMutation(compromisedCredentialsRiskConfiguration).build());
        }

        /**
         * <p>
         * The account takeover risk configuration.
         * </p>
         * 
         * @param accountTakeoverRiskConfiguration
         *        The account takeover risk configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration);

        /**
         * <p>
         * The account takeover risk configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link AccountTakeoverRiskConfigurationType.Builder}
         * avoiding the need to create one manually via {@link AccountTakeoverRiskConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccountTakeoverRiskConfigurationType.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #accountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationType)}.
         * 
         * @param accountTakeoverRiskConfiguration
         *        a consumer that will call methods on {@link AccountTakeoverRiskConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationType)
         */
        default Builder accountTakeoverRiskConfiguration(
                Consumer<AccountTakeoverRiskConfigurationType.Builder> accountTakeoverRiskConfiguration) {
            return accountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationType.builder()
                    .applyMutation(accountTakeoverRiskConfiguration).build());
        }

        /**
         * <p>
         * The configuration to override the risk decision.
         * </p>
         * 
         * @param riskExceptionConfiguration
         *        The configuration to override the risk decision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskExceptionConfiguration(RiskExceptionConfigurationType riskExceptionConfiguration);

        /**
         * <p>
         * The configuration to override the risk decision.
         * </p>
         * This is a convenience that creates an instance of the {@link RiskExceptionConfigurationType.Builder} avoiding
         * the need to create one manually via {@link RiskExceptionConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link RiskExceptionConfigurationType.Builder#build()} is called
         * immediately and its result is passed to {@link #riskExceptionConfiguration(RiskExceptionConfigurationType)}.
         * 
         * @param riskExceptionConfiguration
         *        a consumer that will call methods on {@link RiskExceptionConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #riskExceptionConfiguration(RiskExceptionConfigurationType)
         */
        default Builder riskExceptionConfiguration(Consumer<RiskExceptionConfigurationType.Builder> riskExceptionConfiguration) {
            return riskExceptionConfiguration(RiskExceptionConfigurationType.builder().applyMutation(riskExceptionConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String clientId;

        private CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration;

        private AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration;

        private RiskExceptionConfigurationType riskExceptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SetRiskConfigurationRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            clientId(model.clientId);
            compromisedCredentialsRiskConfiguration(model.compromisedCredentialsRiskConfiguration);
            accountTakeoverRiskConfiguration(model.accountTakeoverRiskConfiguration);
            riskExceptionConfiguration(model.riskExceptionConfiguration);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final CompromisedCredentialsRiskConfigurationType.Builder getCompromisedCredentialsRiskConfiguration() {
            return compromisedCredentialsRiskConfiguration != null ? compromisedCredentialsRiskConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder compromisedCredentialsRiskConfiguration(
                CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration) {
            this.compromisedCredentialsRiskConfiguration = compromisedCredentialsRiskConfiguration;
            return this;
        }

        public final void setCompromisedCredentialsRiskConfiguration(
                CompromisedCredentialsRiskConfigurationType.BuilderImpl compromisedCredentialsRiskConfiguration) {
            this.compromisedCredentialsRiskConfiguration = compromisedCredentialsRiskConfiguration != null ? compromisedCredentialsRiskConfiguration
                    .build() : null;
        }

        public final AccountTakeoverRiskConfigurationType.Builder getAccountTakeoverRiskConfiguration() {
            return accountTakeoverRiskConfiguration != null ? accountTakeoverRiskConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder accountTakeoverRiskConfiguration(
                AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration) {
            this.accountTakeoverRiskConfiguration = accountTakeoverRiskConfiguration;
            return this;
        }

        public final void setAccountTakeoverRiskConfiguration(
                AccountTakeoverRiskConfigurationType.BuilderImpl accountTakeoverRiskConfiguration) {
            this.accountTakeoverRiskConfiguration = accountTakeoverRiskConfiguration != null ? accountTakeoverRiskConfiguration
                    .build() : null;
        }

        public final RiskExceptionConfigurationType.Builder getRiskExceptionConfiguration() {
            return riskExceptionConfiguration != null ? riskExceptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder riskExceptionConfiguration(RiskExceptionConfigurationType riskExceptionConfiguration) {
            this.riskExceptionConfiguration = riskExceptionConfiguration;
            return this;
        }

        public final void setRiskExceptionConfiguration(RiskExceptionConfigurationType.BuilderImpl riskExceptionConfiguration) {
            this.riskExceptionConfiguration = riskExceptionConfiguration != null ? riskExceptionConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetRiskConfigurationRequest build() {
            return new SetRiskConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
