/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserMFASettingListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminGetUserResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, AdminGetUserResponse> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(AdminGetUserResponse.getter(AdminGetUserResponse::username)).setter(AdminGetUserResponse.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<List<AttributeType>> USER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserAttributes").getter(AdminGetUserResponse.getter(AdminGetUserResponse::userAttributes)).setter(AdminGetUserResponse.setter(Builder::userAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> USER_CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UserCreateDate").getter(AdminGetUserResponse.getter(AdminGetUserResponse::userCreateDate)).setter(AdminGetUserResponse.setter(Builder::userCreateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCreateDate").build()}).build();
    private static final SdkField<Instant> USER_LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UserLastModifiedDate").getter(AdminGetUserResponse.getter(AdminGetUserResponse::userLastModifiedDate)).setter(AdminGetUserResponse.setter(Builder::userLastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserLastModifiedDate").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(AdminGetUserResponse.getter(AdminGetUserResponse::enabled)).setter(AdminGetUserResponse.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> USER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserStatus").getter(AdminGetUserResponse.getter(AdminGetUserResponse::userStatusAsString)).setter(AdminGetUserResponse.setter(Builder::userStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStatus").build()}).build();
    private static final SdkField<List<MFAOptionType>> MFA_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MFAOptions").getter(AdminGetUserResponse.getter(AdminGetUserResponse::mfaOptions)).setter(AdminGetUserResponse.setter(Builder::mfaOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MFAOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MFAOptionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PREFERRED_MFA_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMfaSetting").getter(AdminGetUserResponse.getter(AdminGetUserResponse::preferredMfaSetting)).setter(AdminGetUserResponse.setter(Builder::preferredMfaSetting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMfaSetting").build()}).build();
    private static final SdkField<List<String>> USER_MFA_SETTING_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserMFASettingList").getter(AdminGetUserResponse.getter(AdminGetUserResponse::userMFASettingList)).setter(AdminGetUserResponse.setter(Builder::userMFASettingList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMFASettingList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, USER_ATTRIBUTES_FIELD, USER_CREATE_DATE_FIELD, USER_LAST_MODIFIED_DATE_FIELD, ENABLED_FIELD, USER_STATUS_FIELD, MFA_OPTIONS_FIELD, PREFERRED_MFA_SETTING_FIELD, USER_MFA_SETTING_LIST_FIELD));
    private final String username;
    private final List<AttributeType> userAttributes;
    private final Instant userCreateDate;
    private final Instant userLastModifiedDate;
    private final Boolean enabled;
    private final String userStatus;
    private final List<MFAOptionType> mfaOptions;
    private final String preferredMfaSetting;
    private final List<String> userMFASettingList;

    private AdminGetUserResponse(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.userAttributes = builder.userAttributes;
        this.userCreateDate = builder.userCreateDate;
        this.userLastModifiedDate = builder.userLastModifiedDate;
        this.enabled = builder.enabled;
        this.userStatus = builder.userStatus;
        this.mfaOptions = builder.mfaOptions;
        this.preferredMfaSetting = builder.preferredMfaSetting;
        this.userMFASettingList = builder.userMFASettingList;
    }

    public String username() {
        return this.username;
    }

    public boolean hasUserAttributes() {
        return this.userAttributes != null && !(this.userAttributes instanceof SdkAutoConstructList);
    }

    public List<AttributeType> userAttributes() {
        return this.userAttributes;
    }

    public Instant userCreateDate() {
        return this.userCreateDate;
    }

    public Instant userLastModifiedDate() {
        return this.userLastModifiedDate;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public UserStatusType userStatus() {
        return UserStatusType.fromValue(this.userStatus);
    }

    public String userStatusAsString() {
        return this.userStatus;
    }

    public boolean hasMfaOptions() {
        return this.mfaOptions != null && !(this.mfaOptions instanceof SdkAutoConstructList);
    }

    public List<MFAOptionType> mfaOptions() {
        return this.mfaOptions;
    }

    public String preferredMfaSetting() {
        return this.preferredMfaSetting;
    }

    public boolean hasUserMFASettingList() {
        return this.userMFASettingList != null && !(this.userMFASettingList instanceof SdkAutoConstructList);
    }

    public List<String> userMFASettingList() {
        return this.userMFASettingList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.userCreateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.userLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.userStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMfaSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.userMFASettingList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminGetUserResponse)) {
            return false;
        }
        AdminGetUserResponse other = (AdminGetUserResponse)((Object)obj);
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.userAttributes(), other.userAttributes()) && Objects.equals(this.userCreateDate(), other.userCreateDate()) && Objects.equals(this.userLastModifiedDate(), other.userLastModifiedDate()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.userStatusAsString(), other.userStatusAsString()) && Objects.equals(this.mfaOptions(), other.mfaOptions()) && Objects.equals(this.preferredMfaSetting(), other.preferredMfaSetting()) && Objects.equals(this.userMFASettingList(), other.userMFASettingList());
    }

    public String toString() {
        return ToString.builder((String)"AdminGetUserResponse").add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).add("UserAttributes", this.userAttributes()).add("UserCreateDate", (Object)this.userCreateDate()).add("UserLastModifiedDate", (Object)this.userLastModifiedDate()).add("Enabled", (Object)this.enabled()).add("UserStatus", (Object)this.userStatusAsString()).add("MFAOptions", this.mfaOptions()).add("PreferredMfaSetting", (Object)this.preferredMfaSetting()).add("UserMFASettingList", this.userMFASettingList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "UserAttributes": {
                return Optional.ofNullable(clazz.cast(this.userAttributes()));
            }
            case "UserCreateDate": {
                return Optional.ofNullable(clazz.cast(this.userCreateDate()));
            }
            case "UserLastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.userLastModifiedDate()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "UserStatus": {
                return Optional.ofNullable(clazz.cast(this.userStatusAsString()));
            }
            case "MFAOptions": {
                return Optional.ofNullable(clazz.cast(this.mfaOptions()));
            }
            case "PreferredMfaSetting": {
                return Optional.ofNullable(clazz.cast(this.preferredMfaSetting()));
            }
            case "UserMFASettingList": {
                return Optional.ofNullable(clazz.cast(this.userMFASettingList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminGetUserResponse, T> g) {
        return obj -> g.apply((AdminGetUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private String username;
        private List<AttributeType> userAttributes = DefaultSdkAutoConstructList.getInstance();
        private Instant userCreateDate;
        private Instant userLastModifiedDate;
        private Boolean enabled;
        private String userStatus;
        private List<MFAOptionType> mfaOptions = DefaultSdkAutoConstructList.getInstance();
        private String preferredMfaSetting;
        private List<String> userMFASettingList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdminGetUserResponse model) {
            super(model);
            this.username(model.username);
            this.userAttributes(model.userAttributes);
            this.userCreateDate(model.userCreateDate);
            this.userLastModifiedDate(model.userLastModifiedDate);
            this.enabled(model.enabled);
            this.userStatus(model.userStatus);
            this.mfaOptions(model.mfaOptions);
            this.preferredMfaSetting(model.preferredMfaSetting);
            this.userMFASettingList(model.userMFASettingList);
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final Collection<AttributeType.Builder> getUserAttributes() {
            return this.userAttributes != null ? (Collection)this.userAttributes.stream().map(AttributeType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userAttributes(Collection<AttributeType> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copy(userAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(AttributeType ... userAttributes) {
            this.userAttributes(Arrays.asList(userAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Consumer<AttributeType.Builder> ... userAttributes) {
            this.userAttributes(Stream.of(userAttributes).map(c -> (AttributeType)((AttributeType.Builder)AttributeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributes(Collection<AttributeType.BuilderImpl> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copyFromBuilder(userAttributes);
        }

        public final Instant getUserCreateDate() {
            return this.userCreateDate;
        }

        @Override
        public final Builder userCreateDate(Instant userCreateDate) {
            this.userCreateDate = userCreateDate;
            return this;
        }

        public final void setUserCreateDate(Instant userCreateDate) {
            this.userCreateDate = userCreateDate;
        }

        public final Instant getUserLastModifiedDate() {
            return this.userLastModifiedDate;
        }

        @Override
        public final Builder userLastModifiedDate(Instant userLastModifiedDate) {
            this.userLastModifiedDate = userLastModifiedDate;
            return this;
        }

        public final void setUserLastModifiedDate(Instant userLastModifiedDate) {
            this.userLastModifiedDate = userLastModifiedDate;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getUserStatus() {
            return this.userStatus;
        }

        @Override
        public final Builder userStatus(String userStatus) {
            this.userStatus = userStatus;
            return this;
        }

        @Override
        public final Builder userStatus(UserStatusType userStatus) {
            this.userStatus(userStatus == null ? null : userStatus.toString());
            return this;
        }

        public final void setUserStatus(String userStatus) {
            this.userStatus = userStatus;
        }

        public final Collection<MFAOptionType.Builder> getMfaOptions() {
            return this.mfaOptions != null ? (Collection)this.mfaOptions.stream().map(MFAOptionType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mfaOptions(Collection<MFAOptionType> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copy(mfaOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(MFAOptionType ... mfaOptions) {
            this.mfaOptions(Arrays.asList(mfaOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(Consumer<MFAOptionType.Builder> ... mfaOptions) {
            this.mfaOptions(Stream.of(mfaOptions).map(c -> (MFAOptionType)((MFAOptionType.Builder)MFAOptionType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMfaOptions(Collection<MFAOptionType.BuilderImpl> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copyFromBuilder(mfaOptions);
        }

        public final String getPreferredMfaSetting() {
            return this.preferredMfaSetting;
        }

        @Override
        public final Builder preferredMfaSetting(String preferredMfaSetting) {
            this.preferredMfaSetting = preferredMfaSetting;
            return this;
        }

        public final void setPreferredMfaSetting(String preferredMfaSetting) {
            this.preferredMfaSetting = preferredMfaSetting;
        }

        public final Collection<String> getUserMFASettingList() {
            return this.userMFASettingList;
        }

        @Override
        public final Builder userMFASettingList(Collection<String> userMFASettingList) {
            this.userMFASettingList = UserMFASettingListTypeCopier.copy(userMFASettingList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userMFASettingList(String ... userMFASettingList) {
            this.userMFASettingList(Arrays.asList(userMFASettingList));
            return this;
        }

        public final void setUserMFASettingList(Collection<String> userMFASettingList) {
            this.userMFASettingList = UserMFASettingListTypeCopier.copy(userMFASettingList);
        }

        @Override
        public AdminGetUserResponse build() {
            return new AdminGetUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AdminGetUserResponse> {
        public Builder username(String var1);

        public Builder userAttributes(Collection<AttributeType> var1);

        public Builder userAttributes(AttributeType ... var1);

        public Builder userAttributes(Consumer<AttributeType.Builder> ... var1);

        public Builder userCreateDate(Instant var1);

        public Builder userLastModifiedDate(Instant var1);

        public Builder enabled(Boolean var1);

        public Builder userStatus(String var1);

        public Builder userStatus(UserStatusType var1);

        public Builder mfaOptions(Collection<MFAOptionType> var1);

        public Builder mfaOptions(MFAOptionType ... var1);

        public Builder mfaOptions(Consumer<MFAOptionType.Builder> ... var1);

        public Builder preferredMfaSetting(String var1);

        public Builder userMFASettingList(Collection<String> var1);

        public Builder userMFASettingList(String ... var1);
    }
}

