/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A map containing a priority as a key, and recovery method name as a value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryOptionType implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryOptionType.Builder, RecoveryOptionType> {
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(RecoveryOptionType::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RecoveryOptionType::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIORITY_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer priority;

    private final String name;

    private RecoveryOptionType(BuilderImpl builder) {
        this.priority = builder.priority;
        this.name = builder.name;
    }

    /**
     * <p>
     * A positive integer specifying priority of a method with 1 being the highest priority.
     * </p>
     * 
     * @return A positive integer specifying priority of a method with 1 being the highest priority.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * <p>
     * Specifies the recovery method for a user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link RecoveryOptionNameType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Specifies the recovery method for a user.
     * @see RecoveryOptionNameType
     */
    public RecoveryOptionNameType name() {
        return RecoveryOptionNameType.fromValue(name);
    }

    /**
     * <p>
     * Specifies the recovery method for a user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link RecoveryOptionNameType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Specifies the recovery method for a user.
     * @see RecoveryOptionNameType
     */
    public String nameAsString() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryOptionType)) {
            return false;
        }
        RecoveryOptionType other = (RecoveryOptionType) obj;
        return Objects.equals(priority(), other.priority()) && Objects.equals(nameAsString(), other.nameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RecoveryOptionType").add("Priority", priority()).add("Name", nameAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryOptionType, T> g) {
        return obj -> g.apply((RecoveryOptionType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryOptionType> {
        /**
         * <p>
         * A positive integer specifying priority of a method with 1 being the highest priority.
         * </p>
         * 
         * @param priority
         *        A positive integer specifying priority of a method with 1 being the highest priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * Specifies the recovery method for a user.
         * </p>
         * 
         * @param name
         *        Specifies the recovery method for a user.
         * @see RecoveryOptionNameType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryOptionNameType
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the recovery method for a user.
         * </p>
         * 
         * @param name
         *        Specifies the recovery method for a user.
         * @see RecoveryOptionNameType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryOptionNameType
         */
        Builder name(RecoveryOptionNameType name);
    }

    static final class BuilderImpl implements Builder {
        private Integer priority;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryOptionType model) {
            priority(model.priority);
            name(model.name);
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(RecoveryOptionNameType name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public RecoveryOptionType build() {
            return new RecoveryOptionType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
