/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ClientMetadataTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUserAttributeVerificationCodeRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, GetUserAttributeVerificationCodeRequest> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessToken").getter(GetUserAttributeVerificationCodeRequest.getter(GetUserAttributeVerificationCodeRequest::accessToken)).setter(GetUserAttributeVerificationCodeRequest.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()}).build();
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(GetUserAttributeVerificationCodeRequest.getter(GetUserAttributeVerificationCodeRequest::attributeName)).setter(GetUserAttributeVerificationCodeRequest.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<Map<String, String>> CLIENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ClientMetadata").getter(GetUserAttributeVerificationCodeRequest.getter(GetUserAttributeVerificationCodeRequest::clientMetadata)).setter(GetUserAttributeVerificationCodeRequest.setter(Builder::clientMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, ATTRIBUTE_NAME_FIELD, CLIENT_METADATA_FIELD));
    private final String accessToken;
    private final String attributeName;
    private final Map<String, String> clientMetadata;

    private GetUserAttributeVerificationCodeRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.attributeName = builder.attributeName;
        this.clientMetadata = builder.clientMetadata;
    }

    public String accessToken() {
        return this.accessToken;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public boolean hasClientMetadata() {
        return this.clientMetadata != null && !(this.clientMetadata instanceof SdkAutoConstructMap);
    }

    public Map<String, String> clientMetadata() {
        return this.clientMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientMetadata() ? this.clientMetadata() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserAttributeVerificationCodeRequest)) {
            return false;
        }
        GetUserAttributeVerificationCodeRequest other = (GetUserAttributeVerificationCodeRequest)((Object)obj);
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.attributeName(), other.attributeName()) && this.hasClientMetadata() == other.hasClientMetadata() && Objects.equals(this.clientMetadata(), other.clientMetadata());
    }

    public String toString() {
        return ToString.builder((String)"GetUserAttributeVerificationCodeRequest").add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("AttributeName", (Object)this.attributeName()).add("ClientMetadata", this.hasClientMetadata() ? this.clientMetadata() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "ClientMetadata": {
                return Optional.ofNullable(clazz.cast(this.clientMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUserAttributeVerificationCodeRequest, T> g) {
        return obj -> g.apply((GetUserAttributeVerificationCodeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String accessToken;
        private String attributeName;
        private Map<String, String> clientMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserAttributeVerificationCodeRequest model) {
            super(model);
            this.accessToken(model.accessToken);
            this.attributeName(model.attributeName);
            this.clientMetadata(model.clientMetadata);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final Map<String, String> getClientMetadata() {
            if (this.clientMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.clientMetadata;
        }

        @Override
        public final Builder clientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
            return this;
        }

        public final void setClientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUserAttributeVerificationCodeRequest build() {
            return new GetUserAttributeVerificationCodeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUserAttributeVerificationCodeRequest> {
        public Builder accessToken(String var1);

        public Builder attributeName(String var1);

        public Builder clientMetadata(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

