/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MFAOptionType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MFAOptionType> {
    private static final SdkField<String> DELIVERY_MEDIUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryMedium").getter(MFAOptionType.getter(MFAOptionType::deliveryMediumAsString)).setter(MFAOptionType.setter(Builder::deliveryMedium)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryMedium").build()}).build();
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(MFAOptionType.getter(MFAOptionType::attributeName)).setter(MFAOptionType.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_MEDIUM_FIELD, ATTRIBUTE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deliveryMedium;
    private final String attributeName;

    private MFAOptionType(BuilderImpl builder) {
        this.deliveryMedium = builder.deliveryMedium;
        this.attributeName = builder.attributeName;
    }

    public DeliveryMediumType deliveryMedium() {
        return DeliveryMediumType.fromValue(this.deliveryMedium);
    }

    public String deliveryMediumAsString() {
        return this.deliveryMedium;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryMediumAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MFAOptionType)) {
            return false;
        }
        MFAOptionType other = (MFAOptionType)obj;
        return Objects.equals(this.deliveryMediumAsString(), other.deliveryMediumAsString()) && Objects.equals(this.attributeName(), other.attributeName());
    }

    public String toString() {
        return ToString.builder((String)"MFAOptionType").add("DeliveryMedium", (Object)this.deliveryMediumAsString()).add("AttributeName", (Object)this.attributeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryMedium": {
                return Optional.ofNullable(clazz.cast(this.deliveryMediumAsString()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MFAOptionType, T> g) {
        return obj -> g.apply((MFAOptionType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryMedium;
        private String attributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(MFAOptionType model) {
            this.deliveryMedium(model.deliveryMedium);
            this.attributeName(model.attributeName);
        }

        public final String getDeliveryMedium() {
            return this.deliveryMedium;
        }

        @Override
        public final Builder deliveryMedium(String deliveryMedium) {
            this.deliveryMedium = deliveryMedium;
            return this;
        }

        @Override
        public final Builder deliveryMedium(DeliveryMediumType deliveryMedium) {
            this.deliveryMedium(deliveryMedium == null ? null : deliveryMedium.toString());
            return this;
        }

        public final void setDeliveryMedium(String deliveryMedium) {
            this.deliveryMedium = deliveryMedium;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public MFAOptionType build() {
            return new MFAOptionType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MFAOptionType> {
        public Builder deliveryMedium(String var1);

        public Builder deliveryMedium(DeliveryMediumType var1);

        public Builder attributeName(String var1);
    }
}

