/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryDetailsType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignUpResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, SignUpResponse> {
    private static final SdkField<Boolean> USER_CONFIRMED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UserConfirmed").getter(SignUpResponse.getter(SignUpResponse::userConfirmed)).setter(SignUpResponse.setter(Builder::userConfirmed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserConfirmed").build()}).build();
    private static final SdkField<CodeDeliveryDetailsType> CODE_DELIVERY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodeDeliveryDetails").getter(SignUpResponse.getter(SignUpResponse::codeDeliveryDetails)).setter(SignUpResponse.setter(Builder::codeDeliveryDetails)).constructor(CodeDeliveryDetailsType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeDeliveryDetails").build()}).build();
    private static final SdkField<String> USER_SUB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserSub").getter(SignUpResponse.getter(SignUpResponse::userSub)).setter(SignUpResponse.setter(Builder::userSub)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSub").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_CONFIRMED_FIELD, CODE_DELIVERY_DETAILS_FIELD, USER_SUB_FIELD));
    private final Boolean userConfirmed;
    private final CodeDeliveryDetailsType codeDeliveryDetails;
    private final String userSub;

    private SignUpResponse(BuilderImpl builder) {
        super(builder);
        this.userConfirmed = builder.userConfirmed;
        this.codeDeliveryDetails = builder.codeDeliveryDetails;
        this.userSub = builder.userSub;
    }

    public Boolean userConfirmed() {
        return this.userConfirmed;
    }

    public CodeDeliveryDetailsType codeDeliveryDetails() {
        return this.codeDeliveryDetails;
    }

    public String userSub() {
        return this.userSub;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userConfirmed());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeDeliveryDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.userSub());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignUpResponse)) {
            return false;
        }
        SignUpResponse other = (SignUpResponse)((Object)obj);
        return Objects.equals(this.userConfirmed(), other.userConfirmed()) && Objects.equals(this.codeDeliveryDetails(), other.codeDeliveryDetails()) && Objects.equals(this.userSub(), other.userSub());
    }

    public String toString() {
        return ToString.builder((String)"SignUpResponse").add("UserConfirmed", (Object)this.userConfirmed()).add("CodeDeliveryDetails", (Object)this.codeDeliveryDetails()).add("UserSub", (Object)this.userSub()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserConfirmed": {
                return Optional.ofNullable(clazz.cast(this.userConfirmed()));
            }
            case "CodeDeliveryDetails": {
                return Optional.ofNullable(clazz.cast(this.codeDeliveryDetails()));
            }
            case "UserSub": {
                return Optional.ofNullable(clazz.cast(this.userSub()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SignUpResponse, T> g) {
        return obj -> g.apply((SignUpResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private Boolean userConfirmed;
        private CodeDeliveryDetailsType codeDeliveryDetails;
        private String userSub;

        private BuilderImpl() {
        }

        private BuilderImpl(SignUpResponse model) {
            super(model);
            this.userConfirmed(model.userConfirmed);
            this.codeDeliveryDetails(model.codeDeliveryDetails);
            this.userSub(model.userSub);
        }

        public final Boolean getUserConfirmed() {
            return this.userConfirmed;
        }

        @Override
        public final Builder userConfirmed(Boolean userConfirmed) {
            this.userConfirmed = userConfirmed;
            return this;
        }

        public final void setUserConfirmed(Boolean userConfirmed) {
            this.userConfirmed = userConfirmed;
        }

        public final CodeDeliveryDetailsType.Builder getCodeDeliveryDetails() {
            return this.codeDeliveryDetails != null ? this.codeDeliveryDetails.toBuilder() : null;
        }

        @Override
        public final Builder codeDeliveryDetails(CodeDeliveryDetailsType codeDeliveryDetails) {
            this.codeDeliveryDetails = codeDeliveryDetails;
            return this;
        }

        public final void setCodeDeliveryDetails(CodeDeliveryDetailsType.BuilderImpl codeDeliveryDetails) {
            this.codeDeliveryDetails = codeDeliveryDetails != null ? codeDeliveryDetails.build() : null;
        }

        public final String getUserSub() {
            return this.userSub;
        }

        @Override
        public final Builder userSub(String userSub) {
            this.userSub = userSub;
            return this;
        }

        public final void setUserSub(String userSub) {
            this.userSub = userSub;
        }

        @Override
        public SignUpResponse build() {
            return new SignUpResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SignUpResponse> {
        public Builder userConfirmed(Boolean var1);

        public Builder codeDeliveryDetails(CodeDeliveryDetailsType var1);

        default public Builder codeDeliveryDetails(Consumer<CodeDeliveryDetailsType.Builder> codeDeliveryDetails) {
            return this.codeDeliveryDetails((CodeDeliveryDetailsType)((CodeDeliveryDetailsType.Builder)CodeDeliveryDetailsType.builder().applyMutation(codeDeliveryDetails)).build());
        }

        public Builder userSub(String var1);
    }
}

