/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIdentityProviderRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<UpdateIdentityProviderRequest.Builder, UpdateIdentityProviderRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(UpdateIdentityProviderRequest::userPoolId))
            .setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderName").getter(getter(UpdateIdentityProviderRequest::providerName))
            .setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderName").build()).build();

    private static final SdkField<Map<String, String>> PROVIDER_DETAILS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ProviderDetails")
            .getter(getter(UpdateIdentityProviderRequest::providerDetails))
            .setter(setter(Builder::providerDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderDetails").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTE_MAPPING_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AttributeMapping")
            .getter(getter(UpdateIdentityProviderRequest::attributeMapping))
            .setter(setter(Builder::attributeMapping))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeMapping").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> IDP_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IdpIdentifiers")
            .getter(getter(UpdateIdentityProviderRequest::idpIdentifiers))
            .setter(setter(Builder::idpIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdpIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            PROVIDER_NAME_FIELD, PROVIDER_DETAILS_FIELD, ATTRIBUTE_MAPPING_FIELD, IDP_IDENTIFIERS_FIELD));

    private final String userPoolId;

    private final String providerName;

    private final Map<String, String> providerDetails;

    private final Map<String, String> attributeMapping;

    private final List<String> idpIdentifiers;

    private UpdateIdentityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.providerName = builder.providerName;
        this.providerDetails = builder.providerDetails;
        this.attributeMapping = builder.attributeMapping;
        this.idpIdentifiers = builder.idpIdentifiers;
    }

    /**
     * <p>
     * The user pool ID.
     * </p>
     * 
     * @return The user pool ID.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The identity provider name.
     * </p>
     * 
     * @return The identity provider name.
     */
    public String providerName() {
        return providerName;
    }

    /**
     * Returns true if the ProviderDetails property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProviderDetails() {
        return providerDetails != null && !(providerDetails instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The identity provider details to be updated, such as <code>MetadataURL</code> and <code>MetadataFile</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProviderDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identity provider details to be updated, such as <code>MetadataURL</code> and
     *         <code>MetadataFile</code>.
     */
    public Map<String, String> providerDetails() {
        return providerDetails;
    }

    /**
     * Returns true if the AttributeMapping property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAttributeMapping() {
        return attributeMapping != null && !(attributeMapping instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The identity provider attribute mapping to be changed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributeMapping()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identity provider attribute mapping to be changed.
     */
    public Map<String, String> attributeMapping() {
        return attributeMapping;
    }

    /**
     * Returns true if the IdpIdentifiers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIdpIdentifiers() {
        return idpIdentifiers != null && !(idpIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of identity provider identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIdpIdentifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of identity provider identifiers.
     */
    public List<String> idpIdentifiers() {
        return idpIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(hasProviderDetails() ? providerDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeMapping() ? attributeMapping() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIdpIdentifiers() ? idpIdentifiers() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdentityProviderRequest)) {
            return false;
        }
        UpdateIdentityProviderRequest other = (UpdateIdentityProviderRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(providerName(), other.providerName())
                && hasProviderDetails() == other.hasProviderDetails()
                && Objects.equals(providerDetails(), other.providerDetails())
                && hasAttributeMapping() == other.hasAttributeMapping()
                && Objects.equals(attributeMapping(), other.attributeMapping())
                && hasIdpIdentifiers() == other.hasIdpIdentifiers() && Objects.equals(idpIdentifiers(), other.idpIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateIdentityProviderRequest").add("UserPoolId", userPoolId())
                .add("ProviderName", providerName()).add("ProviderDetails", hasProviderDetails() ? providerDetails() : null)
                .add("AttributeMapping", hasAttributeMapping() ? attributeMapping() : null)
                .add("IdpIdentifiers", hasIdpIdentifiers() ? idpIdentifiers() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ProviderName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "ProviderDetails":
            return Optional.ofNullable(clazz.cast(providerDetails()));
        case "AttributeMapping":
            return Optional.ofNullable(clazz.cast(attributeMapping()));
        case "IdpIdentifiers":
            return Optional.ofNullable(clazz.cast(idpIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdentityProviderRequest, T> g) {
        return obj -> g.apply((UpdateIdentityProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIdentityProviderRequest> {
        /**
         * <p>
         * The user pool ID.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The identity provider name.
         * </p>
         * 
         * @param providerName
         *        The identity provider name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The identity provider details to be updated, such as <code>MetadataURL</code> and <code>MetadataFile</code>.
         * </p>
         * 
         * @param providerDetails
         *        The identity provider details to be updated, such as <code>MetadataURL</code> and
         *        <code>MetadataFile</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerDetails(Map<String, String> providerDetails);

        /**
         * <p>
         * The identity provider attribute mapping to be changed.
         * </p>
         * 
         * @param attributeMapping
         *        The identity provider attribute mapping to be changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeMapping(Map<String, String> attributeMapping);

        /**
         * <p>
         * A list of identity provider identifiers.
         * </p>
         * 
         * @param idpIdentifiers
         *        A list of identity provider identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idpIdentifiers(Collection<String> idpIdentifiers);

        /**
         * <p>
         * A list of identity provider identifiers.
         * </p>
         * 
         * @param idpIdentifiers
         *        A list of identity provider identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idpIdentifiers(String... idpIdentifiers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String providerName;

        private Map<String, String> providerDetails = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> attributeMapping = DefaultSdkAutoConstructMap.getInstance();

        private List<String> idpIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdentityProviderRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            providerName(model.providerName);
            providerDetails(model.providerDetails);
            attributeMapping(model.attributeMapping);
            idpIdentifiers(model.idpIdentifiers);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getProviderName() {
            return providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final Map<String, String> getProviderDetails() {
            if (providerDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return providerDetails;
        }

        @Override
        public final Builder providerDetails(Map<String, String> providerDetails) {
            this.providerDetails = ProviderDetailsTypeCopier.copy(providerDetails);
            return this;
        }

        public final void setProviderDetails(Map<String, String> providerDetails) {
            this.providerDetails = ProviderDetailsTypeCopier.copy(providerDetails);
        }

        public final Map<String, String> getAttributeMapping() {
            if (attributeMapping instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributeMapping;
        }

        @Override
        public final Builder attributeMapping(Map<String, String> attributeMapping) {
            this.attributeMapping = AttributeMappingTypeCopier.copy(attributeMapping);
            return this;
        }

        public final void setAttributeMapping(Map<String, String> attributeMapping) {
            this.attributeMapping = AttributeMappingTypeCopier.copy(attributeMapping);
        }

        public final Collection<String> getIdpIdentifiers() {
            if (idpIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return idpIdentifiers;
        }

        @Override
        public final Builder idpIdentifiers(Collection<String> idpIdentifiers) {
            this.idpIdentifiers = IdpIdentifiersListTypeCopier.copy(idpIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idpIdentifiers(String... idpIdentifiers) {
            idpIdentifiers(Arrays.asList(idpIdentifiers));
            return this;
        }

        public final void setIdpIdentifiers(Collection<String> idpIdentifiers) {
            this.idpIdentifiers = IdpIdentifiersListTypeCopier.copy(idpIdentifiers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIdentityProviderRequest build() {
            return new UpdateIdentityProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
